/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.repository.api;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.Activator;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.model.RemoteFileDescriptor;
import org.modelbus.desktop.model.RemoteFileEditorInput;
import org.modelbus.desktop.repository.RepositoryTreeContentProvider;
import org.modelbus.desktop.repository.RepositoryTreeLabelProvider;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.Session;

public class RepositoriesView
extends ViewPart
implements Observer {
    private TreeViewer repositoryViewer;
    public static final String ID = "org.modelbus.desktop.RepositoriesView";
    private Shell shell;

    private RepositoryDirEntry createRepositoryRoot() {
        Session session = UserSessionHelper.getInstance().getSession();
        if (session == null) {
            return null;
        }
        try {
            return ModelBusCoreLib.getRepositoryHelper().getRoot(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createPartControl(final Composite parent) {
        this.shell = parent.getShell();
        this.repositoryViewer = new TreeViewer(parent);
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoryTreeContentProvider());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeLabelProvider());
        this.repositoryViewer.setInput((Object)this.createRepositoryRoot());
        this.repositoryViewer.setComparator(new ViewerComparator(){
            private static final long serialVersionUID = -133245970071052235L;

            public int compare(Viewer viewer, Object e1, Object e2) {
                RepositoryDirEntry left = (RepositoryDirEntry)e1;
                RepositoryDirEntry right = (RepositoryDirEntry)e2;
                return left.getName().toLowerCase().compareTo(right.getName().toLowerCase());
            }
        });
        this.repositoryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositoryDirEntry item;
                if (UserSessionHelper.getInstance().getSession() == null) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (item = (RepositoryDirEntry)((IStructuredSelection)selection).getFirstElement()) != null) {
                    if (item.getKind() == RepositoryNodeKind.DIR) {
                        RepositoriesView.this.repositoryViewer.expandToLevel((Object)item, 1);
                    } else if (item.getKind() == RepositoryNodeKind.FILE) {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            RemoteFileDescriptor fileDescriptor = new RemoteFileDescriptor(URI.createURI((String)item.getUri()), item.getRevision());
                            page.openEditor((IEditorInput)new RemoteFileEditorInput(fileDescriptor), "org.modelbus.desktop.ModelEditor");
                        }
                        catch (Exception e) {
                            MessageDialog.openInformation((Shell)parent.getShell(), (String)"Information", (String)("File could not be opened: " + e.getMessage()));
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Action action = new Action("Refresh"){

            public void run() {
                RepositoriesView.this.update(null, null);
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("icons/common/refresh.gif"));
        action.setToolTipText("Refresh");
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
        this.wireContextMenu();
        ModelBusDesktopUtil.getInstance().getStatus().addObserver(this, true);
    }

    private void wireContextMenu() {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("mgt"));
        Menu menu = manager.createContextMenu(this.repositoryViewer.getControl());
        this.repositoryViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.repositoryViewer);
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoriesView.this.repositoryViewer.setInput((Object)RepositoriesView.this.createRepositoryRoot());
                RepositoriesView.this.repositoryViewer.refresh();
            }
        });
    }
}

