/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementLeaf;
import org.modelbus.tools.diffmerge.model.ReferenceDiffElement;

class ReferenceLeaf
extends DiffElementLeaf {
    ReferenceLeaf(DiffElement parent) {
        super(parent);
    }

    public String toString() {
        String representation;
        switch (this.getParent().getSource()) {
            case Left: {
                representation = this.getLeftRepresentation();
                break;
            }
            default: {
                representation = this.getRightRepresentation();
            }
        }
        return representation;
    }

    private String getLeftRepresentation() {
        String representation;
        ReferenceDiffElement parent = (ReferenceDiffElement)this.getParent();
        EObject value = parent.getValue();
        switch (parent.getKind()) {
            case Add: {
                representation = String.format("The element %s has been added", value.toString());
                break;
            }
            case Remove: {
                representation = String.format("The element %s has been removed", value.toString());
                break;
            }
            case Change: {
                representation = "No representation for changed references";
                break;
            }
            default: {
                representation = "No representation for moved reference";
            }
        }
        return representation;
    }

    private String getRightRepresentation() {
        String representation;
        ReferenceDiffElement parent = (ReferenceDiffElement)this.getParent();
        EObject value = parent.getValue();
        switch (parent.getKind()) {
            case Add: {
                representation = String.format("The element %s has been removed", value.toString());
                break;
            }
            case Remove: {
                representation = String.format("The element %s has been added", value.toString());
                break;
            }
            case Change: {
                representation = "No representation for changed references";
                break;
            }
            default: {
                representation = "No representation for moved reference";
            }
        }
        return representation;
    }
}

