/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws;

import java.net.URI;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.URIID;

public class JaxWsNamespace
extends Namespace {
    private static final long serialVersionUID = 9122791543292976376L;
    private static final String NAME = JaxWsNamespace.class.getName();
    private static final String DESCRIPTION = "JAX-WS Namespace";
    private static final String SCHEME = "jaxws";
    private static final String SCHEME_START = "jaxws:";
    private static final JaxWsNamespace INSTANCE = new JaxWsNamespace();

    public JaxWsNamespace() {
        super(NAME, DESCRIPTION);
    }

    public URIID createInstance(Object[] parameters) throws IDCreateException {
        try {
            String init = this.getInitStringFromExternalForm(parameters);
            if (init != null) {
                return new URIID((Namespace)this, new URI(init));
            }
            if (parameters.length == 0) {
                throw new IDCreateException("Cannot create URIID, no parameter provided");
            }
            Object firstParam = parameters[0];
            if (firstParam instanceof URI) {
                URI uri = (URI)parameters[0];
                this.assertScheme(uri);
                return new URIID((Namespace)this, uri);
            }
            if (firstParam instanceof String) {
                String paramString = (String)firstParam;
                URI uri = new URI(paramString);
                return new URIID((Namespace)this, uri);
            }
            throw new IDCreateException("Cannot create URIID");
        }
        catch (Exception e) {
            throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", (Throwable)e);
        }
    }

    private void assertScheme(URI uri) {
        String actualScheme = uri.getScheme();
        if (!SCHEME.equals(actualScheme)) {
            throw new IDCreateException("Expected scheme: jaxws, but found: " + actualScheme);
        }
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class<?>[][] getSupportedParameterTypes() {
        return new Class[][]{{String.class}, {URI.class}};
    }

    public static JaxWsNamespace getInstance() {
        return INSTANCE;
    }
}

