/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.extension;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLOpaqueElementBodyChangeFactory
extends AbstractUMLChangeFactory {
    @Override
    public boolean handles(Diff input) {
        AttributeChange attributeChange;
        return input instanceof AttributeChange && !this.refinesOpaqueElementBodyChange(input) && (this.isChangeOfBodyAttributeWithLanguage(attributeChange = (AttributeChange)input) || this.isMoveOfLanguageAttributeValue(attributeChange));
    }

    private boolean refinesOpaqueElementBodyChange(Diff diff) {
        for (Diff refinedDiff : diff.getRefines()) {
            if (!(refinedDiff instanceof OpaqueElementBodyChange)) continue;
            return true;
        }
        return false;
    }

    private boolean isChangeOfBodyAttributeWithLanguage(AttributeChange diff) {
        return UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute((Diff)diff) && this.affectsBodyWithLanguage(diff);
    }

    private boolean affectsBodyWithLanguage(AttributeChange diff) {
        return this.getAffectedLanguage(diff).isPresent();
    }

    private Optional<String> getAffectedLanguage(AttributeChange diff) {
        Optional<String> language = Optional.absent();
        if (UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute((Diff)diff)) {
            EObject changedObject = this.getObjectContainingTheChangedValue(diff);
            List<String> languages = UMLCompareUtil.getOpaqueElementLanguages(changedObject);
            List<String> bodies = UMLCompareUtil.getOpaqueElementBodies(changedObject);
            int changedIndex = bodies.indexOf(diff.getValue());
            language = this.safeGet(languages, changedIndex);
        } else if (UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute((Diff)diff)) {
            language = Optional.of((Object)((String)diff.getValue()));
        }
        return language;
    }

    private EObject getObjectContainingTheChangedValue(AttributeChange diff) {
        if (!DifferenceKind.DELETE.equals((Object)diff.getKind())) {
            return this.getDifferenceSourceEObject(diff);
        }
        return this.getOriginalSideEObject(diff);
    }

    private EObject getDifferenceSourceEObject(AttributeChange diff) {
        if (DifferenceSource.LEFT.equals((Object)diff.getSource())) {
            return diff.getMatch().getLeft();
        }
        return diff.getMatch().getRight();
    }

    private EObject getOriginalSideEObject(AttributeChange diff) {
        EObject changedObject = diff.getMatch().getComparison().isThreeWay() ? diff.getMatch().getOrigin() : (DifferenceSource.RIGHT.equals((Object)diff.getSource()) ? diff.getMatch().getLeft() : diff.getMatch().getRight());
        return changedObject;
    }

    private Optional<String> safeGet(List<String> list, int index) {
        Optional item = index != -1 && list.size() > index ? Optional.of((Object)list.get(index)) : Optional.absent();
        return item;
    }

    private boolean isMoveOfLanguageAttributeValue(AttributeChange diff) {
        return DifferenceKind.MOVE.equals((Object)diff.getKind()) && UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute((Diff)diff);
    }

    @Override
    public Diff create(Diff input) {
        OpaqueElementBodyChange extension = (OpaqueElementBodyChange)super.create(input);
        extension.setLanguage((String)this.getAffectedLanguage((AttributeChange)input).get());
        extension.setKind(this.computeDifferenceKind(extension));
        extension.setConflict(null);
        return extension;
    }

    private DifferenceKind computeDifferenceKind(OpaqueElementBodyChange bodyChange) {
        EList refiningDiffs = bodyChange.getRefinedBy();
        DifferenceKind differenceKind = Iterables.all((Iterable)refiningDiffs, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)) ? DifferenceKind.ADD : (Iterables.all((Iterable)refiningDiffs, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)) ? DifferenceKind.DELETE : (Iterables.all((Iterable)refiningDiffs, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)) ? DifferenceKind.MOVE : DifferenceKind.CHANGE));
        return differenceKind;
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)extension;
        bodyChange.getRefinedBy().add((Object)refiningDiff);
        this.collectAndAddOtherRefiningDiffs(bodyChange, refiningDiff);
    }

    private void collectAndAddOtherRefiningDiffs(OpaqueElementBodyChange bodyChange, Diff refiningDiff) {
        RefinementCollector collector = new RefinementCollector((AttributeChange)refiningDiff);
        Iterable<Diff> collectedRefiningDiffs = collector.collect();
        for (Diff otherRefiningDiff : collectedRefiningDiffs) {
            bodyChange.getRefinedBy().add((Object)otherRefiningDiff);
        }
    }

    public Class<? extends UMLDiff> getExtensionKind() {
        return OpaqueElementBodyChange.class;
    }

    public UMLDiff createExtension() {
        return UMLCompareFactory.eINSTANCE.createOpaqueElementBodyChange();
    }

    @Override
    protected EObject getDiscriminant(Diff input) {
        return (EObject)Iterables.find(this.getDiscriminants(input), (Predicate)Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(OpaqueAction.class), Predicates.instanceOf(OpaqueBehavior.class), Predicates.instanceOf(OpaqueExpression.class)}), null);
    }

    @Override
    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return new AbstractUMLChangeFactory.DiscriminantsGetter(this){

            public Set<EObject> caseOpaqueAction(OpaqueAction object) {
                return this.getObjectAsSet((EObject)object);
            }

            public Set<EObject> caseOpaqueBehavior(OpaqueBehavior object) {
                return this.getObjectAsSet((EObject)object);
            }

            public Set<EObject> caseOpaqueExpression(OpaqueExpression object) {
                return this.getObjectAsSet((EObject)object);
            }

            private Set<EObject> getObjectAsSet(EObject object) {
                HashSet<EObject> result = new HashSet<EObject>();
                result.add(object);
                return result;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefinementCollector {
        private final AttributeChange referenceDiff;
        private String language;

        public RefinementCollector(AttributeChange referenceDiff) {
            this.referenceDiff = referenceDiff;
            this.language = (String)this.getLanguage(referenceDiff).get();
        }

        public Iterable<Diff> collect() {
            EList differencesOfMatch = this.referenceDiff.getMatch().getDifferences();
            return Iterables.filter((Iterable)differencesOfMatch, this.isRefiningDiff());
        }

        private Predicate<Diff> isRefiningDiff() {
            return new Predicate<Diff>(){

                public boolean apply(Diff diff) {
                    return diff instanceof AttributeChange && RefinementCollector.this.isRefiningAttributeChange((AttributeChange)diff);
                }
            };
        }

        private boolean isRefiningAttributeChange(AttributeChange attributeChange) {
            return this.isChangeOfBodyOrLanguageAttribute(attributeChange) && this.isOnSameSide((Diff)this.referenceDiff, (Diff)attributeChange) && this.concernsSameObjectAndLanguage(attributeChange) && this.isCorrespondingChangeType(attributeChange);
        }

        private boolean isOnSameSide(Diff diff1, Diff diff2) {
            return diff1.getSource().equals((Object)diff2.getSource());
        }

        private boolean concernsSameObjectAndLanguage(AttributeChange attributeChange) {
            return this.concernsSameObject(attributeChange) && this.concernsSameLanguage(attributeChange);
        }

        private boolean concernsSameObject(AttributeChange attributeChange) {
            return this.referenceDiff.getMatch().equals(attributeChange.getMatch());
        }

        private boolean concernsSameLanguage(AttributeChange attributeChange) {
            return this.language.equals(this.getLanguage(attributeChange).get());
        }

        private Optional<String> getLanguage(AttributeChange attributeChange) {
            Optional languageOfAttributeChange = UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute((Diff)attributeChange) ? UMLOpaqueElementBodyChangeFactory.this.getAffectedLanguage(attributeChange) : (UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute((Diff)attributeChange) ? Optional.of((Object)((String)attributeChange.getValue())) : Optional.absent());
            return languageOfAttributeChange;
        }

        private boolean isCorrespondingChangeType(AttributeChange attributeChange) {
            boolean isCorrespondingChangeType = DifferenceKind.MOVE.equals((Object)this.referenceDiff.getKind()) ? DifferenceKind.MOVE.equals((Object)attributeChange.getKind()) : !DifferenceKind.MOVE.equals((Object)attributeChange.getKind());
            return isCorrespondingChangeType;
        }

        private boolean isChangeOfBodyOrLanguageAttribute(AttributeChange attributeChange) {
            return UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute((Diff)attributeChange) || UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute((Diff)attributeChange);
        }
    }
}

