/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.properties.editing;

import java.util.HashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.joor.Reflect;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.properties.PropertyElement;
import org.modelbus.tools.modelbusexplorer.properties.PropertyValueChangeListener;
import org.modelbus.tools.modelbusexplorer.properties.PropertyValueChangedEvent;
import org.modelbus.tools.modelbusexplorer.properties.editing.EditingSupportUpdateObject;
import org.modelbus.tools.modelbusexplorer.properties.editing.IEditingSupport;
import org.modelbus.tools.modelbusexplorer.properties.editing.NoEditingSupport;
import org.modelbus.tools.modelbusexplorer.properties.editing.PropertyElementEditingSupport;

class PropertyElementEditingSupportImpl
extends PropertyElementEditingSupport {
    private final IEditingSupport defaultEditingSupport;
    private final HashMap<Class<? extends PropertyElement>, IEditingSupport> cachedEditingsSupports = new HashMap();
    private boolean editingSupported = true;
    private final ModelBusEventBus eventBus;

    PropertyElementEditingSupportImpl(ColumnViewer viewer, ModelBusEventBus eventBus) {
        super(viewer);
        this.eventBus = eventBus;
        this.defaultEditingSupport = new NoEditingSupport(viewer);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.getCorrectEditingSupportForElement(element).getCellEditor(element);
    }

    protected boolean canEdit(Object element) {
        if (!this.editingSupported) {
            return false;
        }
        return this.getCorrectEditingSupportForElement(element).canEdit(element);
    }

    protected Object getValue(Object element) {
        return this.getCorrectEditingSupportForElement(element).getValue(element);
    }

    protected void setValue(Object element, Object value) {
        this.getCorrectEditingSupportForElement(element).setValue(element, value);
        this.eventBus.post((Object)new PropertyValueChangedEvent(element, value));
    }

    private IEditingSupport getCorrectEditingSupportForElement(Object element) {
        Class<?> clazz = element.getClass();
        if (this.cachedEditingsSupports.containsKey(clazz)) {
            return this.cachedEditingsSupports.get(clazz);
        }
        return this.defaultEditingSupport;
    }

    @Override
    public void addPropertyValueChagnedListener(PropertyValueChangeListener listener) {
        this.eventBus.register((Object)listener);
    }

    @Override
    public void removePropertyValueChagnedListener(PropertyValueChangeListener listener) {
        this.eventBus.unregister((Object)listener);
    }

    @Override
    public boolean isEditingSupporterd() {
        return this.editingSupported;
    }

    @Override
    public void setEditingSupported(boolean value) {
        this.editingSupported = value;
    }

    void addEditingSupports(Class<? extends PropertyElement> propertyClazz, IEditingSupport editingSupport) {
        this.cachedEditingsSupports.put(propertyClazz, editingSupport);
    }

    void removeEditingSupport(Class<? extends PropertyElement> proppertyClass) {
        this.cachedEditingsSupports.remove(proppertyClass.getName());
    }

    @Handler
    public void updateEditingSupport(EditingSupportUpdateObject update) {
        IEditingSupport support = (IEditingSupport)Reflect.on(update.getEditingSupport()).create(new Object[]{this.getViewer()}).get();
        this.cachedEditingsSupports.put(update.getPropertyElement(), support);
    }
}

