/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services;

import java.util.HashMap;
import java.util.Map;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.repository.descriptor.Property;
import org.modelbus.dosgi.repository.descriptor.Session;
import org.modelbus.dosgi.services.api.AbstractModelBusConsumerActivator;
import org.modelbus.dosgi.services.api.AbstractModelBusServiceActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class AbstractModelBusActivator
implements BundleActivator {
    protected BundleContext context;
    private ModelBusServiceConfiguration configuration;
    private Session session;
    protected static Map<String, AbstractModelBusConsumerActivator> instances = new HashMap<String, AbstractModelBusConsumerActivator>();

    public void start(BundleContext context) throws Exception {
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this instanceof AbstractModelBusServiceActivator) {
            try {
                ModelBusCoreLib.getServicesHelper().unpublishService(this.getSession(), this.getConfiguration());
            }
            catch (Exception exception) {}
        }
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = new Session();
            this.session.setId("abcdefghijklmnopqrstuvxyz123456789");
            Property propertyUserName = new Property();
            propertyUserName.setKey("username");
            propertyUserName.setValue("Admin");
            Property propertyPassword = new Property();
            propertyPassword.setKey("password");
            propertyPassword.setValue("ModelBus");
            this.session.getProperties().add(propertyUserName);
            this.session.getProperties().add(propertyPassword);
        }
        return this.session;
    }

    protected final ModelBusServiceConfiguration getConfiguration() throws ModelBusServiceException {
        if (this.configuration == null) {
            ModelBusServiceConfiguration config = this.getDefaultConfiguration();
            this.configure(config);
            config.validate();
            this.configuration = config;
        }
        return this.configuration;
    }

    private final ModelBusServiceConfiguration getDefaultConfiguration() {
        ModelBusServiceConfiguration defaultConfig = new ModelBusServiceConfiguration(this.getServiceInterface().getName());
        defaultConfig.setOption("osgiServiceContext", (Object)("/" + this.getServiceInterface().getSimpleName().toLowerCase()));
        defaultConfig.setOption("databinding", (Object)"aegis");
        defaultConfig.setOption("frontend", (Object)"jaxws");
        defaultConfig.setOption("enableMTOM", (Object)Boolean.TRUE);
        return defaultConfig;
    }

    public abstract Class<?> getServiceInterface();

    protected abstract void configure(ModelBusServiceConfiguration var1);

    public BundleContext getBundleContext() {
        return this.context;
    }
}

