/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.provider.jaxws.util.internal.JaxWsConfigUtil;
import org.eclipse.ecf.provider.jaxws.util.internal.MtomUtil;

public class ClientUtil {
    private static final String WSDL_QUERY = "?wsdl";

    private ClientUtil() {
        throw new IllegalStateException();
    }

    public static <T> T getEndpointReference(Class<T> interfaceClass, JaxWsParams params) throws WebServiceException {
        WebService endpointDef = interfaceClass.getAnnotation(WebService.class);
        QName serviceName = JaxWsConfigUtil.getServiceName(params, null, endpointDef, interfaceClass);
        QName portName = JaxWsConfigUtil.getPortName(params, null, endpointDef, interfaceClass);
        String wsdlLocation = ClientUtil.getWsdlLocation(params, endpointDef);
        Service s = null;
        if (wsdlLocation.indexOf(58) > 0) {
            try {
                URL wsdlUrl = new URL(wsdlLocation);
                s = Service.create((URL)wsdlUrl, (QName)serviceName);
            }
            catch (MalformedURLException malformedURLException) {
                s = null;
            }
        }
        if (s == null) {
            s = Service.create((QName)serviceName);
        }
        MTOMFeature mtomFeature = MtomUtil.getMTOMFeature(params);
        Object port = s.getPort(portName, interfaceClass, new WebServiceFeature[]{mtomFeature});
        ClientUtil.setTimeoutValues(params, port);
        return (T)port;
    }

    private static String getWsdlLocation(JaxWsParams params, WebService endpointDef) {
        String wsdlLocation = params.getWsdlLocation();
        if (!ClientUtil.isDefined(wsdlLocation)) {
            wsdlLocation = endpointDef.wsdlLocation();
        }
        if (!ClientUtil.isDefined(wsdlLocation)) {
            String address = params.getAddress();
            wsdlLocation = String.valueOf(address) + WSDL_QUERY;
        }
        return wsdlLocation;
    }

    private static boolean isDefined(String str) {
        return str != null && !str.trim().isEmpty();
    }

    private static void setTimeoutValues(JaxWsParams params, Object port) {
        if (!(port instanceof BindingProvider)) {
            return;
        }
        Map requestContext = ((BindingProvider)port).getRequestContext();
        int connectTimeout = params.getConnectTimeout();
        int requestTimeout = params.getRequestTimeout();
        requestContext.put("com.sun.xml.ws.connect.timeout", connectTimeout);
        requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
        requestContext.put("com.sun.xml.internal.ws.connect.timeout", connectTimeout);
        requestContext.put("com.sun.xml.internal.ws.request.timeout", requestTimeout);
        requestContext.put("javax.xml.ws.client.connectionTimeout", Integer.toString(connectTimeout));
        requestContext.put("javax.xml.ws.client.receiveTimeout", Integer.toString(requestTimeout));
        requestContext.put("CONNECTION_TIMEOUT", connectTimeout);
        requestContext.put("SO_TIMEOUT", requestTimeout);
    }
}

