/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.component.log.LogFormatter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.IntrospectionSupport;

public class LogComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Processor logger;
        LoggingLevel level = this.getLoggingLevel(parameters);
        String marker = this.getAndRemoveParameter(parameters, "marker", String.class);
        Integer groupSize = this.getAndRemoveParameter(parameters, "groupSize", Integer.class);
        Long groupInterval = this.getAndRemoveParameter(parameters, "groupInterval", Long.class);
        CamelLogger camelLogger = new CamelLogger(remaining, level, marker);
        if (groupSize != null) {
            logger = new ThroughputLogger(camelLogger, groupSize);
        } else if (groupInterval != null) {
            Boolean groupActiveOnly = this.getAndRemoveParameter(parameters, "groupActiveOnly", Boolean.class, Boolean.TRUE);
            Long groupDelay = this.getAndRemoveParameter(parameters, "groupDelay", Long.class);
            logger = new ThroughputLogger(camelLogger, this.getCamelContext(), groupInterval, groupDelay, groupActiveOnly);
        } else {
            LogFormatter formatter = new LogFormatter();
            IntrospectionSupport.setProperties(formatter, parameters);
            logger = new CamelLogProcessor(camelLogger, formatter);
        }
        LogEndpoint endpoint = new LogEndpoint(uri, this);
        this.setProperties(endpoint, parameters);
        return new LogEndpoint(uri, this, logger);
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase());
    }
}

