/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

public class Statistic {
    private final UpdateMode updateMode;
    private long value;
    private long updateCount;

    public Statistic(String name, Object owner, UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public synchronized void updateValue(long newValue) {
        switch (this.updateMode) {
            case COUNTER: {
                this.value += newValue;
                break;
            }
            case VALUE: {
                this.value = newValue;
                break;
            }
            case DIFFERENCE: {
                this.value -= newValue;
                if (this.value >= 0L) break;
                this.value = -this.value;
                break;
            }
            case MAXIMUM: {
                if (this.updateCount != 0L && this.value >= newValue) break;
                this.value = newValue;
                break;
            }
            case MINIMUM: {
                if (this.updateCount != 0L && this.value <= newValue) break;
                this.value = newValue;
                break;
            }
        }
        ++this.updateCount;
    }

    public synchronized void increment() {
        this.updateValue(1L);
    }

    public synchronized long getValue() {
        return this.value;
    }

    public synchronized long getUpdateCount() {
        return this.updateCount;
    }

    public synchronized void reset() {
        this.value = 0L;
        this.updateCount = 0L;
    }

    public String toString() {
        return "" + this.value;
    }

    public static enum UpdateMode {
        VALUE,
        DIFFERENCE,
        COUNTER,
        MAXIMUM,
        MINIMUM;

    }
}

