/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services.api;

import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.services.api.AbstractModelBusConsumerActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ModelBusServiceTracker<T> {
    private ServiceTracker<T, T> tracker;
    private ServiceTracker<RepositoryService, RepositoryService> repoServiceTracker;
    private final AbstractModelBusConsumerActivator<T> consumer;
    private ServiceReference<T> serviceReference;
    private ServiceReference<RepositoryService> repoServiceReference;
    private boolean notified = false;

    public ModelBusServiceTracker(AbstractModelBusConsumerActivator<T> consumer) {
        this.consumer = consumer;
    }

    public void open() {
        Class<T> serviceInterface = this.consumer.getServiceInterface();
        BundleContext bundleContext = this.consumer.getBundleContext();
        this.tracker = new ServiceTracker<T, T>(bundleContext, serviceInterface, null){

            public T addingService(ServiceReference<T> reference) {
                Object svc = super.addingService(reference);
                ModelBusServiceTracker.this.serviceReference = reference;
                if (ModelBusServiceTracker.this.repoServiceTracker == null || ModelBusServiceTracker.this.repoServiceReference != null) {
                    ModelBusServiceTracker.this.notifyAboutServiceReference();
                }
                return svc;
            }

            public void removedService(ServiceReference<T> reference, T service) {
                super.removedService(reference, service);
                if (ModelBusServiceTracker.this.serviceReference == null) {
                    return;
                }
                if (!ModelBusServiceTracker.this.serviceReference.equals(reference)) {
                    return;
                }
                ModelBusServiceTracker.this.serviceReference = null;
                ModelBusServiceTracker.this.notifyAboutServiceReferenceRemoved();
            }
        };
        this.tracker.open();
        if (!serviceInterface.equals(RepositoryService.class)) {
            this.repoServiceTracker = new ServiceTracker<RepositoryService, RepositoryService>(bundleContext, RepositoryService.class, null){

                public RepositoryService addingService(ServiceReference<RepositoryService> reference) {
                    RepositoryService svc = (RepositoryService)super.addingService(reference);
                    ModelBusServiceTracker.this.repoServiceReference = reference;
                    if (ModelBusServiceTracker.this.serviceReference != null) {
                        ModelBusServiceTracker.this.notifyAboutServiceReference();
                    }
                    return svc;
                }

                public void removedService(ServiceReference<RepositoryService> reference, RepositoryService service) {
                    super.removedService(reference, (Object)service);
                    ModelBusServiceTracker.this.repoServiceReference = null;
                    ModelBusServiceTracker.this.notifyAboutServiceReferenceRemoved();
                }
            };
            this.repoServiceTracker.open();
        }
    }

    private void notifyAboutServiceReferenceRemoved() {
        this.notified = false;
        this.consumer.setServiceReference(null);
    }

    public void waitForService(long time) throws ModelBusServiceException {
        try {
            this.tracker.waitForService(time);
        }
        catch (InterruptedException e) {
            throw new ModelBusServiceException((Throwable)e);
        }
    }

    private void notifyAboutServiceReference() {
        if (this.notified) {
            return;
        }
        this.notified = true;
        this.consumer.setServiceReference(this.serviceReference);
    }

    public void close() {
        this.tracker.close();
        if (this.repoServiceTracker != null) {
            this.repoServiceTracker.close();
        }
    }
}

