/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.repository.descriptor.Property;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.repository.descriptor.Session;

public class ModelBusServiceConfiguration {
    public static final String OPTION_ENABLE_MTOM = "enableMTOM";
    public static final String OPTION_SERVICE_ADDRESS = "serviceAddress";
    public static final String OPTION_EFFECTIVE_SERVICE_ADDRESS = "effectiveServiceAddress";
    public static final String OPTION_FRONTEND = "frontend";
    public static final String OPTION_DATABINDING = "databinding";
    public static final String OPTION_OSGI_HTTP_SERVICE_CONTEXT = "osgiServiceContext";
    public static final Integer DEFAULT_SERVICE_PORT = 9090;
    public static final String FRONTEND_SIMPLE = "simple";
    public static final String FRONTEND_JAXWS = "jaxws";
    public static final String DATABINDING_JAXB = "jaxb";
    public static final String DATABINDING_SIMPLE = "aegis";
    private Map<String, Object> options;
    private String serviceInterface;
    private String serviceName;
    private static Session session;
    private static Map<String, ModelBusServiceConfiguration> configs;

    static {
        configs = new HashMap<String, ModelBusServiceConfiguration>();
    }

    public ModelBusServiceConfiguration() {
    }

    public ModelBusServiceConfiguration(String serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.options = new HashMap<String, Object>();
    }

    public void setOption(String key, Object value) {
        this.options.put(key, value);
    }

    public void unsetOption(String key) {
        if (this.isOptionSet(key)) {
            this.options.remove(key);
        }
    }

    public boolean isOptionSet(String key) {
        return this.options.containsKey(key);
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public Map<String, Object> getOptions() {
        return new HashMap<String, Object>(this.options);
    }

    public void validate() throws ModelBusServiceException {
        if (this.isOptionSet(OPTION_SERVICE_ADDRESS)) {
            Object serviceAddress = this.getOption(OPTION_SERVICE_ADDRESS);
            if (!(serviceAddress instanceof String)) {
                throw new ModelBusServiceException("Unexpected type of service address for service: " + serviceAddress.getClass().getName());
            }
            if (serviceAddress == null || serviceAddress.equals("")) {
                throw new ModelBusServiceException("No service address set.");
            }
        } else if (this.isOptionSet(OPTION_OSGI_HTTP_SERVICE_CONTEXT)) {
            Object serviceContext = this.getOption(OPTION_OSGI_HTTP_SERVICE_CONTEXT);
            if (!(serviceContext instanceof String)) {
                throw new ModelBusServiceException("Unexpected type of service context for service: " + serviceContext.getClass().getName());
            }
            if (serviceContext == null || serviceContext.equals("")) {
                throw new ModelBusServiceException("No service context set.");
            }
        } else {
            throw new ModelBusServiceException("Either ModelBusServiceConfiguration option OPTION_SERVICE_ADDRESS or OPTION_OSGI_HTTP_SERVICE_CONTEXT must be set.");
        }
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public static void register(ModelBusServiceConfiguration config) {
        configs.put(config.getServiceInterface(), config);
        if (!RepositoryService.class.getName().equals(config.getServiceInterface())) {
            try {
                ModelBusCoreLib.getServicesHelper().publishService(ModelBusServiceConfiguration.getSession(), config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Session getSession() {
        if (session == null) {
            session = new Session();
            session.setId(EcoreUtil.generateUUID());
            Property propertyUserName = new Property();
            propertyUserName.setKey("username");
            propertyUserName.setValue("Admin");
            Property propertyPassword = new Property();
            propertyPassword.setKey("password");
            propertyPassword.setValue("ModelBus");
            session.getProperties().add(propertyUserName);
            session.getProperties().add(propertyPassword);
        }
        return session;
    }

    public static ModelBusServiceConfiguration get(Class serviceInterface) {
        return configs.get(serviceInterface.getName());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

