/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.compare;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.compare.ModelCompareEditorInput;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.dosgi.repository.descriptor.ExtendedRepositoryLogEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.Session;

public class CompareRepositoryItemWithPreviousActionDelegate
implements IObjectActionDelegate {
    private RepositoryDirEntry item;

    public void run(IAction action) {
        ExtendedRepositoryLogEntry logEntry;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        RepositoryDirEntry otherEntry = ModelBusDesktopUtil.cloneRepositoryEntry(this.item);
        IRepositoryHelper repoHelper = ModelBusCoreLib.getRepositoryHelper();
        Session session = UserSessionHelper.getInstance().getSession();
        try {
            logEntry = repoHelper.getExtendedLogEntry(session, this.item.getRevision(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (logEntry == null) {
            throw new RuntimeException("Unable to get log info for revision: " + this.item.getRevision());
        }
        otherEntry.setRevision(logEntry.getPreviousRevision());
        try {
            page.openEditor((IEditorInput)new ModelCompareEditorInput(this.item, otherEntry), "org.modelbus.desktop.CompareEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Iterator selIt;
        this.item = null;
        if (UserSessionHelper.getInstance().getSession() == null) {
            action.setEnabled(false);
            return;
        }
        if (selection instanceof IStructuredSelection && (selIt = ((IStructuredSelection)selection).iterator()).hasNext()) {
            this.item = (RepositoryDirEntry)selIt.next();
        }
        action.setEnabled(this.item != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

