/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.dosgi.repository.descriptor.Session;

public class RemoteFileDescriptor {
    private URI fileURI;
    private String revision;

    public RemoteFileDescriptor(URI fileURI, String revision) {
        this.fileURI = fileURI;
        this.revision = revision;
    }

    public String getFileName() {
        if (this.fileURI.segmentCount() > 0) {
            return this.fileURI.lastSegment();
        }
        return this.fileURI.host();
    }

    public URI getURI() {
        return this.fileURI;
    }

    public String getRevision() {
        return this.revision;
    }

    public InputStream getInputStream() {
        Session session = UserSessionHelper.getInstance().getSession();
        if (session == null) {
            throw new RuntimeException("Login required");
        }
        try {
            return ModelBusCoreLib.getRepositoryHelper().checkOutFile(session, this.getURI(), this.getRevision());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

