/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.dosgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.core.lib.dosgi.AbstractModelBusHelper;
import org.modelbus.core.lib.types.DefaultModelBusDataSource;
import org.modelbus.core.lib.types.IModelBusDataSource;
import org.modelbus.core.lib.types.Status;
import org.modelbus.core.lib.util.DynamicEFactoryImpl;
import org.modelbus.core.lib.util.ModelBusClientURIHandler;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.core.lib.util.ModelBusPackageRegistry;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.DependenciesInfo;
import org.modelbus.dosgi.repository.descriptor.ExtendedRepositoryLogEntry;
import org.modelbus.dosgi.repository.descriptor.IncomingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockInfo;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.OptionMapEntry;
import org.modelbus.dosgi.repository.descriptor.OptionsMap;
import org.modelbus.dosgi.repository.descriptor.OutgoingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.Session;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;

public class RepositoryHelper
extends AbstractModelBusHelper
implements IRepositoryHelper {
    private static HashMap<String, String> local2remoteProjectPaths;
    private List<String> filesToCheckin;
    private String[] modelExtensions = new String[0];
    private boolean checkDependencies = false;
    private ModelBusPackageRegistry modelBusPackageRegistry;
    private final List<EPackage> packages = new ArrayList<EPackage>();
    private ModelBusClientURIHandler modelBusURIHandler;

    public RepositoryHelper() {
    }

    public RepositoryHelper(boolean checkDependencies, String[] modelExtensions) {
        this();
        this.checkDependencies = checkDependencies;
        this.modelExtensions = modelExtensions;
    }

    private ModelBusPackageRegistry getModelBusPackageRegistry() {
        if (this.modelBusPackageRegistry == null) {
            this.modelBusPackageRegistry = new ModelBusPackageRegistry();
        }
        return this.modelBusPackageRegistry;
    }

    private ModelBusClientURIHandler getModelBusURIHandler(Session session) {
        if (this.modelBusURIHandler == null) {
            this.modelBusURIHandler = new ModelBusClientURIHandler((IRepositoryHelper)this);
        }
        this.modelBusURIHandler.setSession(session);
        return this.modelBusURIHandler;
    }

    public void setProjectPathMap(HashMap<String, String> localProjectPaths) {
        local2remoteProjectPaths = localProjectPaths;
    }

    public HashMap<String, String> getProjectPathMap() {
        if (local2remoteProjectPaths == null) {
            local2remoteProjectPaths = new HashMap();
        }
        return local2remoteProjectPaths;
    }

    public List<String> getFilesToCheckin() {
        if (this.filesToCheckin == null) {
            this.filesToCheckin = new ArrayList<String>();
        }
        return this.filesToCheckin;
    }

    public String authenticate(String username, String password) throws RepositoryRuntimeException, InvalidValueException {
        return this.getService().authenticate(username, password);
    }

    public void checkInModel(Session session, Resource resource, Map<?, ?> saveOptions, String logMessage) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInModel(session, resource, null, saveOptions, logMessage, null);
    }

    public void checkInModel(Session session, Resource resource, Map<?, ?> saveOptions, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInModel(session, resource, null, saveOptions, logMessage, options);
    }

    public void checkInModel(Session session, Resource resource, URI localResourceUri, Map<?, ?> saveOptions, String logMessage) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInModel(session, resource, localResourceUri, saveOptions, logMessage, null);
    }

    public void checkInModel(Session session, Resource resource, URI localResourceUri, Map<?, ?> saveOptions, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this._checkInModel(session, resource, localResourceUri, saveOptions, logMessage, options);
    }

    public void checkOutModel(Session session, Resource resource, Map<?, ?> loadOptions) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        this.checkOutModelWithRevision(session, resource, "-1", loadOptions);
    }

    public void checkOutModelWithRevision(Session session, Resource resource, String revision, Map<?, ?> loadOptions) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        this.checkOutModelWithRevision(session, resources, revision, loadOptions);
    }

    private static boolean rootIsEPackage(Resource resource) {
        EList contents = resource.getContents();
        if (contents == null) {
            return false;
        }
        if (contents.isEmpty()) {
            return false;
        }
        return contents.get(0) instanceof EPackage;
    }

    private String getRootNSURI(Resource resource) {
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        return ePackage.getNsURI();
    }

    private void createProfilesMap(List<Resource> resources, HashMap<URI, URI> profiles) {
        for (Resource referencedResource : resources) {
            URI changedProfileUri;
            URI mappedURI;
            URI referencedResourceUri = referencedResource.getURI();
            String uriAuthority = referencedResourceUri.authority();
            String uriLastSegment = referencedResourceUri.lastSegment();
            boolean isPathmapEntry = ModelBusCoreUtil.URIUtil.isPathMapURI((URI)referencedResourceUri);
            if (ModelBusCoreUtil.URIUtil.uriStartsWith((URI)referencedResourceUri, (String)"http:///schemas/")) {
                profiles.put(referencedResourceUri, referencedResourceUri);
                continue;
            }
            if (isPathmapEntry && (mappedURI = (URI)URIConverter.URI_MAP.get(referencedResourceUri)) != null) {
                profiles.put(referencedResourceUri, ModelBusCoreUtil.URIUtil.toRemoteURI((URI)mappedURI));
                continue;
            }
            if (uriLastSegment != null) {
                if (isPathmapEntry) {
                    if ("UML_PROFILES".equals(referencedResourceUri.authority())) {
                        changedProfileUri = URI.createURI((String)("http://www.eclipse.org/uml2/schemas/" + uriLastSegment));
                        profiles.put(referencedResourceUri, changedProfileUri);
                        continue;
                    }
                    if (!uriLastSegment.endsWith(".profile.uml")) continue;
                    changedProfileUri = URI.createURI((String)("http:///schemas/" + uriLastSegment));
                    profiles.put(referencedResourceUri, changedProfileUri);
                    continue;
                }
                if (ModelBusCoreUtil.StringUtil.stringIsInArray((String)uriLastSegment, (String[])new String[]{"Ecore.profile.uml", "Standard.profile.uml", "StandardL2.profile.uml", "StandardL3.profile.uml"}) || !uriLastSegment.endsWith(".profile.uml")) continue;
                changedProfileUri = URI.createURI((String)("http:///schemas/" + uriLastSegment));
                profiles.put(referencedResourceUri, changedProfileUri);
                continue;
            }
            if (uriAuthority == null || !isPathmapEntry || !uriAuthority.endsWith(".profile.uml")) continue;
            changedProfileUri = URI.createURI((String)("http:///schemas/" + uriAuthority));
            profiles.put(referencedResourceUri, changedProfileUri);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[] getProjectMap(URI referencedResourceUri, URI resourceUri, URI localUri) {
        projectMap = new String[2];
        resUriPathlength = resourceUri.segmentCount();
        referencedResUriPathLength = referencedResourceUri.segmentCount();
        originalResUriLength = resUriPathlength;
        localUriPathlength = localUri.segmentCount();
        if (localUriPathlength != 0) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            if (resourceUri.segment(resUriPathlength - 1).equals(localUri.segment(localUriPathlength - 1))) {
                resourceUri = resourceUri.trimSegments(1);
                localUri = localUri.trimSegments(1);
            }
            --resUriPathlength;
            --localUriPathlength;
lbl13:
            // 2 sources

            ** while (resUriPathlength > 0 && localUriPathlength > 0)
        }
lbl14:
        // 1 sources

        if (originalResUriLength == resUriPathlength) {
            return null;
        }
        count = 0;
        while (count < referencedResUriPathLength && count < localUriPathlength) {
            if (!localUri.segment(count).equals(referencedResourceUri.segment(count))) {
                localUri = localUri.trimSegments(1);
                break;
            }
            ++count;
        }
        projectMap[0] = localUri.toString();
        projectMap[1] = resourceUri.toString();
        return projectMap;
    }

    private String toRemoteURI(URI referencedResourceUri, URI resourceURI) {
        String remoteUri = "";
        if (ModelBusCoreUtil.URIUtil.isPathMapURI((URI)referencedResourceUri)) {
            remoteUri = referencedResourceUri.toString().replace("pathmap://", "http://");
        } else if (ModelBusCoreUtil.URIUtil.isFileURI((URI)referencedResourceUri)) {
            remoteUri = this.local2remoteUri(referencedResourceUri);
        } else if (referencedResourceUri.isPlatformPlugin()) {
            remoteUri = referencedResourceUri.toString().replace("platform:/plugin/", "http://");
        } else if (referencedResourceUri.isPlatformResource()) {
            remoteUri = referencedResourceUri.toString().replace("platform:/resource/", "http://");
        }
        if (remoteUri == null || remoteUri.equals("")) {
            remoteUri = referencedResourceUri.toString();
        }
        if (!ModelBusCoreUtil.URIUtil.isHTTPURI((String)remoteUri)) {
            remoteUri = URI.createURI((String)remoteUri).scheme() != null ? resourceURI.trimSegments(1).appendSegment(URI.createURI((String)remoteUri).lastSegment()).toString() : "http://" + remoteUri;
        }
        if (URI.createURI((String)remoteUri).path() == null) {
            remoteUri = String.valueOf(remoteUri) + "/" + referencedResourceUri.toString();
        }
        return remoteUri;
    }

    private boolean _fileExists(Session session, URI fileURI, String revision) throws RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException, IOException {
        List<RepositoryDirEntry> repoEntries = this.getInfo(session, fileURI, revision);
        if (repoEntries == null) {
            return false;
        }
        for (RepositoryDirEntry repoEntry : repoEntries) {
            if (!RepositoryNodeKind.FILE.equals((Object)repoEntry.getKind())) continue;
            return true;
        }
        return false;
    }

    private void _checkInModel(Session session, Resource resource, URI localResourceUri, Map<?, ?> saveOptions, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        if (localResourceUri == null) {
            localResourceUri = URI.createURI((String)"");
        }
        this.filesToCheckin = new ArrayList<String>();
        List<Resource> collection = RepositoryHelper.getAllreferencedResourcesInclusiveMetaReferencesTransitive(resource);
        Collections.reverse(collection);
        HashMap<URI, URI> profiles = new HashMap<URI, URI>();
        this.createProfilesMap(collection, profiles);
        for (Resource referencedResource : collection) {
            String packageNSUri;
            URI changedUri;
            URI originalUri;
            Map<String, Object> trimmedOptionMap = RepositoryHelper.createResourceOptionsMap(options, referencedResource.getURI(), resource.getURI());
            URI referencedResourceUri = referencedResource.getURI();
            String fragment = referencedResourceUri.fragment();
            if (fragment != null) continue;
            URI resourceURI = resource.getURI();
            String remoteUriString = this.toRemoteURI(referencedResourceUri, resourceURI);
            try {
                if (!referencedResourceUri.equals(resourceURI) && this._fileExists(session, URI.createURI((String)remoteUriString), "-1")) {
                    continue;
                }
            }
            catch (InvalidRevisionException e) {
                throw new RuntimeException(e);
            }
            if (ModelBusCoreUtil.URIUtil.isPathMapURI((URI)referencedResourceUri)) {
                if (profiles.containsKey(referencedResourceUri)) {
                    originalUri = referencedResourceUri;
                    changedUri = profiles.get(originalUri);
                    referencedResource.setURI(changedUri);
                    if (!this.exists(session, changedUri, "-1")) {
                        this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, trimmedOptionMap);
                    }
                    referencedResource.setURI(originalUri);
                    originalUri = this.adjustUri(originalUri);
                    if (this.exists(session, originalUri, "-1")) continue;
                    this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, trimmedOptionMap);
                    continue;
                }
                if (RepositoryHelper.rootIsEPackage(referencedResource) && (packageNSUri = this.getRootNSURI(referencedResource)) != null && !packageNSUri.isEmpty() && !referencedResourceUri.toString().equals(packageNSUri)) {
                    referencedResource.setURI(URI.createURI((String)packageNSUri));
                    this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, trimmedOptionMap);
                    referencedResource.setURI(referencedResourceUri);
                }
                this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, trimmedOptionMap);
                continue;
            }
            if (ModelBusCoreUtil.URIUtil.isFileURI((URI)referencedResourceUri) || ModelBusCoreUtil.URIUtil.isFileURI((URI)localResourceUri) && referencedResourceUri.lastSegment() != null && localResourceUri.lastSegment() != null && referencedResourceUri.lastSegment().equals(localResourceUri.lastSegment())) {
                boolean exists;
                String packageNSUri2;
                String fileLocation;
                if (!referencedResource.equals(resource) && referencedResourceUri.isFile()) {
                    this.filesToCheckin.add(referencedResourceUri.toString());
                } else if (!referencedResource.equals(resource) && localResourceUri.isFile()) {
                    this.filesToCheckin.add(localResourceUri.toString());
                }
                if (ModelBusCoreUtil.URIUtil.isUMLProfileURI((URI)referencedResourceUri)) {
                    boolean exists2;
                    originalUri = referencedResourceUri;
                    changedUri = profiles.get(originalUri);
                    String fileLocation2 = referencedResourceUri.toFileString();
                    if (fileLocation2 == null) {
                        fileLocation2 = localResourceUri.toFileString();
                    }
                    File file = new File(fileLocation2);
                    FileDataSource fileDataSource = new FileDataSource(file);
                    DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
                    try {
                        exists2 = this._fileExists(session, changedUri, "-1");
                    }
                    catch (InvalidRevisionException e) {
                        throw new RuntimeException(e);
                    }
                    if (!exists2) {
                        this._checkInFile(session, changedUri, "-1", dataHandler, logMessage, trimmedOptionMap);
                    }
                    if (!ModelBusCoreUtil.URIUtil.isHTTPURI((String)remoteUriString)) {
                        String[] projectUriMap = this.getProjectMap(referencedResourceUri, resource.getURI(), localResourceUri);
                        remoteUriString = projectUriMap != null && originalUri.toString().contains(projectUriMap[0]) ? originalUri.toString().replace(projectUriMap[0], projectUriMap[1]) : resource.getURI().trimSegments(1).appendSegment(referencedResourceUri.lastSegment()).toString();
                    }
                    remoteUriString = ModelBusCoreUtil.URIUtil.toRemoteURI((String)remoteUriString).toString();
                    try {
                        exists2 = this._fileExists(session, URI.createURI((String)remoteUriString), "-1");
                    }
                    catch (InvalidRevisionException e) {
                        throw new RuntimeException(e);
                    }
                    if (!referencedResourceUri.equals(resource.getURI()) && exists2) continue;
                    this._checkInFile(session, URI.createURI((String)remoteUriString), "-1", dataHandler, logMessage, trimmedOptionMap);
                    continue;
                }
                if (!ModelBusCoreUtil.URIUtil.isHTTPURI((String)remoteUriString)) {
                    String[] projectUriMap = this.getProjectMap(referencedResourceUri, resource.getURI(), localResourceUri);
                    remoteUriString = projectUriMap != null && referencedResourceUri.toString().contains(projectUriMap[0]) ? referencedResourceUri.toString().replace(projectUriMap[0], projectUriMap[1]) : resource.getURI().trimSegments(1).appendSegment(referencedResourceUri.lastSegment()).toString();
                }
                if ((fileLocation = referencedResourceUri.toFileString()) == null) {
                    fileLocation = localResourceUri.toFileString();
                }
                File file = new File(fileLocation);
                FileDataSource fileDataSource = new FileDataSource(file);
                DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
                remoteUriString = ModelBusCoreUtil.URIUtil.toRemoteURI((String)remoteUriString).toString();
                this._checkInFile(session, URI.createURI((String)remoteUriString), "-1", dataHandler, logMessage, trimmedOptionMap);
                if (!RepositoryHelper.rootIsEPackage(referencedResource) || (packageNSUri2 = this.getRootNSURI(referencedResource)) == null || packageNSUri2.isEmpty() || referencedResourceUri.toString().equals(packageNSUri2)) continue;
                try {
                    exists = this._fileExists(session, URI.createURI((String)packageNSUri2), "-1");
                }
                catch (InvalidRevisionException e) {
                    throw new RuntimeException(e);
                }
                if (!referencedResourceUri.equals(resource.getURI()) && exists) continue;
                this._checkInFile(session, URI.createURI((String)packageNSUri2), "-1", dataHandler, logMessage, trimmedOptionMap);
                continue;
            }
            if (RepositoryHelper.rootIsEPackage(referencedResource) && (packageNSUri = this.getRootNSURI(referencedResource)) != null && !packageNSUri.isEmpty() && !referencedResourceUri.toString().equals(packageNSUri)) {
                referencedResource.setURI(URI.createURI((String)packageNSUri));
                HashMap<String, Object> newOptions = new HashMap<String, Object>();
                newOptions.put("MB_SymLink", ModelBusCoreUtil.URIUtil.toRemoteURI((URI)referencedResourceUri).toString());
                this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, newOptions);
                referencedResource.setURI(URI.createURI((String)remoteUriString));
                trimmedOptionMap.put("MB_SymLink", packageNSUri);
            }
            if (!ModelBusCoreUtil.URIUtil.isHTTPURI((URI)referencedResource.getURI())) {
                referencedResource.setURI(URI.createURI((String)remoteUriString));
            }
            this.checkInModelWithForce(session, referencedResource, resourceSet, saveOptions, logMessage, trimmedOptionMap);
            if (referencedResourceUri.equals(referencedResource.getURI())) continue;
            referencedResource.setURI(referencedResourceUri);
        }
    }

    private static Map<String, Object> createResourceOptionsMap(Map<String, Object> map, URI resourceURI, URI contextResourceURI) {
        HashMap<String, Object> mapCopy = new HashMap<String, Object>();
        if (map == null) {
            return mapCopy;
        }
        for (String key : map.keySet()) {
            mapCopy.put(key, map.get(key));
        }
        if (!resourceURI.equals(contextResourceURI)) {
            mapCopy.remove("Content-Type");
        }
        return mapCopy;
    }

    private URI adjustUri(URI originalUri) {
        if (originalUri.toString().startsWith("pathmap://")) {
            originalUri = URI.createURI((String)originalUri.toString().replace("pathmap://", "http://"));
        }
        if (originalUri.toString().contains("/UML/")) {
            originalUri = URI.createURI((String)originalUri.toString().replace("/UML/", "/UML_Folder/"));
        }
        return originalUri;
    }

    private String local2remoteUri(URI resourceUri) {
        HashMap<String, String> projectPathMap = this.getProjectPathMap();
        Set<Map.Entry<String, String>> entrySet = projectPathMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry2;
            Map.Entry<String, String> entry = entry2 = iterator.next();
            String localLocation = entry.getKey();
            String remoteLocation = entry.getValue();
            String trimmedResourceUri = resourceUri.trimSegments(1).toString();
            while (URI.createURI((String)trimmedResourceUri).segmentsList().size() > 0) {
                if (trimmedResourceUri.equals(localLocation)) {
                    String remoteUri = resourceUri.toString().replace(String.valueOf(localLocation) + "/", remoteLocation);
                    return remoteUri;
                }
                trimmedResourceUri = URI.createURI((String)trimmedResourceUri).trimSegments(1).toString();
            }
        }
        return null;
    }

    public void checkInModel(Session session, List<Resource> resources, Map<?, ?> saveOptions, String logMessage) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInModel(session, resources, saveOptions, logMessage, null);
    }

    public void checkInModel(Session session, List<Resource> resources, Map<?, ?> saveOptions, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        Iterator<Resource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            Resource resource2;
            Resource resource = resource2 = iterator.next();
            this._checkInModel(session, resource, resource.getURI(), saveOptions, logMessage, options);
        }
    }

    private static List<Resource> getAllreferencedResourcesInclusiveMetaReferencesTransitive(Resource resource) {
        ArrayList<Resource> resourcesToCheck = new ArrayList<Resource>();
        resourcesToCheck.add(resource);
        ArrayList<Resource> checkedResources = new ArrayList<Resource>();
        while (!resourcesToCheck.isEmpty()) {
            Resource currentResource = (Resource)resourcesToCheck.iterator().next();
            resourcesToCheck.remove(currentResource);
            checkedResources.add(currentResource);
            Collection<Resource> referencedResources = RepositoryHelper.getAllreferencedResourcesInclusiveMetaReferences(currentResource);
            for (Resource resource2 : referencedResources) {
                Resource currentReferencedResource = resource2;
                boolean containedAlready = checkedResources.contains(currentReferencedResource);
                if (!containedAlready && currentReferencedResource != null) {
                    resourcesToCheck.add(currentReferencedResource);
                    continue;
                }
                if (!containedAlready) continue;
                checkedResources.remove(currentReferencedResource);
                checkedResources.add(currentReferencedResource);
            }
        }
        return checkedResources;
    }

    private static Collection<Resource> getAllreferencedResourcesInclusiveMetaReferences(Resource resource) {
        LinkedHashSet<Resource> referencedResources = new LinkedHashSet<Resource>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject currentObject = (EObject)iterator.next();
            EClass currentClass = currentObject.eClass();
            referencedResources.add(currentClass.eResource());
            Iterator iterator2 = currentClass.getEAllReferences().iterator();
            while (iterator2.hasNext()) {
                EReference eReference;
                EReference currentReference = eReference = (EReference)iterator2.next();
                Object currentValue = null;
                if (!currentReference.isDerived()) {
                    currentValue = currentObject.eGet((EStructuralFeature)currentReference, true);
                }
                if (currentValue == null) continue;
                if (currentValue instanceof Collection) {
                    Collection currentValueCollection = (Collection)currentValue;
                    for (Object name : currentValueCollection) {
                        EObject currentCollectionObject = (EObject)name;
                        referencedResources.add(currentCollectionObject.eResource());
                    }
                    continue;
                }
                referencedResources.add(((EObject)currentValue).eResource());
            }
        }
        return referencedResources;
    }

    private Holder<Session> createSessionHolder(Session session) {
        return new Holder((Object)session);
    }

    private OptionsMap mapToInternalMap(Map<String, ?> map) {
        OptionsMap optionsMap = new OptionsMap();
        if (map == null) {
            return optionsMap;
        }
        for (String key : map.keySet()) {
            OptionMapEntry mapEntry = new OptionMapEntry();
            mapEntry.setOptionName(key);
            mapEntry.setOptionValue(map.get(key));
            optionsMap.getMapEntry().add(mapEntry);
        }
        return optionsMap;
    }

    private void checkInModelWithForce(Session session, Resource resource, ResourceSet resourceSet, Map<?, ?> saveOptions, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        URI resourceURI;
        boolean enableDependencies = this.checkDependencies;
        if (saveOptions == null) {
            saveOptions = Collections.EMPTY_MAP;
        }
        if ((resourceURI = resource.getURI()).fileExtension() != null && (resourceURI.fileExtension().equals("emx") || resourceURI.fileExtension().equals("epx"))) {
            XMIResourceImpl tmpResource = new XMIResourceImpl();
            tmpResource.setURI(resourceURI);
            tmpResource.getContents().add((Object)((EObject)resource.getContents().get(0)));
            tmpResource.load(Collections.EMPTY_MAP);
            resource = tmpResource;
        }
        ByteArrayDataSource byteArrayDataSource = this.saveResourceToDataSource(resource, resourceSet, saveOptions);
        String path = resource.getURI().toString();
        Holder existsHolder = new Holder();
        this.getService().exists(this.createSessionHolder(session), path, "-1", existsHolder);
        if (!resource.getURI().scheme().equals("http") && !((Boolean)existsHolder.value).booleanValue()) {
            this.getService().exists(this.createSessionHolder(session), "http://" + resource.getURI().authority() + resource.getURI().path(), "-1", existsHolder);
        }
        DataHandler dataHandler = new DataHandler((DataSource)byteArrayDataSource);
        Holder checksumHolder = new Holder();
        if (((Boolean)existsHolder.value).booleanValue()) {
            this.getService().checkInModel(this.createSessionHolder(session), path, dataHandler, enableDependencies, logMessage, this.mapToInternalMap(options), checksumHolder);
        } else {
            this.getService().createModelwithContent(this.createSessionHolder(session), dataHandler, path, enableDependencies, logMessage, this.mapToInternalMap(options), checksumHolder);
        }
    }

    private ByteArrayDataSource saveResourceToDataSource(Resource resource, ResourceSet resourceSet, Map<?, ?> saveOptions) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)byteArrayOutputStream, saveOptions);
        }
        catch (Exception exception) {
            resource = resourceSet.getResource(resource.getURI(), true);
            resource.save((OutputStream)byteArrayOutputStream, saveOptions);
        }
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), "application/octet-stream");
        byteArrayOutputStream.close();
        return byteArrayDataSource;
    }

    private static URI toPlatformURI(URI uri, boolean inWorkspace) {
        String uriString = uri.toString();
        if (uriString.startsWith("http://")) {
            if (inWorkspace) {
                return URI.createURI((String)uriString.replace("http:/", "platform:/resource"));
            }
            return URI.createURI((String)uriString.replace("http:/", "platform:/plugin"));
        }
        return uri;
    }

    public void checkoutModelWithDependencies(Session session, Resource resource, String revision, Map<?, ?> loadOptions) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException, IOException {
        OutgoingReferencesInfo[] dependencies;
        Resource localResource;
        Resource model;
        URI modelURI = resource.getURI();
        ResourceSet resourceSet = resource.getResourceSet();
        if (RepositoryHelper.resourceSetContainsNonEmptyResourceWithURI(resourceSet, modelURI) && (model = resourceSet.getResource(modelURI, true)) != null) {
            return;
        }
        URI localPluginURI = RepositoryHelper.toPlatformURI(modelURI, false);
        if (localPluginURI != CommonPlugin.resolve((URI)localPluginURI) && (localResource = resourceSet.getResource(localPluginURI, true)) != null) {
            return;
        }
        OutgoingReferencesInfo[] outgoingReferencesInfoArray = dependencies = this.getOutgoingReferences(session, modelURI);
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            URI dependencyURI;
            OutgoingReferencesInfo outgoingReference = outgoingReferencesInfoArray[n2];
            String dependency = outgoingReference.getModelUrl();
            boolean dependencyContainedInResourceSet = resourceSet.getPackageRegistry().containsKey((Object)dependency);
            if (!dependencyContainedInResourceSet && !RepositoryHelper.resourceSetContainsNonEmptyResourceWithURI(resourceSet, dependencyURI = URI.createURI((String)dependency))) {
                boolean exists = this.exists(session, dependencyURI, "-1");
                if (exists) {
                    Resource depResource = resourceSet.createResource(dependencyURI);
                    this.checkoutModelWithDependencies(session, depResource, revision, loadOptions);
                } else {
                    System.err.println("Warning: Model with URI " + dependencyURI.toString() + " not found in repository. Skipping...");
                }
            }
            ++n2;
        }
        this.checkOutModelWithForce(session, resource, revision, loadOptions);
        RepositoryHelper.registerPackages(resource, modelURI);
    }

    private void checkOutModelWithForce(Session session, Resource resource, String revision, Map<?, ?> loadOptions) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        Holder dataHandlerHolder = new Holder();
        if (loadOptions == null) {
            loadOptions = Collections.EMPTY_MAP;
        }
        this.getService().checkOutModelWithRevision(this.createSessionHolder(session), resource.getURI().toString(), dataHandlerHolder, revision);
        DataSource dataSource = ((DataHandler)dataHandlerHolder.value).getDataSource();
        File file = this.createTempFile(dataSource);
        if (file != null) {
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(file);
                    resource.unload();
                    EList uriHandlers = resource.getResourceSet().getURIConverter().getURIHandlers();
                    ModelBusClientURIHandler modelBusURIHandler = this.getModelBusURIHandler(session);
                    if (!uriHandlers.contains((Object)modelBusURIHandler)) {
                        EList uriHandlersCopy = (EList)uriHandlers.getClass().newInstance();
                        uriHandlersCopy.addAll((Collection)uriHandlers);
                        uriHandlers.clear();
                        uriHandlers.add((Object)modelBusURIHandler);
                        uriHandlers.addAll((Collection)uriHandlersCopy);
                    }
                    resource.load((InputStream)inputStream, loadOptions);
                }
                catch (Exception exception) {
                    ResourceSet resourceSet = resource.getResourceSet();
                    ModelBusPackageRegistry modelBusPackageRegistry = this.getModelBusPackageRegistry();
                    modelBusPackageRegistry.setSession(session);
                    modelBusPackageRegistry.setResourceSet(resourceSet);
                    resourceSet.setPackageRegistry((EPackage.Registry)modelBusPackageRegistry);
                    String fileExtension = resource.getURI().fileExtension();
                    if (fileExtension != null) {
                        if (fileExtension.equals("uml") || fileExtension.equals("emx") || fileExtension.equals("epx")) {
                            this.registerUMLMetaModel(session, resourceSet);
                        }
                        if (fileExtension.equals("emx") || fileExtension.equals("epx") || fileExtension.equals("notation")) {
                            this.registerIBMNotationMetaModels(session, resourceSet);
                            this.registerNotationDiMetaModels(session, resourceSet);
                        }
                    }
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                    inputStream = new FileInputStream(file);
                    resource.unload();
                    try {
                        resource.load((InputStream)inputStream, loadOptions);
                    }
                    catch (IOException exc) {
                        throw new RuntimeException(exc.getMessage(), exc);
                    }
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                    file.delete();
                }
            }
            finally {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                file.delete();
            }
        }
    }

    private File createTempFile(DataSource dataSource) throws IOException {
        File tempFile = null;
        tempFile = File.createTempFile("temp", ".modelbus");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        InputStream inputStream = dataSource.getInputStream();
        byte[] buffer = new byte[1024];
        int read = inputStream.read(buffer);
        while (read > 0) {
            fileOutputStream.write(buffer, 0, read);
            read = inputStream.read(buffer);
        }
        inputStream.close();
        fileOutputStream.close();
        return tempFile;
    }

    public void checkOutModel(Session session, List<Resource> resources, Map<?, ?> loadOptions) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        for (Resource resource : resources) {
            this.checkOutModelWithForce(session, resource, "-1", loadOptions);
        }
    }

    public void checkOutModelWithRevision(Session session, List<Resource> resources, String revision, Map<?, ?> loadOptions) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        for (Resource resource : resources) {
            this.checkOutModelWithForce(session, resource, revision, loadOptions);
        }
    }

    public void checkOutFile(Session session, URI fileUri, String revision, File file) throws IOException, RepositoryAuthentificationException, NonExistingResourceException {
        Holder dataHandlerHolder = new Holder();
        this.getService().checkOutFile(this.createSessionHolder(session), fileUri.toString(), revision, dataHandlerHolder);
        InputStream stream = ((DataHandler)dataHandlerHolder.value).getDataSource().getInputStream();
        FileOutputStream fout = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        int readCount = 0;
        while ((readCount = stream.read(buffer)) != -1) {
            if (readCount < 4096) {
                fout.write(buffer, 0, readCount);
                continue;
            }
            fout.write(buffer);
        }
        fout.close();
    }

    private DataHandler checkOutFileAsDataHandler(Session session, URI fileUri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        Holder dataHandlerHolder = new Holder();
        this.getService().checkOutFile(this.createSessionHolder(session), fileUri.toString(), revision, dataHandlerHolder);
        return (DataHandler)dataHandlerHolder.value;
    }

    public InputStream checkOutFile(Session session, URI fileUri, String revision) throws IOException, RepositoryAuthentificationException, NonExistingResourceException {
        DataHandler dataHandler = this.checkOutFileAsDataHandler(session, fileUri, revision);
        if (dataHandler != null) {
            InputStream stream = dataHandler.getDataSource().getInputStream();
            return stream;
        }
        return null;
    }

    public IModelBusDataSource checkOutFileAsDataSource(Session session, URI fileUri, String revision) throws IOException, RepositoryAuthentificationException, NonExistingResourceException {
        DataHandler dataHandler = this.checkOutFileAsDataHandler(session, fileUri, revision);
        if (dataHandler != null) {
            return new DefaultModelBusDataSource(fileUri, dataHandler.getDataSource());
        }
        return null;
    }

    public void setEnableDependencies(boolean enableDependencies) {
        this.checkDependencies = enableDependencies;
    }

    public void setModelExtensions(String[] modelExtensions) {
        this.modelExtensions = modelExtensions;
    }

    private void _checkInFile(Session session, URI fileUri, String revision, DataHandler dataHandler, String logMessage, Map<String, Object> options) throws NonExistingResourceException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        Holder existsHolder = new Holder();
        this.getService().exists(this.createSessionHolder(session), fileUri.toString(), revision, existsHolder);
        Holder checksumHolder = new Holder();
        String fileExtension = fileUri.fileExtension();
        if (((Boolean)existsHolder.value).booleanValue()) {
            if (this.checkDependencies && this.isExtensionForDependenciesSupport(fileExtension)) {
                this.getService().checkInModel(this.createSessionHolder(session), fileUri.toString(), dataHandler, this.checkDependencies, logMessage, this.mapToInternalMap(options), checksumHolder);
            } else {
                this.getService().checkInFile(this.createSessionHolder(session), fileUri.toString(), dataHandler, logMessage, this.mapToInternalMap(options), checksumHolder);
            }
        } else if (this.checkDependencies && this.isExtensionForDependenciesSupport(fileExtension)) {
            this.getService().createModelwithContent(this.createSessionHolder(session), dataHandler, fileUri.toString(), this.checkDependencies, logMessage, this.mapToInternalMap(options), checksumHolder);
        } else {
            this.getService().createFile(this.createSessionHolder(session), fileUri.toString(), dataHandler, logMessage, this.mapToInternalMap(options), checksumHolder);
        }
    }

    private boolean isExtensionForDependenciesSupport(String fileExtension) {
        String[] stringArray = this.modelExtensions;
        int n = this.modelExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String modelExtension;
            String planeExtension = modelExtension = stringArray[n2];
            if (modelExtension.startsWith("*.")) {
                planeExtension = modelExtension.substring(2);
            } else if (modelExtension.startsWith(".")) {
                planeExtension = modelExtension.substring(1);
            }
            if (planeExtension.equals(fileExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkInFile(Session session, URI fileUri, File file, String logMessage) throws IOException, NonExistingResourceException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInFile(session, fileUri, file, logMessage, null);
    }

    public void checkInFile(Session session, URI fileUri, File file, String logMessage, Map<String, Object> options) throws IOException, NonExistingResourceException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        FileDataSource fileDataSource = new FileDataSource(file);
        DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
        this._checkInFile(session, fileUri, "-1", dataHandler, logMessage, options);
    }

    public void checkInFile(Session session, IModelBusDataSource dataSource, String logMessage) throws IOException, RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        this.checkInFile(session, dataSource, logMessage, null);
    }

    public void checkInFile(Session session, IModelBusDataSource dataSource, String logMessage, Map<String, Object> options) throws IOException, RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        URI fileUri = dataSource.getUri();
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        this._checkInFile(session, fileUri, "-1", dataHandler, logMessage, options);
    }

    public RepositoryDirEntry getRoot(Session session) throws NonExistingResourceException, IOException, RepositoryAuthentificationException, InvalidRevisionException {
        Holder entriesHolder = new Holder();
        Holder entryHolder = new Holder();
        this.getService().getDir(this.createSessionHolder(session), "http://", "-1", true, entriesHolder, entryHolder);
        return (RepositoryDirEntry)entryHolder.value;
    }

    public RepositoryDirEntry[] getDirEntries(Session session, URI uri, String revision) throws IOException, RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException {
        Holder entriesHolder = new Holder();
        Holder entryHolder = new Holder();
        this.getService().getDir(this.createSessionHolder(session), uri.toString(), revision, true, entriesHolder, entryHolder);
        if (entriesHolder.value != null) {
            return ((List)entriesHolder.value).toArray(new RepositoryDirEntry[((List)entriesHolder.value).size()]);
        }
        return new RepositoryDirEntry[0];
    }

    public RepositoryDirEntry[] getDirEntries(Session session, URI uri, String revision, String[] excludeFilters) throws IOException, RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException {
        RepositoryDirEntry[] entries = this.getDirEntries(session, uri, revision);
        ArrayList<RepositoryDirEntry> filteredEntries = new ArrayList<RepositoryDirEntry>();
        RepositoryDirEntry[] repositoryDirEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryDirEntry entry = repositoryDirEntryArray[n2];
            boolean match = false;
            String[] stringArray = excludeFilters;
            int n3 = excludeFilters.length;
            int n4 = 0;
            while (n4 < n3) {
                String filter = stringArray[n4];
                Pattern pattern = Pattern.compile(filter);
                Matcher matcher = pattern.matcher(entry.getUri());
                if (matcher.find()) {
                    match = true;
                    break;
                }
                ++n4;
            }
            if (!match) {
                filteredEntries.add(entry);
            }
            ++n2;
        }
        return filteredEntries.toArray(new RepositoryDirEntry[filteredEntries.size()]);
    }

    public List<RepositoryDirEntry> getInfo(Session session, URI uri, String revision) throws IOException, RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException {
        Holder entryHolder = new Holder();
        this.getService().info(this.createSessionHolder(session), uri.toString(), revision, entryHolder);
        return (List)entryHolder.value;
    }

    public boolean exists(Session session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        Holder existsHolder = new Holder();
        this.getService().exists(this.createSessionHolder(session), uri.toString(), revision, existsHolder);
        return (Boolean)existsHolder.value;
    }

    public List<RepositoryNodeKind> checkPath(Session session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        Holder nodeKindHolder = new Holder();
        this.getService().checkPath(this.createSessionHolder(session), uri.toString(), revision, nodeKindHolder);
        if (nodeKindHolder.value == null) {
            nodeKindHolder.value = new ArrayList();
        }
        return (List)nodeKindHolder.value;
    }

    public String delete(Session session, URI uri, String logMessage) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        Holder resultHolder = new Holder();
        this.getService().delete(this.createSessionHolder(session), uri.toString(), logMessage, "-1", resultHolder);
        return (String)resultHolder.value;
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(date.getTime());
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            datatypeConfigurationException.printStackTrace();
            return null;
        }
    }

    public boolean lock(Session session, URI uri) throws InvalidValueException, RepositoryAuthentificationException, NonExistingResourceException, RepositoryRuntimeException, LockedException {
        XMLGregorianCalendar calendar = RepositoryHelper.getXMLGregorianCalendar(new Date(System.currentTimeMillis()));
        boolean successful = this.getService().lock(session, uri.toString(), calendar);
        return successful;
    }

    public boolean unlock(Session session, URI uri) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        boolean successful = this.getService().unlock(session, uri.toString());
        return successful;
    }

    public boolean control(Session session, URI fragmentUri, String fragmentFileLocation, String logMessage) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        boolean successful = this.getService().control(session, fragmentUri.toString(), fragmentFileLocation, logMessage);
        return successful;
    }

    public boolean uncontrol(Session session, URI fragmentFileUri, String logMessage) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        boolean successful = this.getService().uncontrol(session, fragmentFileUri.toString(), logMessage);
        return successful;
    }

    public LockInfo[] getLocks(Session session, String urlPrefix) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        List serviceLockInfos = this.getService().getLocks(session, urlPrefix);
        if (serviceLockInfos == null) {
            return new LockInfo[0];
        }
        return serviceLockInfos.toArray(new LockInfo[serviceLockInfos.size()]);
    }

    public IncomingReferencesInfo[] getIncomingReferences(Session session, URI uri) throws RepositoryAuthentificationException, NonExistingResourceException {
        DependenciesInfo depInfo = this.getDependencies(session, uri, true, false);
        List serviceIncomingReferencesInfos = depInfo.getIncomingReferencesInfos();
        if (serviceIncomingReferencesInfos != null) {
            return serviceIncomingReferencesInfos.toArray(new IncomingReferencesInfo[serviceIncomingReferencesInfos.size()]);
        }
        return new IncomingReferencesInfo[0];
    }

    public OutgoingReferencesInfo[] getOutgoingReferences(Session session, URI uri) throws RepositoryAuthentificationException, NonExistingResourceException {
        DependenciesInfo depInfo = this.getDependencies(session, uri, false, true);
        List serviceOutgogingReferencesInfos = depInfo.getOutgoingReferencesInfos();
        if (serviceOutgogingReferencesInfos != null) {
            return serviceOutgogingReferencesInfos.toArray(new OutgoingReferencesInfo[serviceOutgogingReferencesInfos.size()]);
        }
        return new OutgoingReferencesInfo[0];
    }

    public DependenciesInfo getDependencies(Session session, URI uri, boolean includeIncomingReferences, boolean includeOutgoingReferences) throws RepositoryAuthentificationException, NonExistingResourceException {
        return this.getService().getDependencies(session, uri.toString(), includeIncomingReferences, includeOutgoingReferences);
    }

    public DependenciesInfo getDependencies(Session session, URI uri) throws RepositoryAuthentificationException, NonExistingResourceException {
        return this.getDependencies(session, uri, true, true);
    }

    public URI getResourceUri(URI objectUri) {
        return objectUri.trimFragment();
    }

    public String createDir(Session session, URI uri, String logMessage) throws RepositoryAuthentificationException {
        return this.createDir(session, uri, logMessage, null);
    }

    public String createDir(Session session, URI uri, String logMessage, Map<String, Object> options) throws RepositoryAuthentificationException {
        Holder checksumHolder = new Holder();
        this.getService().createDir(this.createSessionHolder(session), uri.toString(), logMessage, this.mapToInternalMap(options), checksumHolder);
        return (String)checksumHolder.value;
    }

    private void internalCopyMove(Session session, String[] srcPaths, String destPath, String message, boolean isMove) throws RepositoryAuthentificationException, NonExistingResourceException {
        ArrayList<String> srcPathsList = new ArrayList<String>();
        String[] stringArray = srcPaths;
        int n = srcPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String srcPath = stringArray[n2];
            srcPathsList.add(srcPath);
            ++n2;
        }
        this.getService().copy(session, srcPathsList, destPath, Boolean.valueOf(isMove), Boolean.valueOf(false), message);
    }

    public void move(Session session, String[] srcPaths, String destPath, String message) throws RepositoryAuthentificationException, NonExistingResourceException {
        this.internalCopyMove(session, srcPaths, destPath, message, true);
    }

    public boolean copy(Session session, String[] srcPaths, String destPath, String message) throws RepositoryAuthentificationException, NonExistingResourceException {
        this.internalCopyMove(session, srcPaths, destPath, message, false);
        return true;
    }

    public RepositoryLogEntry[] getLogEntries(Session session, String[] targetPaths, String startRevision, String endRevision, boolean changedPath, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revProps) throws RepositoryAuthentificationException {
        List logEntries = this.getService().getLogEntries(session, Arrays.asList(targetPaths), startRevision, endRevision, changedPath, strictNode, Long.valueOf(limit), Boolean.valueOf(includeMergedRevisions), Arrays.asList(revProps));
        if (logEntries != null) {
            return logEntries.toArray(new RepositoryLogEntry[logEntries.size()]);
        }
        return new RepositoryLogEntry[0];
    }

    public boolean commitChangeModel(Session session, String messageId, URI modelURI, String changeModelAsString) throws IOException, InvalidValueException, RepositoryAuthentificationException {
        Holder<Session> sessionHolder = this.createSessionHolder(session);
        Holder successfulHolder = new Holder();
        ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)new ByteArrayInputStream(changeModelAsString.getBytes()), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)dataSource);
        this.getService().commitChangeModel(sessionHolder, messageId, modelURI.toString(), handler, successfulHolder);
        return (Boolean)successfulHolder.value;
    }

    public List<Resource> getReferencingResources(Session session, URI referencedObjectUri, URI referencingTypeUri) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, UnresolvedReferencesException {
        IncomingReferencesInfo[] incomingReferencesInfos;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        IncomingReferencesInfo[] incomingReferencesInfoArray = incomingReferencesInfos = this.getIncomingReferences(session, URI.createURI((String)referencedObjectUri.toString()));
        int n = incomingReferencesInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String referencingObjectUri;
            URI resourceUri;
            IncomingReferencesInfo incomingReferencesInfo = incomingReferencesInfoArray[n2];
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            String objectTypeUri = incomingReferencesInfo.getObjectTypeUri();
            if (objectTypeUri.equals(referencingTypeUri) && this.exists(session, resourceUri = URI.createURI((String)(referencingObjectUri = incomingReferencesInfo.getReferencingObjectUri())).trimFragment(), "-1")) {
                Resource resource = resourceSet.createResource(resourceUri);
                this.checkOutModel(session, resource, Collections.EMPTY_MAP);
                resources.add(resource);
            }
            ++n2;
        }
        return resources;
    }

    public void commit(Session session, List<PathFileContentMapEntry> createFileMap, List<PathFileContentMapEntry> checkInFileMap, List<String> folderPaths, List<String> deletionPaths, String logMessage) throws RepositoryRuntimeException, InvalidValueException, RepositoryAuthentificationException, LockedException {
        Holder<Session> sessionHolder = this.createSessionHolder(session);
        Holder checksumHolder = new Holder();
        this.getService().commit(sessionHolder, createFileMap, checkInFileMap, folderPaths, deletionPaths, logMessage, checksumHolder);
    }

    private void registerUMLMetaModel(Session session, ResourceSet resourceSet) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException, IOException {
        Resource uml300MetaModelResource = resourceSet.createResource(URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        Resource uml210MetaModelResource = resourceSet.createResource(URI.createURI((String)"http://www.eclipse.org/uml2/2.1.0/UML"));
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.eclipse.org/uml2/3.0.0/UML") && this.exists(session, URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"), "-1")) {
            this.checkOutModel(session, uml300MetaModelResource, Collections.EMPTY_MAP);
            EPackage umlEPackage300 = (EPackage)uml300MetaModelResource.getContents().get(0);
            umlEPackage300.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(umlEPackage300, resourceSet);
        }
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.eclipse.org/uml2/2.1.0/UML") && this.exists(session, URI.createURI((String)"http://www.eclipse.org/uml2/2.1.0/UML"), "-1")) {
            this.checkOutModel(session, uml210MetaModelResource, Collections.EMPTY_MAP);
            EPackage umlEPackage210 = (EPackage)uml210MetaModelResource.getContents().get(0);
            umlEPackage210.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(umlEPackage210, resourceSet);
        }
    }

    private void registerUMLPackage(EPackage umlEPackage, ResourceSet resourceSet) {
        EPackage.Registry.INSTANCE.put((Object)umlEPackage.getNsURI(), (Object)umlEPackage);
        this.getModelBusPackageRegistry().put((Object)umlEPackage.getNsURI(), (Object)umlEPackage);
        if (!this.packages.contains(umlEPackage)) {
            this.packages.add(umlEPackage);
            int p = 0;
            while (p < umlEPackage.getESubpackages().size()) {
                EPackage e_package = (EPackage)umlEPackage.getESubpackages().get(p);
                this.registerUMLPackage(e_package, resourceSet);
                ++p;
            }
        }
    }

    private void registerNotationDiMetaModels(Session session, ResourceSet resourceSet) throws IOException, RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        Resource notationResource = resourceSet.createResource(URI.createURI((String)"http://www.eclipse.org/gmf/runtime/1.0.2/notation"));
        Resource diResource = resourceSet.createResource(URI.createURI((String)"http://www.eclipse.org/papyrus/0.7.0/sashdi"));
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.eclipse.org/gmf/runtime/1.0.2/notation") && this.exists(session, URI.createURI((String)"http://www.eclipse.org/gmf/runtime/1.0.2/notation"), "-1")) {
            this.checkOutModel(session, notationResource, Collections.EMPTY_MAP);
            EPackage notationPackage = (EPackage)notationResource.getContents().get(0);
            notationPackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(notationPackage, resourceSet);
        }
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.eclipse.org/papyrus/0.7.0/sashdi") && this.exists(session, URI.createURI((String)"http://www.eclipse.org/papyrus/0.7.0/sashdi"), "-1")) {
            this.checkOutModel(session, diResource, Collections.EMPTY_MAP);
            EPackage diPackage = (EPackage)diResource.getContents().get(0);
            diPackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(diPackage, resourceSet);
        }
    }

    private void registerIBMNotationMetaModels(Session session, ResourceSet resourceSet) throws RepositoryAuthentificationException, NonExistingResourceException, IOException, UnresolvedReferencesException {
        EPackage notationPackage;
        Resource notationResource = resourceSet.createResource(URI.createURI((String)"http://www.ibm.com/xtools/1.5.3/Umlnotation"));
        Resource rmpnotationResource = resourceSet.createResource(URI.createURI((String)"http://www.ibm.com/xtools/1.0.0/rmpnotation"));
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.ibm.com/xtools/1.5.3/Umlnotation") && this.exists(session, URI.createURI((String)"http://www.ibm.com/xtools/1.5.3/Umlnotation"), "-1")) {
            this.checkOutModel(session, notationResource, Collections.EMPTY_MAP);
            notationPackage = (EPackage)notationResource.getContents().get(0);
            notationPackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(notationPackage, resourceSet);
        }
        if (!this.getModelBusPackageRegistry().containsKey((Object)"http://www.ibm.com/xtools/1.0.0/rmpnotation") && this.exists(session, URI.createURI((String)"http://www.ibm.com/xtools/1.0.0/rmpnotation"), "-1")) {
            this.checkOutModel(session, rmpnotationResource, Collections.EMPTY_MAP);
            notationPackage = (EPackage)rmpnotationResource.getContents().get(0);
            notationPackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(notationPackage, resourceSet);
        }
    }

    public long ping(IRepositoryHelper.PingType type, Session session) throws ModelBusException {
        long start = System.currentTimeMillis();
        switch (type) {
            case WSDL_REQUEST: {
                String repoLocation = this.getRepositoryLocation();
                if (repoLocation == null) {
                    throw new ModelBusServiceException("Option for ModelBus repository location is not set.");
                }
                try {
                    URL url = new URL(String.valueOf(repoLocation) + "?wsdl");
                    URLConnection conn = url.openConnection();
                    InputStream iStream = conn.getInputStream();
                    iStream.close();
                    break;
                }
                catch (Exception exc) {
                    throw new ModelBusServiceException((Throwable)exc);
                }
            }
            case SERVICE_REQUEST: {
                try {
                    Status status = ModelBusCoreLib.getServicesHelper().getStatus(session, false);
                    System.out.println(status.getStartupDate().toString());
                    break;
                }
                catch (Exception exc) {
                    throw new ModelBusServiceException((Throwable)exc);
                }
            }
        }
        return System.currentTimeMillis() - start;
    }

    public ExtendedRepositoryLogEntry getExtendedLogEntry(Session session, String revision, Long date) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException {
        XMLGregorianCalendar calendar = null;
        if (date != null) {
            calendar = RepositoryHelper.getXMLGregorianCalendar(new Date(date));
        }
        ExtendedRepositoryLogEntry logEntry = this.getService().getExtendedLogEntry(session, revision, calendar);
        return logEntry;
    }

    private static void registerPackage(ResourceSet rs, EPackage pkg, String pkgURI) {
        EPackage pkgWithOrigURI = rs.getPackageRegistry().getEPackage(pkg.getNsURI());
        EPackage pkgToRegister = null;
        pkgToRegister = pkgWithOrigURI == null ? pkg : pkgWithOrigURI;
        rs.getPackageRegistry().put((Object)pkgURI, (Object)pkgToRegister);
        EPackage.Registry.INSTANCE.put((Object)pkgURI, (Object)pkgToRegister);
    }

    private static void registerPackages(Resource r, URI modelURI) {
        ResourceSet rs = r.getResourceSet();
        HashSet<EPackage> packages = new HashSet<EPackage>();
        TreeIterator objts = r.getAllContents();
        while (objts.hasNext()) {
            EObject obj = (EObject)objts.next();
            if (!(obj instanceof EPackage)) continue;
            packages.add((EPackage)obj);
        }
        for (EPackage pkg : packages) {
            pkg.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            if (!rs.getPackageRegistry().containsKey((Object)pkg.getNsURI())) {
                RepositoryHelper.registerPackage(rs, pkg, pkg.getNsURI());
            }
            if (!rs.getPackageRegistry().containsKey((Object)modelURI.toString())) {
                RepositoryHelper.registerPackage(rs, pkg, modelURI.toString());
            }
            String platformURI = RepositoryHelper.toPlatformURI(modelURI, false).toString();
            if (rs.getPackageRegistry().containsKey((Object)platformURI)) continue;
            RepositoryHelper.registerPackage(rs, pkg, platformURI);
        }
    }

    private static boolean resourceSetContainsNonEmptyResourceWithURI(ResourceSet rs, URI uri) {
        for (Resource res : rs.getResources()) {
            if (!res.getURI().equals(uri) || res.getContents().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

