/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.configuration;

import config.ConfigModel;
import config.ConfigPackage;
import config.ExternalLocation;
import config.Location;
import config.LocationProperty;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.LocationsUtilFactory;

public class ModelBusConfiguration {
    public static final String LOCATION_SVN_REPOSITORY = "svnRepositoryLocation";
    public static final String LOCATION_GIT_REPOSITORY = "gitRepositoryLocation";
    public static final String LOCATION_TFS_REPOSITORY = "tfsRepositoryLocation";
    public static final String LOCATION_REPOSITORY = "repositoryLocation";
    public static final String LOCATION_REPOSITORY_SECURE = "secureRepositoryLocation";
    public static final String LOCATION_NOTIFICATION = "notificationLocation";
    public static final String LOCATION_PROPERTY_SSL_TRUSTSTORE = "SSLTrustStore";
    public static final String LOCATION_PROPERTY_SSL_TRUSTSTORE_PASSWORD = "SSLTrustStorePassword";
    public static final String LOCATION_PROPERTY_SSL_KEYSTORE = "SSLKeyStore";
    public static final String LOCATION_PROPERTY_SSL_KEYSTORE_TYPE = "SSLKeyStoreType";
    public static final String LOCATION_PROPERTY_SSL_KEYSTORE_PASSWORD = "SSLKeyStorePassword";
    public static final String LOCATION_PROPERTY_SSL_ALGORITHM = "SSLAlgorithm";
    public static final String LOCATION_PROPERTY_SSL_PASSWORD = "SSLPassword";
    public static final String LOCATION_PROPERTY_SVN_USERNAME = "SVNUserName";
    public static final String LOCATION_PROPERTY_SVN_PASSWORD = "SVNPassword";
    public static final String LOCATION_PROPERTY_GIT_USERNAME = "GitUserName";
    public static final String LOCATION_PROPERTY_GIT_EMAIL = "GitUserEmail";
    public static final String LOCATION_PROPERTY_TFS_USERNAME = "tfsUserName";
    public static final String LOCATION_PROPERTY_TFS_PASSWORD = "tfsPassword";
    public static final String LOCATION_PROPERTY_TFS_NATIVE_LIBRARY = "tfsNativeLibraryPath";
    public static final String LOCATION_PROPERTY_TFS_SERVER = "tfsRepositoryServer";
    public static final String LOCATION_PROPERTY_TFS_SERVER_PATH = "tfsRepositoryServerPath";
    protected static final String ENV_MODELBUS_ROOT = "MODELBUS_ROOT";
    public static final String MODELBUS_CONFIG_DIR = "serverConfiguration";
    public static final String MODELBUS_CONFIG_MODEL_DEFAULT_NAME = "modelbus.config";
    public static final String EXTERNAL_LOCATION_PROPERTY_TYPE = "type";
    public static final String EXTERNAL_LOCATION_PROPERTY_PUBLIC_ROOT_URI = "publicRootURI";
    public static final String EXTERNAL_LOCATION_PROPERTY_ROOT_SERVICES_URI = "rootServicesURI";
    public static final String EXTERNAL_LOCATION_PROPERTY_USERNAME = "username";
    public static final String EXTERNAL_LOCATION_PROPERTY_PASSWORD = "password";
    public static final String LOCATION_PROPERTY_OAUTH_USER = "OAuthUser";
    public static final String LOCATION_PROPERTY_OAUTH_SECRET = "OAuthSecret";
    protected static ConfigModel configModel;

    protected static final ConfigModel loadModel(String path) throws ModelBusException {
        ResourceSetImpl rs = new ResourceSetImpl();
        URI modelURI = URI.createFileURI((String)path);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        rs.getPackageRegistry().put((Object)ConfigPackage.eINSTANCE.getNsURI(), (Object)ConfigPackage.eINSTANCE);
        Resource configResource = null;
        try {
            configResource = rs.getResource(modelURI, true);
        }
        catch (Exception exception) {
            throw new ModelBusException("Configuration model not found.");
        }
        if (configResource == null) {
            throw new ModelBusException("ModelBus config model not found (Expected location: " + modelURI.toString() + ")");
        }
        if (configResource.getContents().isEmpty()) {
            throw new ModelBusException("ModelBus config model is empty.");
        }
        EObject rootObject = (EObject)configResource.getContents().get(0);
        if (!(rootObject instanceof ConfigModel)) {
            throw new ModelBusException("ModelBus config model is invalid.");
        }
        return (ConfigModel)rootObject;
    }

    protected static ConfigModel getModel() throws ModelBusException {
        if (configModel == null) {
            String configModelLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getModelBusConfigModelLocation();
            configModel = ModelBusConfiguration.loadModel(configModelLocation);
        }
        return configModel;
    }

    public static String getModelBusRootLocation() throws ModelBusException {
        String rootLocation = System.getenv().get(ENV_MODELBUS_ROOT);
        if (rootLocation == null) {
            throw new ModelBusException("Environment variable 'MODELBUS_ROOT' has to be set for using ModelBus.");
        }
        return rootLocation;
    }

    public static String getLocation(String locationName) throws ModelBusException {
        Location location = ModelBusConfiguration.getLocationObject(locationName);
        if (location != null) {
            return location.getLocation();
        }
        return null;
    }

    public static ExternalLocation[] getExternalLocations() throws ModelBusException {
        EList externalLocations = ModelBusConfiguration.getModel().getExternalLocation();
        return externalLocations.toArray(new ExternalLocation[externalLocations.size()]);
    }

    public static Location getExternalLocationByURI(URI locationURI) throws ModelBusException {
        for (Location location : ModelBusConfiguration.getModel().getExternalLocation()) {
            if (!location.getLocation().equals(locationURI.toString())) continue;
            return location;
        }
        return null;
    }

    private static Location getLocationObject(String locationName) throws ModelBusException {
        for (Location location : ModelBusConfiguration.getModel().getLocation()) {
            if (!locationName.equals(location.getName())) continue;
            return location;
        }
        return null;
    }

    public static LocationProperty[] getLocationProperties(String locationName) throws ModelBusException {
        Location location = ModelBusConfiguration.getLocationObject(locationName);
        if (location == null) {
            return new LocationProperty[0];
        }
        EList propertiesList = location.getProperty();
        return propertiesList.toArray(new LocationProperty[propertiesList.size()]);
    }

    public static LocationProperty getLocationProperty(String locationName, String propertyName) throws ModelBusException {
        return ModelBusConfiguration.getLocationProperty(ModelBusConfiguration.getLocationObject(locationName), propertyName);
    }

    public static LocationProperty getLocationProperty(Location location, String propertyName) {
        if (location == null) {
            return null;
        }
        for (LocationProperty property : location.getProperty()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    private static String getAbsolutePath(String path, boolean isConfigFile) throws ModelBusException {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String pathReturn = path;
            if (!path.startsWith(File.separator)) {
                pathReturn = String.valueOf(File.separator) + path;
            }
            if (isConfigFile) {
                return String.valueOf(LocationsUtilFactory.getInstance().getLocationsUtil().getModelBusConfigModelFolderLocation()) + pathReturn;
            }
            return String.valueOf(ModelBusConfiguration.getModelBusRootLocation()) + pathReturn;
        }
        return path;
    }

    public static String getAbsoluteRootFilePath(String path) throws ModelBusException {
        return ModelBusConfiguration.getAbsolutePath(path, false);
    }

    public static String getAbsoluteConfigFilePath(String path) throws ModelBusException {
        return ModelBusConfiguration.getAbsolutePath(path, true);
    }

    public static File getTempFolder() throws ModelBusException {
        File tempFolder = new File(String.valueOf(ModelBusConfiguration.getModelBusRootLocation()) + File.separator + "temp");
        if (!tempFolder.exists() && !tempFolder.mkdir()) {
            throw new ModelBusException("Can't create temp folder in: " + tempFolder.getPath());
        }
        return tempFolder;
    }
}

