/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.compare;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilterUpdateEvent;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;

class DiffModelDiffEngine
extends DefaultDiffEngine
implements EventBusParticipant {
    private final Set<EAttribute> attributes = Sets.newHashSet();
    private final Set<EReference> references = Sets.newHashSet();
    private final Set<EStructuralFeature> whiteList = Sets.newHashSet();
    private final Set<String> featureNames = Sets.newHashSet();
    private boolean ignoreOrder;
    private boolean ignoreReferences;
    private boolean ignoreAttributes;
    private boolean filterSingleElements = true;

    DiffModelDiffEngine(IDiffProcessor processor) {
        super(processor);
    }

    protected FeatureFilter createFeatureFilter() {
        return new CustomFeatureFilter();
    }

    @Handler
    public void diffMergeFilterUpdateEventHandler(DiffMergeFilterUpdateEvent event) {
        this.attributes.addAll(Arrays.asList(event.getAttribute()));
        this.references.addAll(Arrays.asList(event.getRefernces()));
        this.whiteList.addAll(Arrays.asList(event.getWhiteList()));
        this.featureNames.addAll(Arrays.asList(event.getFeatureNames()));
        this.ignoreOrder = event.isIgnoreOrder();
        this.filterSingleElements = event.isFilterSingleElement();
    }

    public Collection<Object> getAllEventHandlers() {
        return Lists.newArrayList((Object[])new Object[]{this});
    }

    public ModelBusEventBus getEventBus() {
        throw new UnsupportedOperationException();
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new UnsupportedOperationException();
    }

    private class CustomFeatureFilter
    extends FeatureFilter {
        private CustomFeatureFilter() {
        }

        protected boolean isIgnoredAttribute(EAttribute attribute) {
            if (DiffModelDiffEngine.this.ignoreAttributes || DiffModelDiffEngine.this.attributes.contains(attribute)) {
                return true;
            }
            if (this.isElementFilteredByName((EStructuralFeature)attribute)) {
                return true;
            }
            return super.isIgnoredAttribute(attribute);
        }

        private boolean isElementFilteredByName(EStructuralFeature attribute) {
            if (!DiffModelDiffEngine.this.filterSingleElements && !this.isFeatureNameInFilterList(attribute)) {
                return true;
            }
            return DiffModelDiffEngine.this.filterSingleElements && this.isFeatureNameInFilterList(attribute);
        }

        private boolean isFeatureNameInFilterList(EStructuralFeature attribute) {
            if (DiffModelDiffEngine.this.featureNames.contains(attribute.getName())) {
                return true;
            }
            return DiffModelDiffEngine.this.featureNames.contains(attribute.getEType().getName());
        }

        protected boolean isIgnoredReference(Match match, EReference reference) {
            if (DiffModelDiffEngine.this.ignoreReferences || DiffModelDiffEngine.this.references.contains(reference)) {
                return true;
            }
            if (this.isElementFilteredByName((EStructuralFeature)reference)) {
                return true;
            }
            return super.isIgnoredReference(match, reference);
        }

        public boolean checkForOrderingChanges(EStructuralFeature feature) {
            if (DiffModelDiffEngine.this.ignoreOrder) {
                return false;
            }
            return super.checkForOrderingChanges(feature);
        }
    }
}

