/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.modelbus.core.lib.util.DynamicEFactoryImpl;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.DependenciesInfo;
import org.modelbus.dosgi.repository.descriptor.IncomingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidServiceDescriptionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.OptionMapEntry;
import org.modelbus.dosgi.repository.descriptor.OptionsMap;
import org.modelbus.dosgi.repository.descriptor.OutgoingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.ServiceProperties;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.IModelBusExtendedRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusRepositoryListener;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.LockInfo;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.ModelBusURIHandler;
import org.modelbus.services.repository.server.common.AccessManager;
import org.modelbus.services.repository.server.common.ChangeCommitManager;
import org.modelbus.services.repository.server.common.DependenciesManager;
import org.modelbus.services.repository.server.common.LockManager;
import org.modelbus.services.repository.server.common.ModelBusPackageRegistryImpl;
import org.modelbus.services.repository.server.common.ServicesManager;
import org.modelbus.services.repository.server.resource.io.IResourceHandler;
import org.modelbus.services.repository.server.resource.io.ResourceHandlerFactory;
import status.StatusModel;

public abstract class AbstractModelBusRepository
implements IModelBusRepository {
    protected static final int MODE_CREATE = 1;
    protected static final int MODE_UPDATE = 2;
    protected static OptionsMap defaultOptionsMap;
    private final Collection<IModelBusRepositoryListener> modelBusRepositoryListeners = new HashSet<IModelBusRepositoryListener>();
    protected AccessManager accessManager = new AccessManager(this);
    protected final LockManager lockManager = new LockManager(this);
    private ModelBusPackageRegistryImpl modelBusPackageRegistryImpl;
    protected final DependenciesManager dependenciesManager = new DependenciesManager(this);
    protected final ChangeCommitManager changeCommitManager = new ChangeCommitManager(this);
    protected final ServicesManager servicesManager = new ServicesManager();
    protected final List<EPackage> packages = new ArrayList<EPackage>();
    protected boolean enableSymbolicLinks = true;
    private ModelBusURIHandler modelBusURIHandler;
    protected static final String SYM_FILE_EXTENSION = "_file";
    protected static final String SYM_DIR_EXTENSION = "_dir";

    public static OptionsMap getDefaultOptionsMap() {
        if (defaultOptionsMap == null) {
            defaultOptionsMap = new OptionsMap();
        }
        return defaultOptionsMap;
    }

    protected static Map<String, Object> optionsMapToMap(OptionsMap options) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (options == null) {
            return map;
        }
        for (OptionMapEntry mapEntry : options.getMapEntry()) {
            map.put(mapEntry.getOptionName(), mapEntry.getOptionValue());
        }
        return map;
    }

    protected static Object getOption(OptionsMap options, String optionName) {
        return AbstractModelBusRepository.getOption(AbstractModelBusRepository.optionsMapToMap(options), optionName);
    }

    protected static String getOptionAsString(OptionsMap options, String optionName) {
        return AbstractModelBusRepository.getOptionAsString(AbstractModelBusRepository.optionsMapToMap(options), optionName);
    }

    protected static String getOptionAsString(Map<String, Object> options, String optionName) {
        Object optionValue = AbstractModelBusRepository.getOption(options, optionName);
        if (optionValue != null) {
            return optionValue.toString();
        }
        return null;
    }

    protected static Object getOption(Map<String, Object> options, String optionName) {
        if (options == null) {
            return null;
        }
        if (options.containsKey(optionName)) {
            return options.get(optionName);
        }
        return null;
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] tmp = param.split("=");
            String name = URI.decode((String)tmp[0]);
            String value = URI.decode((String)tmp[1]);
            map.put(name, value);
            ++n2;
        }
        return map;
    }

    protected ModelBusPackageRegistryImpl getModelBusPackageRegistryImpl() {
        if (this.modelBusPackageRegistryImpl == null) {
            this.modelBusPackageRegistryImpl = new ModelBusPackageRegistryImpl(this);
        }
        return this.modelBusPackageRegistryImpl;
    }

    @Override
    public boolean addModelBusRepositoryListener(IModelBusRepositoryListener modelBusRepositoryListener) {
        return this.modelBusRepositoryListeners.add(modelBusRepositoryListener);
    }

    @Override
    public boolean removeModelBusRepositoryListener(IModelBusRepositoryListener modelBusRepositoryListener) {
        return this.modelBusRepositoryListeners.remove(modelBusRepositoryListener);
    }

    protected void notifyCreateModel(URI modelUri, IModelBusSession session) {
        Iterator<IModelBusRepositoryListener> iterator = this.modelBusRepositoryListeners.iterator();
        while (iterator.hasNext()) {
            IModelBusRepositoryListener iModelBusRepositoryListener;
            IModelBusRepositoryListener currentModelBusRepositoryListener = iModelBusRepositoryListener = iterator.next();
            currentModelBusRepositoryListener.createModel(modelUri, session);
        }
    }

    protected void notifyUpdateModel(URI modelUri, IModelBusSession session) {
        Iterator<IModelBusRepositoryListener> iterator = this.modelBusRepositoryListeners.iterator();
        while (iterator.hasNext()) {
            IModelBusRepositoryListener iModelBusRepositoryListener;
            IModelBusRepositoryListener currentModelBusRepositoryListener = iModelBusRepositoryListener = iterator.next();
            currentModelBusRepositoryListener.updateModel(modelUri, session);
        }
    }

    public void notifyDeleteModel(URI modelUri, IModelBusSession session) {
        Iterator<IModelBusRepositoryListener> iterator = this.modelBusRepositoryListeners.iterator();
        while (iterator.hasNext()) {
            IModelBusRepositoryListener iModelBusRepositoryListener;
            IModelBusRepositoryListener currentModelBusRepositoryListener = iModelBusRepositoryListener = iterator.next();
            currentModelBusRepositoryListener.deleteModel(modelUri, session);
        }
    }

    protected void notifyCommitChangeModel(String messageID, URI modelURI, DataHandler changeModelContent) {
        Iterator<IModelBusRepositoryListener> iterator = this.modelBusRepositoryListeners.iterator();
        while (iterator.hasNext()) {
            IModelBusRepositoryListener iModelBusRepositoryListener;
            IModelBusRepositoryListener currentModelBusRepositoryListener = iModelBusRepositoryListener = iterator.next();
            currentModelBusRepositoryListener.commitChangeModelNotification(messageID, modelURI, changeModelContent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URI getAvailablePathURI(IModelBusSession session, URI uri) throws RepositoryAuthentificationException {
        try {
            if (uri.segmentCount() == 0 && !this.exists(session, uri, "-1")) {
                return null;
            }
        }
        catch (NonExistingResourceException e) {
            e.printStackTrace();
            return null;
        }
        String[] pathSegments = uri.segments();
        URI subURI = uri.trimSegments(1);
        try {
            int i = pathSegments.length - 1;
            while (true) {
                if (i < 0) {
                    return subURI;
                }
                if (!this.exists(session, subURI, "-1")) {
                    if (subURI.segmentCount() <= 0) return null;
                    subURI = subURI.trimSegments(1);
                }
                --i;
            }
        }
        catch (NonExistingResourceException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void registerUMLMetaModel(IModelBusSession session) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        URI[] modelURIs;
        URI uml500URI = URI.createURI((String)"http://www.eclipse.org/uml2/5.0.0/UML");
        URI uml400URI = URI.createURI((String)"http://www.eclipse.org/uml2/4.0.0/UML");
        URI uml300URI = URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML");
        URI uml210URI = URI.createURI((String)"http://www.eclipse.org/uml2/2.1.0/UML");
        URI uml500TypesURI = URI.createURI((String)"http://www.eclipse.org/uml2/5.0.0/Types");
        URI uml400TypesURI = URI.createURI((String)"http://www.eclipse.org/uml2/4.0.0/Types");
        URI[] uRIArray = modelURIs = new URI[]{uml500URI, uml400URI, uml300URI, uml210URI, uml500TypesURI, uml400TypesURI};
        int n = modelURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI mmURI = uRIArray[n2];
            if (!this.getModelBusPackageRegistryImpl().containsKey(mmURI.toString()) && this.exists(session, mmURI, "-1")) {
                Resource resource = this.checkOutModel(session, mmURI);
                EPackage ePackage = (EPackage)resource.getContents().get(0);
                ePackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
                this.registerUMLPackage(ePackage);
            }
            ++n2;
        }
    }

    private void registerUMLPackage(EPackage ePackage) {
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
        this.getModelBusPackageRegistryImpl().put(ePackage.getNsURI(), ePackage);
        if (!this.packages.contains(ePackage)) {
            this.packages.add(ePackage);
            int p = 0;
            while (p < ePackage.getESubpackages().size()) {
                EPackage e_package = (EPackage)ePackage.getESubpackages().get(p);
                this.registerUMLPackage(e_package);
                ++p;
            }
        }
    }

    protected void registerUMLProfiles(IModelBusSession session) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        URI ecoreProfile = URI.createURI((String)"http://UML_PROFILES/Ecore.profile.uml");
        URI standardProfile = URI.createURI((String)"http://UML_PROFILES/Standard.profile.uml");
        URI uml400L2Profile = URI.createURI((String)"http://UML_PROFILES/StandardL2.profile.uml");
        URI uml400L3Profile = URI.createURI((String)"http://UML_PROFILES/StandardL3.profile.uml");
        this.registerUMLMetaModel(session);
        if (!this.getModelBusPackageRegistryImpl().containsKey("http://www.eclipse.org/uml2/schemas/Ecore/5") && this.exists(session, ecoreProfile, "-1")) {
            this.registerUMLProfilePackages(ecoreProfile);
        }
        if (!this.getModelBusPackageRegistryImpl().containsKey("http://www.eclipse.org/uml2/schemas/Standard/1") && this.exists(session, standardProfile, "-1")) {
            this.registerUMLProfilePackages(standardProfile);
        }
        if (!this.getModelBusPackageRegistryImpl().containsKey("http://www.eclipse.org/uml2/4.0.0/UML/Profile/L2") && this.exists(session, uml400L2Profile, "-1")) {
            this.registerUMLProfilePackages(uml400L2Profile);
        }
        if (!this.getModelBusPackageRegistryImpl().containsKey("http://www.eclipse.org/uml2/4.0.0/UML/Profile/L3") && this.exists(session, uml400L3Profile, "-1")) {
            this.registerUMLProfilePackages(uml400L3Profile);
        }
    }

    private void registerUMLProfilePackages(URI profileLocation) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        Resource resource = this.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, profileLocation, "-1", new HashMap<String, Object>());
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject currentObject = (EObject)iterator.next();
            if (currentObject instanceof EAnnotation) {
                EAnnotation annotation = (EAnnotation)currentObject;
                EList contents = annotation.getContents();
                for (EObject object1 : contents) {
                    if (!(object1 instanceof EPackage)) continue;
                    EPackage currentPackage = (EPackage)object1;
                    this.getModelBusPackageRegistryImpl().put(currentPackage.getNsURI(), currentPackage);
                }
                continue;
            }
            if (!(currentObject instanceof EPackage)) continue;
            EPackage currentPackage = (EPackage)currentObject;
            this.getModelBusPackageRegistryImpl().put(currentPackage.getNsURI(), currentPackage);
        }
    }

    protected void registerNotationDiMetaModels(IModelBusSession session) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        URI notationURI = URI.createURI((String)"http://www.eclipse.org/gmf/runtime/1.0.2/notation");
        URI diURI = URI.createURI((String)"http://www.eclipse.org/papyrus/0.7.0/sashdi");
        this.registerPackage(session, notationURI);
        this.registerPackage(session, diURI);
    }

    private void registerPackage(IModelBusSession session, URI modelURI) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        if (!this.getModelBusPackageRegistryImpl().containsKey(modelURI.toString()) && this.exists(session, modelURI, "-1")) {
            Resource resource = this.checkOutModel(session, modelURI);
            EPackage notationPackage = (EPackage)resource.getContents().get(0);
            notationPackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
            this.registerUMLPackage(notationPackage);
        }
    }

    protected void registerIBMNotationMetaModels(IModelBusSession session) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        URI notationUri = URI.createURI((String)"http://www.ibm.com/xtools/1.5.3/Umlnotation");
        URI rmpNotationUri = URI.createURI((String)"http://www.ibm.com/xtools/1.0.0/rmpnotation");
        this.registerPackage(session, notationUri);
        this.registerPackage(session, rmpNotationUri);
    }

    @Override
    public String checkInModel(IModelBusSession session, Resource resource, String logMessage, OptionsMap options) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, LockedException, UnresolvedReferencesException {
        try {
            this.accessManager.checkAccessRights(session, resource.getURI(), 2);
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        URI uri = resource.getURI();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)byteArrayOutputStream, Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return this.internalSaveFile(session, uri, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), logMessage, 2, options);
    }

    @Override
    public String checkInModelLowLevel(IModelBusSession session, URI modelUri, DataSource modelDataSource, boolean enableDependencies, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException {
        InputStream dataSourceInputStream;
        try {
            this.accessManager.checkAccessRights(session, modelUri, 2);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        this.lockManager.getLockInfosFor(modelUri);
        try {
            dataSourceInputStream = modelDataSource.getInputStream();
        }
        catch (IOException exc) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(exc);
        }
        File tempFile = AbstractModelBusRepository._writeToTemporaryFile(dataSourceInputStream);
        if (enableDependencies) {
            try {
                this.saveModelDependencies(session, modelUri, tempFile, options);
            }
            catch (RepositoryRuntimeException exc) {
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
                throw exc;
            }
        }
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(tempFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        try {
            return this.checkInFile(session, modelUri, inStream, logMessage, options);
        }
        catch (LockedException e) {
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Resource checkOutModel(IModelBusSession session, URI modelURI) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        return this.checkOutModel(session, modelURI, "-1", new HashMap<String, Object>());
    }

    @Override
    public boolean commitChangeModel(IModelBusSession session, String messageID, URI remoteModelUri, DataSource changeModelContent) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            this.accessManager.checkAccessRights(session, remoteModelUri, 2);
        }
        catch (NonExistingResourceException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        File tempFile = null;
        try {
            tempFile = AbstractModelBusRepository._writeToTemporaryFile(changeModelContent.getInputStream());
            FileInputStream contentInputStream = new FileInputStream(tempFile);
            this.changeCommitManager.applyChanges(contentInputStream, (EPackage.Registry)this.getModelBusPackageRegistryImpl());
            ((InputStream)contentInputStream).close();
            FileDataSource fileDataSource = new FileDataSource(tempFile);
            DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
            this.notifyCommitChangeModel(messageID, remoteModelUri, dataHandler);
            return true;
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    @Override
    public boolean publishService(IModelBusSession session, ServiceProperties properties) throws RepositoryAuthentificationException, InvalidServiceDescriptionException, RepositoryRuntimeException {
        try {
            this.accessManager.checkAccessRights(session, this.servicesManager.getStatusModel().eResource().getURI(), 1);
        }
        catch (NonExistingResourceException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        return this.servicesManager.addService(properties);
    }

    @Override
    public boolean unpublishService(IModelBusSession session, ServiceProperties properties) throws RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            this.accessManager.checkAccessRights(session, this.servicesManager.getStatusModel().eResource().getURI(), 1);
        }
        catch (NonExistingResourceException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        return this.servicesManager.removeService(properties);
    }

    @Override
    public StatusModel getStatusModel(IModelBusSession session) throws RepositoryAuthentificationException {
        try {
            this.accessManager.checkAccessRights(session, this.servicesManager.getStatusModel().eResource().getURI(), 1);
        }
        catch (NonExistingResourceException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        return this.servicesManager.getStatusModel();
    }

    protected static URI getRemoteURI(URI uriToCheck) {
        if (uriToCheck.toString().startsWith("pathmap://")) {
            return URI.createURI((String)uriToCheck.toString().replace("pathmap://", "http://"));
        }
        String uriToCheckString = uriToCheck.toString().replace("\\", "/");
        int schemeOffset = uriToCheckString.indexOf("://");
        if (schemeOffset == -1) {
            return URI.createURI((String)("http://" + uriToCheckString));
        }
        return uriToCheck;
    }

    @Override
    public Resource checkOutModel(IModelBusSession session, URI uri, String revision, Map<String, Object> properties) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        String mimeTypeProperty;
        AbstractModelBusRepository._initializeEcore();
        ResourceSet resourceSet = this.createResourceSet(session);
        this.registerResourceFactoryForURIAtResourceSet(resourceSet, uri);
        if (!properties.containsKey("Content-Type") && (mimeTypeProperty = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(uri), "MB_MimeType", revision)) != null) {
            properties.put("Content-Type", mimeTypeProperty);
        }
        Resource resource = this.createResource(resourceSet, uri, properties);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.checkOutModelLowLevel(session, uri, revision, properties, byteArrayOutputStream);
        try {
            resource.load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return resource;
    }

    @Override
    public Resource createModel(IModelBusSession session, URI metaModelUri, URI modelUri, URI rootElementUri, String logMessage, OptionsMap options) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, UnresolvedReferencesException {
        try {
            this.accessManager.checkAccessRights(session, modelUri, 2);
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        EcorePackage.eINSTANCE.getNsURI().equals(metaModelUri);
        AbstractModelBusRepository._initializeEcore();
        ResourceSet resourceSet = this.createResourceSet(session);
        Resource resource = this.createResource(resourceSet, modelUri, options);
        EClass class1 = (EClass)resourceSet.getEObject(rootElementUri, true);
        EObject object1 = class1.getEPackage().getEFactoryInstance().create(class1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        resource.getContents().add((Object)object1);
        try {
            resource.save((OutputStream)byteArrayOutputStream, Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        modelUri = AbstractModelBusRepository.getRemoteURI(modelUri);
        this.internalSaveFile(session, modelUri, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), logMessage, 1, options);
        return resource;
    }

    @Override
    public long checkOutModelLowLevel(IModelBusSession session, URI uri, String revision, Map<String, Object> properties, OutputStream content) throws RepositoryAuthentificationException, UnresolvedReferencesException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        String filteredPath = uri.authority();
        String uriPath = uri.path();
        if (uriPath != null) {
            filteredPath = String.valueOf(filteredPath) + uriPath;
        }
        if (uri.fragment() == null || "".equals(uri.fragment())) {
            return this.internalLoadFile(session, filteredPath, revision, properties, content, true);
        }
        Resource resource = this.checkOutModel(session, uri.trimFragment(), revision, properties);
        EObject fragment = resource.getEObject(uri.fragment());
        HashMap<String, List<EObject>> options = new HashMap<String, List<EObject>>();
        options.put("ROOT_OBJECTS", Collections.singletonList(fragment));
        try {
            resource.save(content, options);
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return 0L;
    }

    @Override
    public long checkOutFile(IModelBusSession session, URI uri, String revision, Map<String, Object> properties, OutputStream content) throws RepositoryAuthentificationException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        String filteredPath = "/" + uri.authority();
        String uriPath = uri.path();
        if (uriPath != null) {
            filteredPath = String.valueOf(filteredPath) + uriPath;
        }
        filteredPath = URI.decode((String)URI.decode((String)filteredPath));
        return this.internalLoadFile(session, filteredPath, revision, properties, content, true);
    }

    @Override
    public String createModelwithContent(IModelBusSession session, URI modelUri, DataSource modelDataSource, boolean enableDependencies, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException {
        InputStream dataSourceInputStream;
        try {
            this.accessManager.checkAccessRights(session, modelUri, 2);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        this.lockManager.checkCompletlyAccessibleForUser(modelUri, session.getValueForKey("username"));
        try {
            dataSourceInputStream = modelDataSource.getInputStream();
        }
        catch (IOException exc) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(exc);
        }
        File tempFile = AbstractModelBusRepository._writeToTemporaryFile(dataSourceInputStream);
        if (enableDependencies) {
            try {
                this.saveModelDependencies(session, modelUri, tempFile, options);
            }
            catch (RepositoryRuntimeException exc) {
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
                throw exc;
            }
        }
        if (!this.exists(session, modelUri, "-1")) {
            FileInputStream inStream;
            modelUri = AbstractModelBusRepository.getRemoteURI(modelUri);
            try {
                inStream = new FileInputStream(tempFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(e);
            }
            try {
                try {
                    this.internalSaveFile(session, modelUri, inStream, logMessage, 1, options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
        }
        return "OK";
    }

    private ModelBusURIHandler getModelBusURIHandler(IModelBusSession session) {
        if (this.modelBusURIHandler == null) {
            this.modelBusURIHandler = new ModelBusURIHandler(this, session);
        }
        return this.modelBusURIHandler;
    }

    protected ResourceSet createResourceSet(IModelBusSession session) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry((EPackage.Registry)this.getModelBusPackageRegistryImpl());
        EList uriHandlers = resourceSet.getURIConverter().getURIHandlers();
        ModelBusURIHandler modelBusURIHandler = this.getModelBusURIHandler(session);
        if (!uriHandlers.contains((Object)modelBusURIHandler)) {
            uriHandlers.add(0, (Object)modelBusURIHandler);
        }
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    protected Resource createResource(ResourceSet resourceSet, URI uri, OptionsMap options) {
        return this.createResource(resourceSet, uri, AbstractModelBusRepository.optionsMapToMap(options));
    }

    protected Resource createResource(ResourceSet resourceSet, URI uri, Map<String, Object> options) {
        Resource.Factory resourceFactory;
        IResourceHandler resourceHandler;
        String contentTypeOption = AbstractModelBusRepository.getOptionAsString(options, "Content-Type");
        Resource resource = null;
        if (contentTypeOption != null && (resourceHandler = ResourceHandlerFactory.getInstance().getResourceHandlerForContentType(contentTypeOption)) != null && (resourceFactory = resourceHandler.createResourceFactory()) != null) {
            resource = resourceFactory.createResource(uri);
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
        if (resource == null) {
            resource = resourceSet.createResource(uri);
        }
        return resource;
    }

    protected void registerResourceFactoryForURIAtResourceSet(ResourceSet resourceSet, URI uri) {
        Object factory = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(uri.fileExtension());
        if (factory instanceof Resource.Factory.Descriptor) {
            factory = ((Resource.Factory.Descriptor)factory).createFactory();
        }
        if (factory != null && factory instanceof Resource.Factory) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(uri.fileExtension(), factory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(uri.fileExtension(), new XMIResourceFactoryImpl());
        }
    }

    protected void saveModelDependencies(IModelBusSession session, URI modelURI, File modelFile, OptionsMap options) throws RepositoryRuntimeException {
        if (ModelBusCoreUtil.URIUtil.fileExtensionEquals((URI)modelURI, (String)"dependencies") || ModelBusCoreUtil.URIUtil.uriStartsWith((URI)modelURI, (String)"http:///schemas") || ModelBusCoreUtil.StringUtil.stringIsInArray((String)modelURI.authority(), (String[])new String[]{"www.eclipse.org", "UML_METAMODELS", "UML_LIBRARIES", "UML_PROFILES", "UML2_MSL_PROFILES"})) {
            return;
        }
        try {
            AbstractModelBusRepository._initializeEcore();
            ResourceSet resourceSet = this.createResourceSet(session);
            this.registerResourceFactoryForURIAtResourceSet(resourceSet, modelURI);
            try {
                this.registerUMLMetaModel(session);
                this.registerUMLProfiles(session);
                this.registerIBMNotationMetaModels(session);
                this.registerNotationDiMetaModels(session);
            }
            catch (Exception exc) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(exc);
            }
            Resource tmpResource = this.createResource(resourceSet, modelURI, options);
            try (FileInputStream tempInput = new FileInputStream(modelFile);){
                try {
                    tmpResource.load((InputStream)tempInput, Collections.EMPTY_MAP);
                }
                catch (Exception e) {
                    tmpResource.unload();
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.dependenciesManager.saveDependencies(tmpResource);
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
            tmpResource.unload();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LockInfo[] getLocks(IModelBusSession session, String modelUriPrefix) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        return this.lockManager.getLockInfos();
    }

    @Override
    public void lock(IModelBusSession session, URI modelUri) throws InvalidValueException, RepositoryAuthentificationException, NonExistingResourceException, ConstraintViolationException, UnresolvedReferencesException, LockedException {
        try {
            this.accessManager.checkAccessRights(session, modelUri, 2);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        this.lockManager.lock(modelUri, session.getValueForKey("username"));
    }

    @Override
    public void unlock(IModelBusSession session, URI modelUri) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        this.accessManager.checkAccessRights(session, modelUri, 2);
        this.lockManager.unlock(modelUri, session.getValueForKey("username"));
    }

    @Override
    public DependenciesInfo getDependencies(IModelBusSession session, URI uri, boolean includeIncomingReferences, boolean includeOutgoingReferences) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e1) {
            throw new RepositoryRuntimeException(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.registerUMLProfiles(session);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        DependenciesInfo dependenciesInfo = new DependenciesInfo();
        try {
            if (includeIncomingReferences) {
                IncomingReferencesInfo[] incomingReferences;
                IncomingReferencesInfo[] incomingReferencesInfoArray = incomingReferences = this.dependenciesManager.getIncomingReferencesFor(uri);
                int n = incomingReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IncomingReferencesInfo incomingReference = incomingReferencesInfoArray[n2];
                    dependenciesInfo.getIncomingReferencesInfos().add(incomingReference);
                    ++n2;
                }
            }
            if (includeOutgoingReferences) {
                List<String> outgoingReferences = this.dependenciesManager.getDependenciesFor(uri);
                for (String oReference : outgoingReferences) {
                    OutgoingReferencesInfo refInfo = new OutgoingReferencesInfo();
                    refInfo.setModelUrl(oReference);
                    dependenciesInfo.getOutgoingReferencesInfos().add(refInfo);
                }
            }
        }
        catch (UnresolvedReferencesException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        return dependenciesInfo;
    }

    @Override
    public boolean authenticate(String username, String password) throws InvalidValueException, RepositoryAuthentificationException, ConstraintViolationException, UnresolvedReferencesException {
        return this.accessManager.validateUser(username, password);
    }

    protected List<URI> getAllReferencingModelUris(Resource resource) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException {
        IncomingReferencesInfo[] dependenciesInfos;
        ArrayList<URI> uris = new ArrayList<URI>();
        IncomingReferencesInfo[] incomingReferencesInfoArray = dependenciesInfos = this.dependenciesManager.getIncomingReferencesFor(resource.getURI());
        int n = dependenciesInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IncomingReferencesInfo dependenciesInfo = incomingReferencesInfoArray[n2];
            URI modelUrl = URI.createURI((String)dependenciesInfo.getReferencingObjectUri());
            if (this.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelUrl, "-1")) {
                uris.add(modelUrl);
            }
            ++n2;
        }
        return uris;
    }

    protected List<URI> resolveAll(Resource resource) throws RepositoryAuthentificationException, IOException, NonExistingResourceException, UnresolvedReferencesException {
        ResourceSet resourceSet = resource.getResourceSet();
        IModelBusSession session = AccessManager.INTERNAL_MODEL_BUS_SESSION;
        List<URI> uris = this.getAllReferencingModelUris(resource);
        for (URI modelURI : uris) {
            if (!this.exists(session, modelURI, "-1")) continue;
            HashMap<String, Object> options = new HashMap<String, Object>();
            String mimeTypeProperty = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(modelURI), "MB_MimeType", "-1");
            if (mimeTypeProperty != null) {
                options.put("Content-Type", mimeTypeProperty);
            }
            Resource referencingResource = this.createResource(resourceSet, modelURI, options);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.checkOutFile(session, modelURI, "-1", new HashMap<String, Object>(), output);
            try {
                referencingResource.load((InputStream)new ByteArrayInputStream(output.toByteArray()), Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
        }
        catch (Exception exception) {}
        return uris;
    }

    protected void saveAll(Resource resource, List<URI> models, Map<String, Object> saveOptions, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, LockedException, NonExistingResourceException {
        ResourceSet resourceSet = resource.getResourceSet();
        IModelBusSession session = AccessManager.INTERNAL_MODEL_BUS_SESSION;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)outputStream, saveOptions);
            this.dependenciesManager.saveDependencies(resource);
            this.checkInFile(session, resource.getURI(), new ByteArrayInputStream(outputStream.toByteArray()), logMessage, options);
            outputStream.close();
            for (URI modelUri : models) {
                Resource referencingResource = resourceSet.getResource(modelUri, true);
                if (referencingResource == null) continue;
                outputStream = new ByteArrayOutputStream();
                referencingResource.save((OutputStream)outputStream, saveOptions);
                this.dependenciesManager.saveDependencies(referencingResource);
                if (this.exists(session, modelUri, "-1")) {
                    this.checkInFile(session, modelUri, new ByteArrayInputStream(outputStream.toByteArray()), logMessage, options);
                } else {
                    this.createFile(session, modelUri, new ByteArrayInputStream(outputStream.toByteArray()), logMessage, options);
                }
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public String commit(IModelBusSession session, List<PathFileContentMapEntry> createFileMap, List<PathFileContentMapEntry> checkInFileMap, List<String> folderPaths, List<String> deletionPaths, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        try {
            File tempFile;
            DataSource dataSource;
            DataHandler dataHandler;
            String path;
            if (folderPaths != null) {
                for (String folderPath : folderPaths) {
                    this.createDir(session, URI.createURI((String)folderPath), logMessage, options);
                }
            }
            if (createFileMap != null) {
                for (PathFileContentMapEntry mapEntry : createFileMap) {
                    path = mapEntry.getPath();
                    dataHandler = mapEntry.getFileContent();
                    dataSource = dataHandler.getDataSource();
                    tempFile = AbstractModelBusRepository._writeToTemporaryFile(dataSource.getInputStream());
                    this.createFile(session, URI.createURI((String)path), new FileInputStream(tempFile), logMessage, options);
                    if (tempFile == null || !tempFile.exists()) continue;
                    tempFile.delete();
                }
            }
            if (checkInFileMap != null) {
                for (PathFileContentMapEntry mapEntry : checkInFileMap) {
                    path = mapEntry.getPath();
                    dataHandler = mapEntry.getFileContent();
                    dataSource = dataHandler.getDataSource();
                    tempFile = AbstractModelBusRepository._writeToTemporaryFile(dataSource.getInputStream());
                    this.checkInFile(session, URI.createURI((String)path), new FileInputStream(tempFile), logMessage, options);
                    if (tempFile == null || !tempFile.exists()) continue;
                    tempFile.delete();
                }
            }
            if (deletionPaths != null) {
                for (String deletionPath : deletionPaths) {
                    this.delete(session, URI.createURI((String)deletionPath), logMessage, "-1");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return "OK";
    }

    @Override
    public final IModelBusExtendedRepositoryLogEntry getExtendedLogEntry(IModelBusSession session, String revision, long revisionDate) throws RepositoryAuthentificationException, RepositoryRuntimeException, InvalidValueException, ConstraintViolationException {
        if (revision == null && revisionDate == -1L) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException("Either revision string or revision date needed");
        }
        if (revision != null) {
            return this._getExtendedLogEntryByRevision(session, revision);
        }
        return this._getExtendedLogEntryByDate(session, revisionDate);
    }

    @Override
    public boolean exists(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        boolean exists = this.internalExists(session, uri, revision);
        if (exists) {
            return true;
        }
        if (this.areSymbolicLinksEnabled()) {
            URI symURI = this.getSymLinkForFileURI(session, uri, revision);
            if (symURI == null) {
                return false;
            }
            return this.internalExists(session, symURI, revision);
        }
        return false;
    }

    protected boolean internalExists(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        return this._internalExists(session, uri, revision);
    }

    @Override
    public void control(IModelBusSession session, URI fragmentUri, URI fragmentFileLocationURI, String logMessage) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException, UnresolvedReferencesException, InvalidValueException, ConstraintViolationException {
        URI resourceUri = fragmentUri.trimFragment();
        this.accessManager.checkAccessRights(session, resourceUri, 2);
        this.accessManager.checkAccessRights(session, fragmentFileLocationURI, 2);
        try {
            Resource fragmentResource;
            String fragment = fragmentUri.fragment();
            this.registerUMLMetaModel(session);
            this.registerUMLProfiles(session);
            this.registerIBMNotationMetaModels(session);
            this.registerNotationDiMetaModels(session);
            Resource parentModelResource = null;
            parentModelResource = this.checkOutModel(session, resourceUri, "-1", new HashMap<String, Object>());
            List<URI> referencingModels = this.resolveAll(parentModelResource);
            ResourceSet resourceSet = parentModelResource.getResourceSet();
            Map idMap = new HashMap();
            if (parentModelResource instanceof XMIResourceImpl) {
                idMap = ((XMIResource)parentModelResource).getEObjectToIDMap();
            }
            if ((fragmentResource = this.createResource(resourceSet, fragmentFileLocationURI, new HashMap<String, Object>())) instanceof XMIResourceImpl) {
                ((XMIResource)fragmentResource).getEObjectToIDMap().putAll(idMap);
            }
            EObject fragmentObject = parentModelResource.getEObject(fragment);
            fragmentResource.getContents().add((Object)fragmentObject);
            HashMap<String, Object> saveOptions = new HashMap<String, Object>();
            saveOptions.put("USE_XMI_TYPE", true);
            this.saveAll(parentModelResource, referencingModels, saveOptions, logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
            ByteArrayOutputStream fragmentOutputStream = new ByteArrayOutputStream();
            fragmentResource.save((OutputStream)fragmentOutputStream, saveOptions);
            this.dependenciesManager.saveDependencies(fragmentResource);
            if (this.exists(session, fragmentFileLocationURI, "-1")) {
                this.checkInFile(session, fragmentFileLocationURI, new ByteArrayInputStream(fragmentOutputStream.toByteArray()), logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
            } else {
                this.createFile(session, fragmentFileLocationURI, new ByteArrayInputStream(fragmentOutputStream.toByteArray()), logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
            }
            fragmentOutputStream.close();
            this.control_SetModelFragmentProperties(session, resourceUri, fragmentFileLocationURI, fragmentUri, logMessage);
        }
        catch (IOException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(e);
        }
    }

    @Override
    public void uncontrol(IModelBusSession session, URI fragmentFileLocationURI, String logMessage) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        this.accessManager.checkAccessRights(session, fragmentFileLocationURI, 2);
        try {
            ResourceSet resourceSet = this.createResourceSet(session);
            String parentModelFullURIString = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(fragmentFileLocationURI), "MB_ParentModel", "-1");
            URI parentModelUri = URI.createURI((String)parentModelFullURIString).trimFragment();
            this.accessManager.checkAccessRights(session, parentModelUri, 2);
            this.registerUMLMetaModel(session);
            Resource parentModelResource = this.createResource(resourceSet, parentModelUri, new HashMap<String, Object>());
            Resource fragmentResource = this.createResource(resourceSet, fragmentFileLocationURI, new HashMap<String, Object>());
            ByteArrayOutputStream parentModelOutput = new ByteArrayOutputStream();
            this.checkOutFile(session, parentModelUri, "-1", new HashMap<String, Object>(), parentModelOutput);
            parentModelResource.unload();
            parentModelResource.load((InputStream)new ByteArrayInputStream(parentModelOutput.toByteArray()), Collections.EMPTY_MAP);
            parentModelOutput.close();
            ByteArrayOutputStream fragmentOutput = new ByteArrayOutputStream();
            this.checkOutFile(session, fragmentFileLocationURI, "-1", new HashMap<String, Object>(), fragmentOutput);
            fragmentResource.unload();
            fragmentResource.load((InputStream)new ByteArrayInputStream(fragmentOutput.toByteArray()), Collections.EMPTY_MAP);
            fragmentOutput.close();
            List<URI> referencingModelUris = this.resolveAll(fragmentResource);
            if (parentModelResource instanceof XMIResource && fragmentResource instanceof XMIResource) {
                Map fragmentIDMap = ((XMIResource)fragmentResource).getEObjectToIDMap();
                ((XMIResource)parentModelResource).getEObjectToIDMap().putAll(fragmentIDMap);
            }
            EObject fragmentObject = (EObject)fragmentResource.getContents().get(0);
            fragmentResource.getContents().remove((Object)fragmentObject);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("USE_XMI_TYPE", true);
            this.saveAll(fragmentResource, referencingModelUris, options, logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
            String childModelUri = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(fragmentFileLocationURI), "MB_ChildModel", "-1");
            if (childModelUri != null && !childModelUri.isEmpty()) {
                this.uncontrol_SetModelParentProperty(session, parentModelUri, URI.createURI((String)childModelUri), logMessage);
            }
            this.delete(session, fragmentFileLocationURI, "", "-1");
            this.dependenciesManager.deleteDependenciesInfos(fragmentFileLocationURI);
        }
        catch (IOException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException(e);
        }
    }

    private static URI toFileSystemRelativeURI(URI remoteURI) {
        String fileName = "/" + remoteURI.authority();
        String uriPath = remoteURI.path();
        if (uriPath != null) {
            fileName = String.valueOf(fileName) + uriPath;
        }
        return URI.createURI((String)fileName);
    }

    @Override
    public List<IModelBusDirEntry> info(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException {
        ArrayList<IModelBusDirEntry> entriesReturn = new ArrayList<IModelBusDirEntry>();
        IModelBusDirEntry entry = this.infoFileSystem(session, uri, revision);
        if (entry != null) {
            IModelBusDirEntry symLinkEntry;
            entriesReturn.add(entry);
            String linkURI = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(uri), "MB_SymLink", revision);
            if (linkURI != null && (symLinkEntry = this.infoFileSystem(session, URI.createURI((String)linkURI), revision)) != null) {
                symLinkEntry.setName(uri.lastSegment());
                symLinkEntry.setUrl(uri.toString());
                entriesReturn.add(symLinkEntry);
            }
        }
        return entriesReturn;
    }

    @Override
    public List<ModelBusNodeKind> checkPath(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        ModelBusNodeKind symLinkNodeKind;
        ArrayList<ModelBusNodeKind> nodeKindsReturn = new ArrayList<ModelBusNodeKind>();
        ModelBusNodeKind nodeKind = this.checkPathFileSystem(session, uri, revision);
        if (nodeKind == null) {
            return nodeKindsReturn;
        }
        nodeKindsReturn.add(nodeKind);
        String linkURI = this.getFileProperty(session, AbstractModelBusRepository.toFileSystemRelativeURI(uri), "MB_SymLink", revision);
        if (linkURI != null && (symLinkNodeKind = this.checkPathFileSystem(session, URI.createURI((String)linkURI), revision)) != null && !symLinkNodeKind.equals((Object)nodeKind)) {
            nodeKindsReturn.add(symLinkNodeKind);
        }
        return nodeKindsReturn;
    }

    @Override
    public boolean areSymbolicLinksEnabled() {
        return this.enableSymbolicLinks;
    }

    protected static File _writeToTemporaryFile(InputStream inputStream) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", ".modelbus");
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer);
            while (read > 0) {
                fileOutputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return tempFile;
    }

    private static void _initializeEcore() {
    }

    protected static RepositoryRuntimeException _createWrappedRepositoryRuntimeException(Exception e, boolean printStackTrace) {
        if (printStackTrace) {
            e.printStackTrace();
        }
        return new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
    }

    protected static RepositoryRuntimeException _createWrappedRepositoryRuntimeException(Exception e) {
        return AbstractModelBusRepository._createWrappedRepositoryRuntimeException(e, true);
    }

    protected static RepositoryRuntimeException _createWrappedRepositoryRuntimeException(String message) {
        return AbstractModelBusRepository._createWrappedRepositoryRuntimeException(new RuntimeException(message));
    }

    protected URI getLinkDirURI(IModelBusSession session, URI fileUri) {
        String dirPath = String.valueOf(fileUri.scheme()) + "://" + fileUri.host();
        Iterator segmentsIt = fileUri.segmentsList().iterator();
        URI fileURIFound = null;
        while (segmentsIt.hasNext() && fileURIFound == null) {
            String segment = (String)segmentsIt.next();
            dirPath = String.valueOf(dirPath) + "/" + segment;
            URI dirPathURI = URI.createURI((String)dirPath);
            try {
                List<ModelBusNodeKind> nodeKinds = this.checkPath(session, dirPathURI, "-1");
                if (nodeKinds == null || nodeKinds.isEmpty() || !ModelBusNodeKind.FILE.equals((Object)nodeKinds.get(0))) continue;
                fileURIFound = dirPathURI;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (fileURIFound != null) {
            String dirName = fileURIFound.lastSegment();
            String symDirName = String.valueOf(dirName) + SYM_DIR_EXTENSION;
            return fileURIFound.trimSegments(1).appendSegment(symDirName);
        }
        return null;
    }

    protected abstract void control_SetModelFragmentProperties(IModelBusSession var1, URI var2, URI var3, URI var4, String var5);

    protected abstract void uncontrol_SetModelParentProperty(IModelBusSession var1, URI var2, URI var3, String var4);

    protected abstract boolean _internalExists(IModelBusSession var1, URI var2, String var3) throws RepositoryAuthentificationException, NonExistingResourceException;

    protected abstract String internalSaveFile(IModelBusSession var1, URI var2, InputStream var3, String var4, int var5, OptionsMap var6);

    protected abstract long internalLoadFile(IModelBusSession var1, String var2, String var3, Map<String, Object> var4, OutputStream var5, boolean var6);

    protected abstract IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByDate(IModelBusSession var1, long var2) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException;

    protected abstract IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByRevision(IModelBusSession var1, String var2) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException;

    protected abstract URI getSymLinkForFileURI(IModelBusSession var1, URI var2, String var3);

    protected abstract String getFileProperty(IModelBusSession var1, URI var2, String var3, String var4);

    protected abstract IModelBusDirEntry infoFileSystem(IModelBusSession var1, URI var2, String var3) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException;
}

