/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.auth;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends TitleAreaDialog {
    private static final long serialVersionUID = 369964276650734767L;
    private static final String DEFAULT_MESSAGE = "Please specify the login credentials";
    private String userName;
    private String password;
    private Button okButton;

    public LoginDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText("Login");
        this.setTitle("ModelBus Manager Login");
        this.setMessage(DEFAULT_MESSAGE);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblUsername = new Label(container, 0);
        lblUsername.setText("Username:");
        TraverseListener returnListener = new TraverseListener(){
            private static final long serialVersionUID = 1L;

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && LoginDialog.this.canComplete()) {
                    LoginDialog.this.okPressed();
                }
            }
        };
        final Text userNameInput = new Text(container, 2048);
        userNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        userNameInput.addTraverseListener(returnListener);
        userNameInput.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 8319031340426041419L;

            public void modifyText(ModifyEvent event) {
                LoginDialog.this.userName = userNameInput.getText();
                LoginDialog.this.checkComplete();
            }
        });
        Label lblPassword = new Label(container, 0);
        lblPassword.setText("Password:");
        final Text passwordInput = new Text(container, 0x400800);
        passwordInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        passwordInput.addTraverseListener(returnListener);
        passwordInput.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -4109886462367300451L;

            public void modifyText(ModifyEvent event) {
                LoginDialog.this.password = passwordInput.getText();
                LoginDialog.this.checkComplete();
            }
        });
        userNameInput.setFocus();
        return area;
    }

    private boolean canComplete() {
        boolean usernameEmpty = this.isEmpty(this.getUsername());
        boolean passwordEmpty = this.isEmpty(this.getPassword());
        return !usernameEmpty && !passwordEmpty;
    }

    private void checkComplete() {
        boolean usernameEmpty = this.isEmpty(this.getUsername());
        boolean passwordEmpty = this.isEmpty(this.getPassword());
        if (passwordEmpty) {
            this.setErrorMessage("Password should not be empty");
        }
        if (usernameEmpty) {
            this.setErrorMessage("Username should not be empty");
        }
        if (this.canComplete()) {
            this.setErrorMessage(null);
            this.setMessage(DEFAULT_MESSAGE, 0);
        }
        this.okButton.setEnabled(this.canComplete());
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }

    public String getUsername() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

