/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.modelbus.desktop.project.api.IProjectSetup;

public class ProjectSetupTemplateFactory {
    private static ProjectSetupTemplateFactory _instance;
    private static final String extensionPointID = "org.modelbus.manager.project.template";
    private static IExtension[] extensions;
    private Map<String, IProjectSetup> setupTemplates;

    private ProjectSetupTemplateFactory() {
    }

    public static synchronized ProjectSetupTemplateFactory getInstance() {
        if (_instance == null) {
            _instance = new ProjectSetupTemplateFactory();
        }
        return _instance;
    }

    public IProjectSetup getProjectSetupTemplate(String templateName) {
        if (templateName == null || "".equals(templateName)) {
            return null;
        }
        Map<String, IProjectSetup> templates = this.getProjectSetupTemplates();
        for (String currentTemplateName : templates.keySet()) {
            if (!templateName.equals(currentTemplateName)) continue;
            return templates.get(currentTemplateName);
        }
        return null;
    }

    public Map<String, IProjectSetup> getProjectSetupTemplates() {
        if (this.setupTemplates == null) {
            this._createEditorFactory();
        }
        return this.setupTemplates;
    }

    private static IExtension[] getExtensions() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        extensions = extensionPoint.getExtensions();
        return extensions;
    }

    private void _createEditorFactory() {
        this.setupTemplates = new HashMap<String, IProjectSetup>();
        IExtension[] iExtensionArray = ProjectSetupTemplateFactory.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement c = iConfigurationElementArray[n4];
                try {
                    Object exec = c.createExecutableExtension("setupClass");
                    String templateName = c.getAttribute("name");
                    if (exec instanceof IProjectSetup) {
                        this.setupTemplates.put(templateName, (IProjectSetup)c.createExecutableExtension("setupClass"));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

