/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.core.lib.util.DefaultLocationsUtil;

public class LocationsUtilFactory {
    private static LocationsUtilFactory _instance;
    private static final String extensionPointID = "org.modelbus.core.lib.locations";
    private static IExtension[] extensions;
    private AbstractLocationsUtil util;

    private LocationsUtilFactory() {
    }

    public static synchronized LocationsUtilFactory getInstance() {
        if (_instance == null) {
            _instance = new LocationsUtilFactory();
        }
        return _instance;
    }

    public AbstractLocationsUtil getLocationsUtil() {
        if (this.util == null) {
            AbstractLocationsUtil loadedUtil = this.createFilterHelper();
            this.util = loadedUtil != null ? loadedUtil : new DefaultLocationsUtil();
        }
        return this.util;
    }

    private static IExtension[] getExtensions() {
        if (extensions == null) {
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
            extensions = extensionPoint.getExtensions();
        }
        return extensions;
    }

    private AbstractLocationsUtil createFilterHelper() {
        try {
            Class.forName("org.eclipse.core.runtime.RegistryFactory");
            IExtension[] iExtensionArray = LocationsUtilFactory.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension element = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
                if (iConfigurationElementArray.length != 0) {
                    IConfigurationElement c = iConfigurationElementArray[0];
                    AbstractLocationsUtil filterHelper = (AbstractLocationsUtil)c.createExecutableExtension("class");
                    return filterHelper;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            try {
                Class<?> locationsUtilClass = Class.forName("org.modelbus.core.lib.util.DefaultLocationsUtil");
                return (AbstractLocationsUtil)locationsUtilClass.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }
}

