/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.ValueSelector;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.swt.widgets.Widget;

public final class WidgetMatcher
implements ValueSelector {
    private final Map<String, Constraint> constraintMap = Collections.synchronizedMap(new HashMap());

    public void addStyle(String string, int style) {
        this.constraintMap.put("[" + string, WidgetMatcher.createStyleConstraint(style));
    }

    public void addState(String string, Constraint constraint) {
        this.constraintMap.put(":" + string, constraint);
    }

    @Override
    public CssValue select(Widget widget, ConditionalValue ... values) {
        CssValue result = null;
        int i = 0;
        while (i < values.length && result == null) {
            ConditionalValue condValue = values[i];
            String[] constraints = condValue.constraints;
            if (this.matches(widget, constraints)) {
                result = condValue.value;
            }
            ++i;
        }
        return result;
    }

    private boolean matches(Widget widget, String[] constraints) {
        String[] stringArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Constraint constraint = this.getConstraint(string);
            if (constraint == null || !constraint.matches(widget)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Constraint getConstraint(String string) {
        Constraint constraint = this.constraintMap.get(string);
        if (constraint == null && string.startsWith(".")) {
            constraint = WidgetMatcher.createVariantConstraint(string.substring(1));
            this.constraintMap.put(string, constraint);
        }
        return constraint;
    }

    private static Constraint createStyleConstraint(final int style) {
        return new Constraint(){

            @Override
            public boolean matches(Widget widget) {
                return (widget.getStyle() & style) != 0;
            }
        };
    }

    private static Constraint createVariantConstraint(final String variant) {
        return new Constraint(){

            @Override
            public boolean matches(Widget widget) {
                return WidgetMatcher.hasVariant(widget, variant);
            }
        };
    }

    private static boolean hasVariant(Widget widget, String variant) {
        String actualVariant = WidgetUtil.getVariant(widget);
        return actualVariant != null && actualVariant.equals(variant);
    }

    public static interface Constraint {
        public boolean matches(Widget var1);
    }
}

