/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class SedaComponent
extends DefaultComponent {
    protected final int maxConcurrentConsumers = 500;
    protected int queueSize;
    protected int defaultConcurrentConsumers = 1;
    private final Map<String, QueueReference> queues = new HashMap<String, QueueReference>();

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setConcurrentConsumers(int size) {
        this.defaultConcurrentConsumers = size;
    }

    public int getConcurrentConsumers() {
        return this.defaultConcurrentConsumers;
    }

    public synchronized BlockingQueue<Exchange> createQueue(String uri, Map<String, Object> parameters) {
        String key = this.getQueueKey(uri);
        QueueReference ref = this.getQueues().get(key);
        if (ref != null) {
            ref.addReference();
            return ref.getQueue();
        }
        Integer size = this.getAndRemoveParameter(parameters, "size", Integer.class);
        LinkedBlockingQueue<Object> queue = size != null && size > 0 ? new LinkedBlockingQueue(size) : (this.getQueueSize() > 0 ? new LinkedBlockingQueue(this.getQueueSize()) : new LinkedBlockingQueue<Exchange>());
        ref = new QueueReference(queue);
        ref.addReference();
        this.getQueues().put(key, ref);
        return queue;
    }

    public Map<String, QueueReference> getQueues() {
        return this.queues;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int consumers = this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, this.defaultConcurrentConsumers);
        boolean limitConcurrentConsumers = this.getAndRemoveParameter(parameters, "limitConcurrentConsumers", Boolean.class, true);
        if (limitConcurrentConsumers && consumers > 500) {
            throw new IllegalArgumentException("The limitConcurrentConsumers flag in set to true. ConcurrentConsumers cannot be set at a value greater than 500 was " + consumers);
        }
        SedaEndpoint answer = new SedaEndpoint(uri, this, this.createQueue(uri, parameters), consumers);
        answer.configureProperties(parameters);
        return answer;
    }

    public String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    @Override
    protected void doStop() throws Exception {
        this.getQueues().clear();
        super.doStop();
    }

    void onShutdownEndpoint(SedaEndpoint endpoint) {
        String key = this.getQueueKey(endpoint.getEndpointUri());
        QueueReference ref = this.getQueues().get(key);
        if (ref != null) {
            ref.removeReference();
            if (ref.getCount() <= 0) {
                this.getQueues().remove(key);
            }
        }
    }

    public static final class QueueReference {
        private final BlockingQueue<Exchange> queue;
        private volatile int count;

        private QueueReference(BlockingQueue<Exchange> queue) {
            this.queue = queue;
        }

        void addReference() {
            ++this.count;
        }

        void removeReference() {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }

        public BlockingQueue<Exchange> getQueue() {
            return this.queue;
        }
    }
}

