/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.FileAppender;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayOutputStream;
import org.apache.kahadb.util.LinkedNodeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataFileAppender
implements FileAppender {
    private static final Logger logger = LoggerFactory.getLogger(DataFileAppender.class);
    protected final Journal journal;
    protected final Map<Journal.WriteKey, Journal.WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object();
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize;
    protected final boolean syncOnComplete;
    protected boolean running;
    private Thread thread;
    int statIdx = 0;
    int[] stats = new int[maxStat];

    public DataFileAppender(Journal dataManager) {
        this.journal = dataManager;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
        this.syncOnComplete = this.journal.isEnableAsyncDiskSync();
    }

    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        Journal.WriteCommand write = new Journal.WriteCommand(location, data, sync);
        WriteBatch batch = this.enqueue(write);
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            IOException exception = batch.exception.get();
            if (exception != null) {
                throw exception;
            }
        }
        return location;
    }

    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        Journal.WriteCommand write = new Journal.WriteCommand(location, data, onComplete);
        WriteBatch batch = this.enqueue(write);
        location.setLatch(batch.latch);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(Journal.WriteCommand write) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            block14: {
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                if (!this.running) {
                    this.running = true;
                    this.thread = new Thread(){

                        public void run() {
                            DataFileAppender.this.processQueue();
                        }
                    };
                    this.thread.setPriority(10);
                    this.thread.setDaemon(true);
                    this.thread.setName("ActiveMQ Data File Writer");
                    this.thread.start();
                    this.firstAsyncException = null;
                }
                if (this.firstAsyncException != null) {
                    throw this.firstAsyncException;
                }
                do {
                    if (this.nextWriteBatch == null) {
                        DataFile file = this.journal.getCurrentWriteFile();
                        if (file.getLength() > this.journal.getMaxFileLength()) {
                            file = this.journal.rotateWriteFile();
                        }
                        this.nextWriteBatch = this.newWriteBatch(write, file);
                        this.enqueueMutex.notifyAll();
                        break block14;
                    }
                    if (this.nextWriteBatch.canAppend(write)) {
                        this.nextWriteBatch.append(write);
                        break block14;
                    }
                    try {
                        while (this.nextWriteBatch != null) {
                            long start = System.currentTimeMillis();
                            this.enqueueMutex.wait();
                            if (maxStat <= 0) continue;
                            logger.info("Watiting for write to finish with full batch... millis: " + (System.currentTimeMillis() - start));
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                } while (!this.shutdown);
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (!write.sync) {
                this.inflightWrites.put(new Journal.WriteKey(write.location), write);
            }
            return this.nextWriteBatch;
        }
    }

    protected WriteBatch newWriteBatch(Journal.WriteCommand write, DataFile file) throws IOException {
        return new WriteBatch(file, file.getLength(), write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processQueue() {
        block41: {
            block37: {
                dataFile = null;
                file = null;
                wb = null;
                try {
                    try {
                        buff = new DataByteArrayOutputStream(this.maxWriteBatchSize);
                        while (true) {
                            block36: {
                                var5_7 = this.enqueueMutex;
                                synchronized (var5_7) {
                                    while (true) {
                                        if (this.nextWriteBatch != null) {
                                            wb = this.nextWriteBatch;
                                            this.nextWriteBatch = null;
                                            this.enqueueMutex.notifyAll();
                                            // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 35, 7, 15] lbl15 : MonitorExitStatement: MONITOREXIT : var5_7
                                            if (dataFile != wb.dataFile) {
                                                break;
                                            }
                                            break block36;
                                        }
                                        if (this.shutdown) {
                                            // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 34, 7, 15] lbl20 : MonitorExitStatement: MONITOREXIT : var5_7
                                            var12_14 = null;
                                            break block37;
                                        }
                                        this.enqueueMutex.wait();
                                    }
                                }
                                if (file != null) {
                                    file.setLength(dataFile.getLength());
                                    dataFile.closeRandomAccessFile(file);
                                }
                                if ((file = (dataFile = wb.dataFile).openRandomAccessFile()).length() < (long)this.journal.preferedFileLength) {
                                    file.setLength(this.journal.preferedFileLength);
                                }
                            }
                            buff.reset();
                            buff.writeInt(Journal.BATCH_CONTROL_RECORD_SIZE);
                            buff.writeByte(2);
                            buff.write(Journal.BATCH_CONTROL_RECORD_MAGIC);
                            buff.writeInt(0);
                            buff.writeLong(0L);
                            forceToDisk = false;
                            for (write = wb.writes.getHead(); write != null; forceToDisk |= write.sync | (this.syncOnComplete != false && write.onComplete != null), write = (Journal.WriteCommand)write.getNext()) {
                                buff.writeInt(write.location.getSize());
                                buff.writeByte(write.location.getType());
                                buff.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
                            }
                            sequence = buff.toByteSequence();
                            buff.reset();
                            buff.skip(5 + Journal.BATCH_CONTROL_RECORD_MAGIC.length);
                            buff.writeInt(sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                            if (this.journal.isChecksum()) {
                                checksum = new Adler32();
                                checksum.update(sequence.getData(), sequence.getOffset() + Journal.BATCH_CONTROL_RECORD_SIZE, sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                                buff.writeLong(checksum.getValue());
                            }
                            file.seek(wb.offset);
                            if (DataFileAppender.maxStat > 0) {
                                if (this.statIdx < DataFileAppender.maxStat) {
                                    this.stats[this.statIdx++] = sequence.getLength();
                                } else {
                                    all = 0L;
                                    while (this.statIdx > 0) {
                                        all += (long)this.stats[--this.statIdx];
                                    }
                                    DataFileAppender.logger.info("Ave writeSize: " + all / (long)DataFileAppender.maxStat);
                                }
                            }
                            file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                            replicationTarget = this.journal.getReplicationTarget();
                            if (replicationTarget != null) {
                                replicationTarget.replicate(wb.writes.getHead().location, sequence, forceToDisk);
                            }
                            if (forceToDisk) {
                                file.getFD().sync();
                            }
                            lastWrite = wb.writes.getTail();
                            this.journal.setLastAppendLocation(lastWrite.location);
                            this.signalDone(wb);
                        }
                    }
                    catch (IOException e) {
                        var5_8 = this.enqueueMutex;
                        synchronized (var5_8) {
                            this.firstAsyncException = e;
                            if (wb != null) {
                                wb.exception.set(e);
                                wb.latch.countDown();
                            }
                            if (this.nextWriteBatch != null) {
                                this.nextWriteBatch.exception.set(e);
                                this.nextWriteBatch.latch.countDown();
                            }
                        }
                        var12_15 = null;
                        try {
                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                    catch (InterruptedException e) {
                        block39: {
                            var12_16 = null;
                            ** try [egrp 5[TRYBLOCK] [13 : 733->745)] { 
lbl98:
                            // 1 sources

                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                            break block39;
lbl101:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                }
                catch (Throwable var11_22) {
                    block40: {
                        var12_17 = null;
                        ** try [egrp 5[TRYBLOCK] [13 : 733->745)] { 
lbl111:
                        // 1 sources

                        if (file != null) {
                            dataFile.closeRandomAccessFile(file);
                        }
                        break block40;
lbl114:
                        // 1 sources

                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    this.shutdownDone.countDown();
                    this.running = false;
                    throw var11_22;
                }
            }
            ** try [egrp 5[TRYBLOCK] [13 : 733->745)] { 
lbl122:
            // 1 sources

            if (file != null) {
                dataFile.closeRandomAccessFile(file);
            }
            break block41;
lbl125:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
        }
        this.shutdownDone.countDown();
        this.running = false;
    }

    protected void signalDone(WriteBatch wb) {
        for (Journal.WriteCommand write = wb.writes.getHead(); write != null; write = (Journal.WriteCommand)write.getNext()) {
            if (!write.sync) {
                this.inflightWrites.remove(new Journal.WriteKey(write.location));
            }
            if (write.onComplete == null) continue;
            try {
                write.onComplete.run();
                continue;
            }
            catch (Throwable e) {
                logger.info("Add exception was raised while executing the run command for onComplete", e);
            }
        }
        wb.latch.countDown();
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final LinkedNodeList<Journal.WriteCommand> writes = new LinkedNodeList();
        public final CountDownLatch latch = new CountDownLatch(1);
        protected final int offset;
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset) {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            DataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
        }

        public WriteBatch(DataFile dataFile, int offset, Journal.WriteCommand write) throws IOException {
            this(dataFile, offset);
            this.append(write);
        }

        public boolean canAppend(Journal.WriteCommand write) {
            int newSize = this.size + write.location.getSize();
            return newSize < DataFileAppender.this.maxWriteBatchSize && this.offset + newSize <= DataFileAppender.this.journal.getMaxFileLength();
        }

        public void append(Journal.WriteCommand write) throws IOException {
            this.writes.addLast(write);
            write.location.setDataFileId(this.dataFile.getDataFileId());
            write.location.setOffset(this.offset + this.size);
            int s = write.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            DataFileAppender.this.journal.addToTotalLength(s);
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

