/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementStrategyFactory {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public ManagementStrategy create(CamelContext context, boolean disableJMX) {
        DefaultManagementStrategy answer = null;
        if (disableJMX || Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            this.log.info("JMX is disabled. Using DefaultManagementStrategy.");
        } else {
            try {
                this.log.info("JMX enabled. Using ManagedManagementStrategy.");
                answer = new ManagedManagementStrategy(new DefaultManagementAgent(context));
                ServiceHelper.startService(answer);
                context.getLifecycleStrategies().add(0, new DefaultManagementLifecycleStrategy(context));
            }
            catch (Exception e) {
                answer = null;
                this.log.warn("Cannot create JMX lifecycle strategy. Fallback to using DefaultManagementStrategy (non JMX).", (Throwable)e);
            }
        }
        if (answer == null) {
            answer = new DefaultManagementStrategy();
        }
        return answer;
    }
}

