/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.common.AccessManager;

public class ModelBusRepositoryCache {
    private static final long DEFAULT_TIMER_INTERVAL = 300000L;
    private HashMap<String, Resource> cache;
    private IModelBusRepository modelBusRepository;
    private long timerInterval = 300000L;
    private Timer timer;

    public ModelBusRepositoryCache(IModelBusRepository modelBusRepositoryImpl) {
        this.modelBusRepository = modelBusRepositoryImpl;
        this.cache = new HashMap();
        this.initializeTimer();
    }

    public ModelBusRepositoryCache(IModelBusRepository modelBusRepositoryImpl, long timerInterval) {
        this.modelBusRepository = modelBusRepositoryImpl;
        this.timerInterval = timerInterval;
        this.cache = new HashMap();
        this.initializeTimer();
    }

    public ModelBusRepositoryCache(IModelBusRepository modelBusRepositoryImpl, long timerInterval, int initialCapacity, float loadFactor) {
        this.modelBusRepository = modelBusRepositoryImpl;
        this.timerInterval = timerInterval;
        this.cache = new HashMap(initialCapacity, loadFactor);
        this.initializeTimer();
    }

    public ModelBusRepositoryCache(IModelBusRepository modelBusRepositoryImpl, long timerInterval, int initialCapacity) {
        this.modelBusRepository = modelBusRepositoryImpl;
        this.timerInterval = timerInterval;
        this.cache = new HashMap(initialCapacity);
        this.initializeTimer();
    }

    public void clear() {
        this.cache.clear();
    }

    private void initializeTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("ModelBusCache Timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!ModelBusRepositoryCache.this.cache.isEmpty()) {
                    ModelBusRepositoryCache.this.cache.clear();
                }
            }
        }, 0L, this.timerInterval);
    }

    public synchronized Resource getResourceForModelLocation(URI modelURI) throws UnresolvedReferencesException, NonExistingResourceException, RepositoryAuthentificationException {
        Resource resource = this.cache.get(modelURI);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceForModelLocationFromRepository(modelURI);
        this.cache.put(modelURI.toString(), resource);
        return resource;
    }

    private Resource getResourceForModelLocationFromRepository(URI modelURI) throws UnresolvedReferencesException, NonExistingResourceException, RepositoryAuthentificationException {
        Resource resource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelURI, "-1", new HashMap<String, Object>());
        return resource;
    }
}

