/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.svn;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IRepositoryFactory;
import org.modelbus.services.repository.server.svn.ModelBusSVNRepositoryConfig;
import org.modelbus.services.repository.server.svn.SVNModelBusRepository;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class ModelBusSVNRepositoryFactory
implements IRepositoryFactory {
    public IModelBusRepository createModelBusRepository(boolean forceCreation) {
        String svnLocation;
        String svnPassword;
        String svnUsername;
        URI repositoryURI;
        block9: {
            repositoryURI = null;
            svnUsername = null;
            svnPassword = null;
            try {
                svnLocation = ModelBusSVNRepositoryConfig.getSvnRepositoryLocation();
                if (svnLocation != null) break block9;
                return null;
            }
            catch (ModelBusException e) {
                e.printStackTrace();
                return null;
            }
        }
        repositoryURI = URI.createURI((String)svnLocation);
        svnUsername = ModelBusSVNRepositoryConfig.getSvnUserName();
        svnPassword = ModelBusSVNRepositoryConfig.getSvnPassword();
        SVNRepository repository = null;
        ModelBusSVNRepositoryConfig.setupRepository();
        boolean isLocalRespository = repositoryURI.isFile();
        File localRepository = null;
        if (isLocalRespository) {
            localRepository = new File(repositoryURI.toFileString());
        }
        BasicAuthenticationManager svnAuthManager = null;
        svnAuthManager = isLocalRespository ? new BasicAuthenticationManager(new SVNAuthentication[0]) : new BasicAuthenticationManager(svnUsername, svnPassword);
        try {
            repository = isLocalRespository ? SVNRepositoryFactory.create((SVNURL)SVNURL.fromFile((File)localRepository)) : SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)repositoryURI.toString()));
            repository.setAuthenticationManager((ISVNAuthenticationManager)svnAuthManager);
            repository.checkPath("/", -1L);
            return new SVNModelBusRepository(repository);
        }
        catch (SVNException e) {
            try {
                if (forceCreation && localRepository != null) {
                    SVNURL repositoryUrl = SVNRepositoryFactory.createLocalRepository((File)localRepository, (boolean)true, (boolean)false);
                    repository = SVNRepositoryFactory.create((SVNURL)repositoryUrl);
                    repository.setAuthenticationManager((ISVNAuthenticationManager)svnAuthManager);
                    return new SVNModelBusRepository(repository);
                }
                throw new RepositoryRuntimeException("error while creating an SVNRepository for location '" + repositoryURI.toString() + "'", (Throwable)e);
            }
            catch (SVNException ee) {
                throw new RepositoryRuntimeException("error while creating an SVNRepository for location '" + repositoryURI.toString() + "'", (Throwable)ee);
            }
        }
    }

    public static IModelBusRepository getDefaultModelBusRepository() {
        throw new RuntimeException("NYI");
    }
}

