/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.model;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.diffmerge.ui.icon.IconProvider;
import org.modelbus.tools.diffmerge.ui.model.ModelCompareViewEventHandler;
import org.modelbus.tools.diffmerge.ui.model.ModelTreeContentProvider;
import org.modelbus.tools.diffmerge.ui.model.ModelTreeLabelProvider;
import org.modelbus.tools.diffmerge.ui.model.ModelViewImpl;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class ModelCompareView
extends Composite
implements EventBusParticipant {
    private ModelViewImpl localTabFolder;
    private ModelViewImpl remoteTabFolder;
    private final ModelCompareViewEventHandler eventHandler;
    private final ModelIdentifier identifier;
    private final ModelBusEventBus eventBus;
    private final IconProvider iconProvider;

    public ModelCompareView(Composite parent, int style, ModelBusEventBus eventBus, IconProvider iconProvider, ModelIdentifier supporter) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.iconProvider = iconProvider;
        this.identifier = supporter;
        this.eventBus = eventBus;
        this.initUI();
        this.eventHandler = new ModelCompareViewEventHandler(eventBus, this.localTabFolder, this.remoteTabFolder);
    }

    private final void initUI() {
        this.localTabFolder = new ModelViewImpl(this, 2048, new ModelTreeContentProvider(), (ILabelProvider)new ModelTreeLabelProvider(this.iconProvider, this.identifier), this.eventBus, true);
        GridData gd_tabFolder = new GridData(4, 4, true, true, 1, 1);
        gd_tabFolder.widthHint = 200;
        this.localTabFolder.setLayoutData(gd_tabFolder);
        this.localTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.remoteTabFolder = new ModelViewImpl(this, 2048, new ModelTreeContentProvider(), (ILabelProvider)new ModelTreeLabelProvider(this.iconProvider, this.identifier), this.eventBus, false);
        GridData gd_tabFolder_1 = new GridData(4, 4, true, true, 1, 1);
        gd_tabFolder_1.widthHint = 200;
        this.remoteTabFolder.setLayoutData(gd_tabFolder_1);
        this.remoteTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
    }

    protected void checkSubclass() {
    }

    public Collection<Object> getAllEventHandlers() {
        HashSet handler = Sets.newHashSet();
        handler.addAll(this.eventHandler.getAllEventHandlers());
        return handler;
    }

    public ModelBusEventBus getEventBus() {
        throw new RuntimeException("Not supported");
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supported");
    }
}

