/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.merge;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelbus.tools.diffmerge.merge.ChangesTracker;
import org.modelbus.tools.diffmerge.merge.ResourceChangesTracker;

class ResourceSetChangesTracker
implements ChangesTracker {
    private final Set<ResourceChangesTracker> tracker = Sets.newHashSet();

    ResourceSetChangesTracker(ResourceSet ... sets) {
        ResourceSet[] resourceSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceSet set = resourceSetArray[n2];
            this.tracker.addAll(this.createNewResourceChangeTracker(set));
            ++n2;
        }
    }

    private Collection<ResourceChangesTracker> createNewResourceChangeTracker(ResourceSet set) {
        HashSet tracker = Sets.newHashSet();
        Resource[] resources = (Resource[])set.getResources().toArray((Object[])new Resource[set.getResources().size()]);
        tracker.add(new ResourceChangesTracker(resources));
        return tracker;
    }

    @Override
    public void startTracking() {
        for (ResourceChangesTracker tr : this.tracker) {
            tr.startTracking();
        }
    }

    @Override
    public Resource[] getChangedResources() {
        HashSet resources = Sets.newHashSet();
        for (ResourceChangesTracker tr : this.tracker) {
            resources.addAll(Arrays.asList(tr.getChangedResources()));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public void stopTracking() {
        for (ResourceChangesTracker tr : this.tracker) {
            tr.stopTracking();
        }
    }
}

