/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.git;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.OptionsMap;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.IModelBusExtendedRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.ModelBusRepositoryPathMappingHelper;
import org.modelbus.services.repository.server.git.FileProperties;
import org.modelbus.services.repository.server.git.GitUtil;
import org.modelbus.services.repository.server.git.ModelBusGitDirEntry;
import org.modelbus.services.repository.server.impl.ModelBusExtendedRepositoryLogEntryImpl;
import org.modelbus.services.repository.server.impl.ModelBusRepositoryLogEntryImpl;

public class GitModelBusRepository
extends AbstractModelBusRepository {
    private static final String GIT_IGNORE_FILE_NAME = ".gitignore";
    private final Git git;
    private final Map<URI, FileProperties> filePropertiesCache;

    public GitModelBusRepository(Repository gitRepository) {
        this.git = new Git(gitRepository);
        this.filePropertiesCache = new HashMap<URI, FileProperties>();
    }

    public IModelBusDirEntry getDir(IModelBusSession session, URI uri, String revision, boolean includeCommitMessages, Collection<IModelBusDirEntry> entries) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException {
        TreeWalk treeWalk;
        RevCommit commit;
        List dirEntries;
        try {
            dirEntries = this.info(session, uri, revision);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (dirEntries == null || dirEntries.isEmpty()) {
            return null;
        }
        IModelBusDirEntry dirEntry = null;
        for (IModelBusDirEntry entry : dirEntries) {
            if (!ModelBusNodeKind.DIR.equals((Object)entry.getKind())) continue;
            dirEntry = entry;
            break;
        }
        if (dirEntry == null) {
            return null;
        }
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(dirEntry.getUrl());
        try {
            commit = GitUtil.getCommitForFile(this.getRepository(), repoPath, revision);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (commit == null) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)"Invalid revision provided");
        }
        ObjectId dirHash = null;
        if (!"/".equals(repoPath)) {
            try {
                treeWalk = GitUtil.createTreeWalk(this.getRepository(), repoPath, commit);
            }
            catch (Exception e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            dirHash = treeWalk.getObjectId(0);
        } else {
            dirHash = commit.getId();
        }
        treeWalk = new TreeWalk(this.getRepository());
        RevWalk revWalk = new RevWalk(this.getRepository());
        try {
            treeWalk.addTree((AnyObjectId)revWalk.parseTree((AnyObjectId)dirHash));
            while (treeWalk.next()) {
                String pathString = treeWalk.getPathString();
                if (GIT_IGNORE_FILE_NAME.equals(pathString) || pathString.endsWith(".mbproperties")) continue;
                String subEntryPath = !"/".equals(repoPath) ? String.valueOf(repoPath) + "/" + pathString : pathString;
                URI subEntryURI = URI.createURI((String)subEntryPath);
                if (pathString.endsWith("_file") || pathString.endsWith("_dir")) continue;
                ModelBusGitDirEntry subEntry = new ModelBusGitDirEntry(subEntryPath, this.getRepository(), commit);
                entries.add((IModelBusDirEntry)subEntry);
                String symLinkURI = this.getFileProperty(session, subEntryURI, "MB_SymLink", revision);
                if (symLinkURI == null) continue;
                String symEntryPath = GitModelBusRepository.toRelativeFileSystemPath(symLinkURI);
                RevCommit symEntryCommit = GitUtil.getCommitForFile(this.getRepository(), symEntryPath, revision);
                if (symEntryCommit == null) continue;
                ModelBusGitDirEntry symLinkSubEntry = new ModelBusGitDirEntry(symEntryPath, this.getRepository(), symEntryCommit);
                symLinkSubEntry.setName(subEntry.getName());
                symLinkSubEntry.setUrl(subEntry.getUrl());
                entries.add((IModelBusDirEntry)symLinkSubEntry);
            }
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        Iterator<IModelBusDirEntry> iterator = entries.iterator();
        while (iterator.hasNext()) {
            IModelBusDirEntry modelBusDirEntry = iterator.next();
            try {
                if (this.accessManager.hasAccessRights(session, URI.createURI((String)modelBusDirEntry.getUrl()), 1)) continue;
                iterator.remove();
            }
            catch (Exception e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
        }
        return dirEntry;
    }

    protected boolean _internalExists(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(uri);
        try {
            ObjectLoader loader = GitUtil.getObjectLoader(this.getRepository(), repoPath, revision);
            return loader != null;
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
    }

    private String toFullFileSystemPath(URI repoURI) {
        String relativeFileSystemPath = GitModelBusRepository.toRelativeFileSystemPath(repoURI);
        return this.toFullFileSystemPath(relativeFileSystemPath);
    }

    private String toFullFileSystemPath(String relPath) {
        String path = this.getRepositoryPath();
        if (!relPath.startsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return String.valueOf(path) + relPath;
    }

    private URI toFullFileSystemURI(URI repoURI) {
        return URI.createURI((String)this.toFullFileSystemPath(repoURI));
    }

    private URI toFullFileSystemURI(String relPath) {
        return URI.createURI((String)this.toFullFileSystemPath(relPath));
    }

    private String getRepositoryPath() {
        return this.getRepository().getWorkTree().getPath();
    }

    private URI toRepositoryURI(URI uri) {
        return this.toRepositoryURI(uri.toFileString());
    }

    private URI toRepositoryURI(String path) {
        String repoPath = this.getRepositoryPath();
        if (!path.startsWith(repoPath)) {
            return URI.createURI((String)path);
        }
        return GitModelBusRepository.getRemoteURI((URI)URI.createURI((String)path.substring(repoPath.length() + 1)));
    }

    private Repository getRepository() {
        return this.git.getRepository();
    }

    public ModelBusNodeKind checkPathFileSystem(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        ObjectLoader loader;
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(uri);
        try {
            loader = GitUtil.getObjectLoader(this.getRepository(), repoPath, revision);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (loader == null) {
            return null;
        }
        ModelBusNodeKind nodeKind = ModelBusGitDirEntry.convertGitNodeKindToModelBusNodeKind(loader.getType());
        return nodeKind;
    }

    private void _doDelete(String repoPath) throws NoFilepatternException, GitAPIException {
        this.git.rm().addFilepattern(repoPath).call();
    }

    public void delete(IModelBusSession session, URI uri, String logMessage, String revision) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(uri);
        try {
            this._doDelete(repoPath);
            this._addAndCommit(session, repoPath, logMessage);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
    }

    public void copy(IModelBusSession session, URI[] srcPaths, URI destPath, boolean isMove, boolean failWhenDstExists, String message) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, InvalidRevisionException {
        String result;
        try {
            this.accessManager.checkAccessRights(session, srcPaths, 1);
            this.accessManager.checkAccessRights(session, destPath, 2);
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (!this.exists(session, destPath, "-1") && !"OK".equals(result = this.createDir(session, destPath, message, AbstractModelBusRepository.getDefaultOptionsMap()))) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Error creating target directory: " + destPath.toString()));
        }
        String relDestRepoPath = GitModelBusRepository.toRelativeFileSystemPath(destPath);
        String fullDestDirPath = this.toFullFileSystemPath(relDestRepoPath);
        URI[] uRIArray = srcPaths;
        int n = srcPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String revision;
            URI currentURI;
            URI srcPathURI = uRIArray[n2];
            IModelBusDirEntry entry = null;
            if (srcPathURI.hasQuery()) {
                currentURI = srcPathURI.trimQuery();
                Map queryMap = GitModelBusRepository.getQueryMap((String)srcPathURI.query());
                revision = (String)queryMap.get("revision");
            } else {
                currentURI = srcPathURI;
                entry = this.infoFileSystem(session, currentURI, "-1");
                revision = entry.getRevision();
            }
            if (entry == null) {
                entry = this.infoFileSystem(session, currentURI, revision);
            }
            String fileName = currentURI.lastSegment();
            File destFile = this.getFile(session, URI.createFileURI((String)(String.valueOf(fullDestDirPath) + "/" + fileName)), revision);
            if (failWhenDstExists && destFile.exists()) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("File " + currentURI.toString() + " already exists"));
            }
            String relSourceRepoPath = GitModelBusRepository.toRelativeFileSystemPath(currentURI);
            if (ModelBusNodeKind.DIR.equals((Object)entry.getKind())) {
                this._createDirRecursively(session, URI.createFileURI((String)fullDestDirPath));
                ArrayList<IModelBusDirEntry> entries = new ArrayList<IModelBusDirEntry>();
                this.getDir(session, currentURI, revision, false, entries);
                for (IModelBusDirEntry subEntry : entries) {
                    try {
                        this._internalCopyFile(session, URI.createURI((String)subEntry.getUrl()), String.valueOf(fullDestDirPath) + "/" + subEntry.getName(), revision);
                    }
                    catch (Exception e) {
                        throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                    }
                }
                try {
                    this._add(relDestRepoPath);
                }
                catch (Exception e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                }
            }
            try {
                this._internalCopyFile(session, currentURI, destFile.getPath(), revision);
            }
            catch (Exception e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            String targetRelRepoPath = GitModelBusRepository.toRelativeFileSystemPath(URI.createURI((String)relDestRepoPath).appendSegment(fileName));
            try {
                this._add(targetRelRepoPath);
            }
            catch (Exception e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            if (isMove) {
                try {
                    this._doDelete(relSourceRepoPath);
                    this._add(relSourceRepoPath);
                }
                catch (Exception e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                }
            }
            ++n2;
        }
        try {
            this._doCommit(session, relDestRepoPath, message);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
    }

    protected void _internalCopyFile(IModelBusSession session, URI fileURI, String targetFilePath, String revision) throws MissingObjectException, IOException, NoFilepatternException, GitAPIException {
        ObjectLoader loader;
        String relSourceRepoPath = GitModelBusRepository.toRelativeFileSystemPath(fileURI);
        try {
            loader = GitUtil.getObjectLoader(this.getRepository(), relSourceRepoPath, revision);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (loader == null) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("File " + fileURI.toString() + " not found in repository"));
        }
        File outFile = this.getFile(session, URI.createFileURI((String)targetFilePath), revision);
        if (!outFile.exists() && !outFile.createNewFile()) {
            throw new RepositoryRuntimeException("Unable to create file: " + GitModelBusRepository.toRelativeFileSystemPath(URI.createURI((String)targetFilePath)));
        }
        FileOutputStream outStream = new FileOutputStream(outFile);
        loader.copyTo((OutputStream)outStream);
        outStream.close();
    }

    public String commit(IModelBusSession session, List<PathFileContentMapEntry> createFileMap, List<PathFileContentMapEntry> checkInFileMap, List<String> folderPaths, List<String> deletionPaths, String logMessage) throws RepositoryAuthentificationException, InvalidValueException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        try {
            File tempFile;
            DataSource dataSource;
            DataHandler dataHandler;
            String path;
            if (folderPaths != null) {
                for (String folderPath : folderPaths) {
                    this.createDir(session, URI.createURI((String)folderPath), logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
                }
            }
            if (createFileMap != null) {
                for (PathFileContentMapEntry mapEntry : createFileMap) {
                    path = mapEntry.getPath();
                    dataHandler = mapEntry.getFileContent();
                    dataSource = dataHandler.getDataSource();
                    tempFile = GitModelBusRepository._writeToTemporaryFile((InputStream)dataSource.getInputStream());
                    this.createFile(session, URI.createURI((String)path), new FileInputStream(tempFile), logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
                    if (tempFile == null || !tempFile.exists()) continue;
                    tempFile.delete();
                }
            }
            if (checkInFileMap != null) {
                for (PathFileContentMapEntry mapEntry : checkInFileMap) {
                    path = mapEntry.getPath();
                    dataHandler = mapEntry.getFileContent();
                    dataSource = dataHandler.getDataSource();
                    tempFile = GitModelBusRepository._writeToTemporaryFile((InputStream)dataSource.getInputStream());
                    this.checkInFile(session, URI.createURI((String)path), new FileInputStream(tempFile), logMessage, AbstractModelBusRepository.getDefaultOptionsMap());
                    if (tempFile == null || !tempFile.exists()) continue;
                    tempFile.delete();
                }
            }
            if (deletionPaths != null) {
                for (String deletionPath : deletionPaths) {
                    this.delete(session, URI.createURI((String)deletionPath), logMessage, "-1");
                }
            }
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        return "OK";
    }

    public String checkInFile(IModelBusSession session, URI fileUri, InputStream fileContent, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, RepositoryRuntimeException, LockedException {
        return this._checkInFile(2, session, fileUri, fileContent, logMessage, options);
    }

    private String _checkInFile(int mode, IModelBusSession session, URI fileUri, InputStream fileContent, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, RepositoryRuntimeException, LockedException {
        try {
            this.accessManager.checkAccessRights(session, fileUri, 2);
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (NonExistingResourceException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        return this.internalSaveFile(session, fileUri, fileContent, logMessage, mode, options);
    }

    private void _add(String filePath) throws NoFilepatternException, GitAPIException {
        this.git.add().addFilepattern(filePath).call();
    }

    private RevCommit _doCommit(IModelBusSession session, String filePath, String logMessage) throws NoFilepatternException, GitAPIException {
        String email = session.getValueForKey("email");
        if (email == null) {
            email = "foo@foo.com";
        }
        String username = session.getValueForKey("username");
        RevCommit commit = this.git.commit().setMessage(logMessage).setCommitter(username, email).call();
        return commit;
    }

    private RevCommit _addAndCommit(IModelBusSession session, String filePath, String logMessage) throws NoFilepatternException, GitAPIException {
        this._add(filePath);
        return this._doCommit(session, filePath, logMessage);
    }

    protected String internalSaveFile(IModelBusSession session, URI uri, InputStream inStream, String logMessage, int mode, OptionsMap options) {
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(uri);
        String fullFilePath = this.toFullFileSystemPath(repoPath);
        URI fileURI = URI.createFileURI((String)fullFilePath);
        File outFile = this.getFile(session, fileURI, "-1");
        if (outFile.exists()) {
            if (!outFile.isFile()) {
                URI newURI = URI.createURI((String)(String.valueOf(uri.toString()) + "_file"));
                try {
                    this.setFileProperty(session, URI.createURI((String)fullFilePath), "MB_SymLink", newURI.toString());
                }
                catch (Exception e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                }
                repoPath = GitModelBusRepository.toRelativeFileSystemPath(newURI);
                fullFilePath = this.toFullFileSystemPath(repoPath);
                fileURI = URI.createFileURI((String)fullFilePath);
                outFile = this.getFile(session, fileURI, "-1");
            }
        } else {
            boolean created;
            this._createDirRecursively(session, fileURI.trimSegments(1));
            outFile = this.getFile(session, fileURI, "-1");
            try {
                created = outFile.createNewFile();
            }
            catch (IOException e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            if (!created) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Unable to create file: " + fileURI.toFileString()));
            }
        }
        try {
            int len;
            String contentTypeOption = GitModelBusRepository.getOptionAsString((OptionsMap)options, (String)"Content-Type");
            if (contentTypeOption != null) {
                try {
                    this.setFileProperty(session, fileURI, "MB_MimeType", contentTypeOption);
                }
                catch (NoFilepatternException e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
                catch (GitAPIException e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
            }
            FileOutputStream outStream = new FileOutputStream(outFile, false);
            byte[] buf = new byte[1024];
            while ((len = inStream.read(buf)) > 0) {
                ((OutputStream)outStream).write(buf, 0, len);
            }
            ((OutputStream)outStream).close();
            inStream.close();
        }
        catch (IOException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        fileURI = URI.createFileURI((String)outFile.getPath());
        RevCommit commit = null;
        try {
            String resultingRepositoryPath = GitModelBusRepository.toRelativeFileSystemPath(this.toRepositoryURI(fileURI.toFileString()));
            commit = this._addAndCommit(session, resultingRepositoryPath, logMessage);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        URI notificationURI = uri;
        URI origURI = (URI)GitModelBusRepository.getOption((OptionsMap)options, (String)"origURI");
        if (origURI != null) {
            notificationURI = origURI;
        }
        if (mode == 1) {
            this.notifyCreateModel(notificationURI, session);
        } else {
            this.notifyUpdateModel(notificationURI, session);
        }
        return commit.getId().getName();
    }

    public String createFile(IModelBusSession session, URI fileUri, InputStream initalFileContent, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, RepositoryRuntimeException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        try {
            return this._checkInFile(1, session, fileUri, initalFileContent, logMessage, options);
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    public String createDir(IModelBusSession session, URI directoryUri, String logMessage, OptionsMap options) throws RepositoryAuthentificationException {
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(directoryUri);
        String fullDirPath = this.toFullFileSystemPath(repoPath);
        this._createDirRecursively(session, URI.createFileURI((String)fullDirPath));
        String ignoreFilePath = String.valueOf(repoPath) + "/" + GIT_IGNORE_FILE_NAME;
        File ignoreFile = this.getFile(session, URI.createFileURI((String)this.toFullFileSystemPath(ignoreFilePath)), "-1");
        try {
            ignoreFile.createNewFile();
        }
        catch (IOException iOException) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Unable to create directory: " + repoPath));
        }
        try {
            this._addAndCommit(session, repoPath, logMessage);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        return "OK";
    }

    protected URI getSymLinkForFileURI(IModelBusSession session, URI uri, String revision) {
        String fsFullPath = this.toFullFileSystemPath(uri);
        URI fileURI = URI.createFileURI((String)fsFullPath);
        File file = this.getFile(session, fileURI, revision);
        if (file == null || !file.exists()) {
            return null;
        }
        URI repositoryURI = this.toRepositoryURI(file.getPath());
        String uriString = uri.toString();
        if (uriString.length() > 1 && uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (repositoryURI.toString().equals(uriString)) {
            return null;
        }
        return repositoryURI;
    }

    private File getFile(IModelBusSession session, URI uri, String revision) {
        File file = new File(uri.toFileString());
        if (file.exists()) {
            return file;
        }
        List segmentsList = uri.segmentsList();
        URI checkURI = uri.trimSegments(uri.segmentCount());
        int i = 0;
        while (i < segmentsList.size()) {
            String symLink;
            String segment = (String)segmentsList.get(i);
            File checkFile = new File((checkURI = checkURI.appendSegment(segment)).toFileString());
            if (!(checkFile.exists() && i < segmentsList.size() - 1 && checkFile.isDirectory() || (symLink = this.getFileProperty(session, checkURI, "MB_SymLink", revision)) == null)) {
                checkURI = checkURI.trimSegments(1).appendSegment(symLink);
            }
            ++i;
        }
        return new File(checkURI.toFileString());
    }

    protected String getFileProperty(IModelBusSession session, URI fileURI, String propertyName, String revision) {
        if (fileURI.isRelative()) {
            fileURI = this.toFullFileSystemURI(fileURI);
        }
        if (!fileURI.isFile()) {
            fileURI = URI.createFileURI((String)fileURI.toString());
        }
        String fileName = fileURI.lastSegment();
        FileProperties fileProperties = this.getFileProperties(session, fileURI.trimSegments(1), revision);
        return fileProperties.getFileProperty(fileName, propertyName);
    }

    protected void setFileProperty(IModelBusSession session, URI fileURI, String propertyName, String propertyValue) throws IOException, NoFilepatternException, GitAPIException {
        boolean created;
        if (fileURI.isRelative()) {
            fileURI = this.toFullFileSystemURI(fileURI);
        }
        if (!fileURI.isFile()) {
            fileURI = URI.createFileURI((String)fileURI.toString());
        }
        fileURI = URI.createURI((String)fileURI.toFileString().replace("\\", "/"));
        String fileName = fileURI.lastSegment();
        URI dirURI = fileURI.trimSegments(1);
        FileProperties fileProperties = this.getFileProperties(session, dirURI, "-1");
        fileProperties.setFileProperty(fileName, propertyName, propertyValue);
        URI propFileURI = dirURI.appendSegment(".mbproperties");
        String propFilePath = GitUtil.toFileSystemPath(propFileURI);
        File propertyFile = new File(propFilePath);
        if (!propertyFile.exists() && !(created = propertyFile.createNewFile())) {
            throw new RuntimeException("Unable to create properties file: " + propertyFile.getPath());
        }
        fileProperties.save(new FileOutputStream(propertyFile, false));
        URI repoURI = this.toRepositoryURI(propertyFile.getPath());
        this._addAndCommit(session, GitModelBusRepository.toRelativeFileSystemPath(repoURI), "file properties update");
    }

    private FileProperties getFileProperties(IModelBusSession session, URI dirURI, String revision) {
        URI uri = URI.createURI((String)GitUtil.toFileSystemPath(dirURI));
        if (!this.filePropertiesCache.containsKey(uri)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.internalLoadFile(session, this.toRepositoryURI(dirURI.appendSegment(".mbproperties")).toString(), revision, new HashMap<String, Object>(), outStream, false);
            String propertiesString = new String(outStream.toByteArray());
            this.filePropertiesCache.put(uri, new FileProperties(propertiesString.split("\\r?\\n")));
        }
        return this.filePropertiesCache.get(uri);
    }

    private void _createDirRecursively(IModelBusSession session, URI dirUri) {
        URI parentURI = dirUri.trimSegments(1);
        File parentDir = this.getFile(session, parentURI, "-1");
        if (!parentDir.exists()) {
            this._createDirRecursively(session, parentURI);
        } else if (!parentDir.isDirectory()) {
            if (!this.areSymbolicLinksEnabled()) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Unable to create directory: " + parentDir.getPath() + ". File already exists at given location."));
            }
            URI dirRepoURI = this.toRepositoryURI(parentDir.getPath());
            URI symDirURI = this.getLinkDirURI(session, dirRepoURI);
            String repoPath = GitModelBusRepository.toRelativeFileSystemPath(symDirURI);
            String fullFilePath = this.toFullFileSystemPath(repoPath);
            URI symDirFullPathURI = URI.createFileURI((String)fullFilePath);
            File symDir = this.getFile(session, symDirFullPathURI, "-1");
            boolean created = symDir.mkdir();
            if (created) {
                try {
                    this.setFileProperty(session, parentURI, "MB_SymLink", symDirURI.lastSegment());
                }
                catch (Exception e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                }
            }
        }
        File dir = this.getFile(session, dirUri, "-1");
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Unable to create directory: " + dir.getPath() + ". File already exists at given location."));
            }
        } else {
            boolean created = dir.mkdir();
            if (!created) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((String)("Unable to create directory: " + dir.getPath()));
            }
        }
    }

    public IModelBusDirEntry infoFileSystem(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException {
        RevCommit commit;
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        URI workingURI = this.getCorrectWorkingURI(session, uri, revision);
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(workingURI);
        try {
            commit = GitUtil.getCommitForFile(this.getRepository(), repoPath, revision);
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (commit == null) {
            return null;
        }
        try {
            if (this.exists(session, workingURI, revision)) {
                return new ModelBusGitDirEntry(repoPath, this.getRepository(), commit);
            }
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        return null;
    }

    private boolean isRootURI(URI uri) {
        String uriString = uri.toString();
        return "http://".equals(uriString) || "http:/".equals(uriString);
    }

    private URI getCorrectWorkingURI(IModelBusSession session, URI uri, String revision) {
        if (this.isRootURI(uri)) {
            return uri;
        }
        URI symlink = this.getSymLinkForFileURI(session, uri, revision);
        URI workingURI = symlink != null ? symlink : uri;
        return workingURI;
    }

    public IModelBusRepositoryLogEntry[] getLogEntries(IModelBusSession session, URI[] targetPaths, String startRevision, String endRevision, boolean changedPath, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revisionProperties) throws RepositoryAuthentificationException, RepositoryRuntimeException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        try {
            this.accessManager.checkAccessRights(session, targetPaths, 1);
        }
        catch (NonExistingResourceException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (LockedException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        ArrayList<ModelBusRepositoryLogEntryImpl> modelBusRepositoryLogEntries = new ArrayList<ModelBusRepositoryLogEntryImpl>();
        ObjectId startCommitReference = GitUtil.getCommitReference(this.getRepository(), startRevision);
        if (startCommitReference == null) {
            throw new InvalidValueException("\"" + startRevision + "\" is not a valid commit.");
        }
        ObjectId endCommitReference = null;
        if (endRevision != null && (endCommitReference = GitUtil.getCommitReference(this.getRepository(), endRevision)) == null) {
            throw new InvalidValueException("\"" + endRevision + "\" is not a valid commit.");
        }
        URI[] uRIArray = targetPaths;
        int n = targetPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable commits;
            URI targetPath = uRIArray[n2];
            String repoPath = GitModelBusRepository.toRelativeFileSystemPath(targetPath);
            try {
                LogCommand logCommand = this.git.log();
                if (!"/".equals(repoPath)) {
                    logCommand.addPath(repoPath);
                }
                if (limit > 0L) {
                    logCommand.setMaxCount(Long.valueOf(limit).intValue());
                }
                if (endCommitReference != null) {
                    logCommand.addRange((AnyObjectId)endCommitReference, (AnyObjectId)startCommitReference);
                } else {
                    logCommand.add((AnyObjectId)startCommitReference);
                }
                commits = logCommand.call();
            }
            catch (Exception e) {
                throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            for (RevCommit commit : commits) {
                HashMap changedPathsConverted = new HashMap();
                ModelBusRepositoryLogEntryImpl modelBusEntry = new ModelBusRepositoryLogEntryImpl(changedPathsConverted, GitUtil.getCommitRevision(commit), GitUtil.getCommitAuthor(commit), GitUtil.getCommitDate(commit), GitUtil.getCommitMessage(commit), false);
                modelBusRepositoryLogEntries.add(modelBusEntry);
            }
            ++n2;
        }
        return modelBusRepositoryLogEntries.toArray(new IModelBusRepositoryLogEntry[0]);
    }

    protected long internalLoadFile(IModelBusSession session, String filePath, String revision, Map<String, Object> properties, OutputStream content, boolean useSymLinks) {
        File symFile;
        String repoPath = GitModelBusRepository.toRelativeFileSystemPath(URI.createURI((String)filePath));
        try {
            ObjectLoader loader = GitUtil.getObjectLoader(this.getRepository(), repoPath, revision);
            if (loader != null) {
                loader.copyTo(content);
                return -1L;
            }
        }
        catch (Exception e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (this.areSymbolicLinksEnabled() && useSymLinks && (symFile = this.getFile(session, URI.createFileURI((String)this.toFullFileSystemPath(repoPath)), revision)).exists()) {
            return this.internalLoadFile(session, this.toRepositoryURI(symFile.getPath()).toString(), revision, properties, content, useSymLinks);
        }
        return -1L;
    }

    protected IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByDate(IModelBusSession session, long revisionDate) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException {
        RevWalk revWalk = new RevWalk(this.getRepository());
        try {
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)this.getRepository().resolve("HEAD")));
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        RevCommit commitFound = null;
        for (RevCommit commit : revWalk) {
            Date commitDate = GitUtil.getCommitDate(commit);
            if (commitDate.getTime() != revisionDate) continue;
            if (commitFound != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(revisionDate);
            }
            commitFound = commit;
        }
        if (commitFound == null) {
            return null;
        }
        return this._getExtendedLogEntryByRevision(session, GitUtil.getCommitRevision(commitFound));
    }

    protected IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByRevision(IModelBusSession session, String revision) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException {
        IModelBusRepositoryLogEntry[] logEntries;
        try {
            logEntries = this.getLogEntries(session, new URI[]{URI.createURI((String)"http:/")}, revision, null, true, true, 2L, true, null);
        }
        catch (UnresolvedReferencesException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (logEntries == null || logEntries.length == 0) {
            return null;
        }
        String previousRevision = null;
        Date previousRevisionDate = null;
        if (logEntries.length > 1) {
            IModelBusRepositoryLogEntry previousLogEntry = logEntries[1];
            previousRevision = previousLogEntry.getRevision();
            ObjectId previousCommitID = GitUtil.getCommitReference(this.getRepository(), previousRevision);
            if (previousCommitID != null) {
                RevCommit previousCommit;
                try {
                    previousCommit = GitUtil.getCommitForFile(this.getRepository(), "/", previousRevision);
                }
                catch (Exception e) {
                    throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                }
                if (previousCommit != null) {
                    previousRevisionDate = GitUtil.getCommitDate(previousCommit);
                }
            }
        }
        IModelBusRepositoryLogEntry logEntry = logEntries[0];
        ModelBusExtendedRepositoryLogEntryImpl extLogEntry = new ModelBusExtendedRepositoryLogEntryImpl(logEntry.getChangedPaths(), logEntry.getRevision(), logEntry.getAuthor(), logEntry.getDate(), previousRevision, previousRevisionDate, logEntry.getMessage(), logEntry.hasChildren());
        return extLogEntry;
    }

    protected void control_SetModelFragmentProperties(IModelBusSession session, URI parentModelURI, URI childModelURI, URI fragmentURI, String logMessage) {
        String childFileName = "/" + childModelURI.authority() + childModelURI.path();
        String modelFileName = "/" + parentModelURI.authority() + parentModelURI.path();
        childFileName = URI.decode((String)URI.decode((String)childFileName));
        try {
            this.setFileProperty(session, URI.createFileURI((String)this.toFullFileSystemPath(childFileName)), "MB_ParentModel", fragmentURI.toString());
            modelFileName = URI.decode((String)URI.decode((String)modelFileName));
            this.setFileProperty(session, URI.createFileURI((String)this.toFullFileSystemPath(modelFileName)), "MB_ChildModel", childModelURI.toString());
        }
        catch (NoFilepatternException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        catch (GitAPIException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    protected void uncontrol_SetModelParentProperty(IModelBusSession session, URI parentModelURI, URI childModelURI, String logMessage) {
        String childModelFileName = "/" + childModelURI.authority() + childModelURI.path();
        childModelFileName = URI.decode((String)URI.decode((String)childModelFileName));
        try {
            this.setFileProperty(session, URI.createFileURI((String)this.toFullFileSystemPath(childModelFileName)), "MB_ParentModel", parentModelURI.toString());
        }
        catch (NoFilepatternException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        catch (GitAPIException e) {
            throw GitModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    private static String toRelativeFileSystemPath(String repoURI) {
        String normalizedPath = ModelBusRepositoryPathMappingHelper.normalizePathfromURIString((String)repoURI);
        if (normalizedPath.startsWith("pathmap://")) {
            normalizedPath = normalizedPath.substring("pathmap://".length());
        }
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (normalizedPath.endsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return normalizedPath;
    }

    private static String toRelativeFileSystemPath(URI repoURI) {
        return GitModelBusRepository.toRelativeFileSystemPath(repoURI.toString());
    }

    private static URI toRepositoryRelativeURI(URI uri) {
        String relPath = GitModelBusRepository.toRelativeFileSystemPath(uri);
        return URI.createURI((String)relPath);
    }
}

