/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.dosgi.api;

import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.services.api.AbstractModelBusConsumerActivator;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractModelBusConsumerActivator<RepositoryService> {
    private static Activator INSTANCE = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
    }

    protected void serviceRegistered(RepositoryService service) {
    }

    public Class<RepositoryService> getServiceInterface() {
        return RepositoryService.class;
    }

    protected void configure(ModelBusServiceConfiguration config) {
        String repoLocation;
        config.setServiceName("ModelBus Core lib");
        try {
            repoLocation = this.getRepositoryLocation();
        }
        catch (ModelBusException e) {
            throw new RuntimeException(e);
        }
        config.setOption("serviceAddress", (Object)repoLocation);
    }

    public String getRepositoryLocation() throws ModelBusException {
        String repoLocation;
        boolean isSecure = ModelBusCoreLib.getRepositoryHelper().forcesSecureConnection();
        if (isSecure) {
            repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getSecureRepositoryLocation();
            AbstractLocationsUtil.setupSSLConnection();
        } else {
            repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation(true);
        }
        if (repoLocation == null) {
            if (isSecure) {
                throw new RuntimeException("Option repository secure location has to be set for ModelBus repository service.");
            }
            throw new RuntimeException("Option repository location has to be set for ModelBus repository service.");
        }
        return repoLocation;
    }

    public static Activator getInstance() {
        return INSTANCE;
    }
}

