/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.modelbus.tools.diffmerge.DiffMergeEventHandler;
import org.modelbus.tools.diffmerge.DiffMergeListener;
import org.modelbus.tools.diffmerge.IDiffMerge;
import org.modelbus.tools.diffmerge.compare.Comparer;
import org.modelbus.tools.diffmerge.config.CompareConfig;
import org.modelbus.tools.diffmerge.config.DiffMergeConfigImpl;
import org.modelbus.tools.diffmerge.config.MergeConfig;
import org.modelbus.tools.diffmerge.config.MergeConfigImpl;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilter;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilterImpl;
import org.modelbus.tools.diffmerge.merge.MergerImpl;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge2.joint.event.DiffModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.LeftModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.RightModelChangedEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class DiffMergeImpl
implements IDiffMerge {
    private static final Logger LOG = LoggerFactory.getLogger(DiffMergeImpl.class);
    private final Comparer comparer;
    private final ModelBusEventBus eventBus;
    private final MergerImpl merger;
    private CompareConfig comnpareConfig;
    private final MergeConfig mergeConfig;
    private final DiffMergeEventHandler eventHandler;
    private final DiffMergeFilterImpl filter;

    protected DiffMergeImpl(ModelBusEventBus eventBus, Comparer comparer) {
        this.eventBus = eventBus;
        this.comparer = comparer;
        this.filter = new DiffMergeFilterImpl(eventBus);
        this.eventHandler = new DiffMergeEventHandler(this);
        this.mergeConfig = new MergeConfigImpl(eventBus);
        this.merger = new MergerImpl(eventBus);
        this.init();
    }

    private void init() {
        DiffMergeConfigImpl config = new DiffMergeConfigImpl();
        config.setEventBus(this.eventBus);
        this.setDiffMergeConfig(config);
    }

    @Override
    public DiffModel compare(Notifier left, Notifier origin, Notifier right) {
        return this.compare(left, (Optional<Notifier>)Optional.of((Object)origin), right);
    }

    private DiffModel compare(Notifier left, Optional<Notifier> origin, Notifier right) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        DiffModel model = this.compareResources(left, origin, right);
        this.merger.setDiffModel(model);
        this.postEvents(left, right, model);
        return model;
    }

    private DiffModel compareResources(Notifier left, Optional<Notifier> origin, Notifier right) {
        DiffModel model = origin.isPresent() ? this.comparer.comparerThreeWay(left, (Notifier)origin.get(), right) : this.comparer.compareTwoWay(left, right);
        return model;
    }

    private void postEvents(Notifier left, Notifier right, DiffModel model) {
        this.eventBus.post((Object)new LeftModelChangedEvent(left));
        this.eventBus.post((Object)new RightModelChangedEvent(right));
        this.eventBus.post((Object)new DiffModelChangedEvent(model));
    }

    @Override
    public DiffModel compare(Notifier left, Notifier right) {
        return this.compare(left, (Optional<Notifier>)Optional.fromNullable(null), right);
    }

    @Override
    public void mergeElementToLeft(DiffModelElement element, boolean ignoreConflicts) {
        Optional<DiffModel> model = this.merger.mergeFromRightToLeft(element, ignoreConflicts);
        if (model.isPresent()) {
            this.eventBus.post((Object)new DiffModelChangedEvent((DiffModel)model.get()));
        }
    }

    @Override
    public void mergeElementToRight(DiffModelElement element, boolean ignoreConflicts) {
        Optional<DiffModel> model;
        if (this.merger != null) {
            model = this.merger.mergeFromLeftToRight(element, ignoreConflicts);
        } else {
            LOG.error("Merger is nulll !!!");
            model = Optional.absent();
        }
        if (model.isPresent()) {
            this.eventBus.post((Object)new DiffModelChangedEvent((DiffModel)model.get()));
        }
    }

    @Override
    public CompareConfig getCompareConfig() {
        return this.comnpareConfig;
    }

    @Override
    public void setDiffMergeConfig(CompareConfig config) {
        this.comnpareConfig = config;
    }

    public Collection<Object> getAllEventHandlers() {
        ArrayList listeners = Lists.newArrayList((Object[])new Object[]{this.eventHandler});
        listeners.addAll(this.merger.getAllEventHandlers());
        return listeners;
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supportet");
    }

    @Override
    public DiffMergeFilter getDiffMergeFilter() {
        return this.filter;
    }

    @Override
    public void addDiffMergeListener(DiffMergeListener listener) {
        this.eventHandler.addListener(listener);
    }

    @Override
    public void removeListener(DiffMergeListener listener) {
        this.eventHandler.removeListener(listener);
    }

    @Override
    public MergeConfig getMergeConfig() {
        return this.mergeConfig;
    }
}

