/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.repository;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;

public class DeleteRepositoryItemActionDelegate
implements IObjectActionDelegate {
    private Set<RepositoryDirEntry> dirEntries = new HashSet<RepositoryDirEntry>();
    private Shell shell;

    public void run(IAction action) {
        String message = null;
        message = this.dirEntries.size() == 1 ? "Do you really want to delete the selected repository item?" : "Do you really want to delete the selected repository items?";
        boolean delete = MessageDialog.openConfirm((Shell)this.shell, (String)"Delete Repository Items", (String)message);
        if (delete) {
            for (RepositoryDirEntry entry : this.dirEntries) {
                try {
                    ModelBusCoreLib.getRepositoryHelper().delete(UserSessionHelper.getInstance().getSession(), URI.createURI((String)entry.getUri()), "TODO LOG MESSAGE");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.dirEntries.clear();
        if (UserSessionHelper.getInstance().getSession() == null) {
            action.setEnabled(false);
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Iterator selIt = ((IStructuredSelection)selection).iterator();
            while (selIt.hasNext()) {
                this.dirEntries.add((RepositoryDirEntry)selIt.next());
            }
        }
        action.setEnabled(!this.dirEntries.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

