/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.user;

import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.modelbus.model.user.Rule;

public class UserRightDialog
extends TitleAreaDialog {
    private final Rule rule;
    private static final String DEFAULT_MESSAGE = "Edit the access rule's properties";
    private Text ruleInput;
    private Text maskInput;
    private String newRule;
    private Integer newMask;

    public UserRightDialog(Shell parentShell, Rule rule) {
        super(parentShell);
        this.rule = rule;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText("Access Rule");
        this.setTitle("Access Rule");
        this.setMessage(DEFAULT_MESSAGE, 1);
        return contents;
    }

    protected Point getInitialSize() {
        return new Point(450, 200);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridData fillBothLayoutData = new GridData();
        fillBothLayoutData.grabExcessHorizontalSpace = true;
        fillBothLayoutData.grabExcessVerticalSpace = true;
        fillBothLayoutData.horizontalAlignment = 4;
        fillBothLayoutData.verticalAlignment = 4;
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)fillBothLayoutData);
        Label lblRulePattern = new Label(composite, 0);
        lblRulePattern.setText("Rule/Mask:");
        ControlDecoration controlDecoration = new ControlDecoration((Control)lblRulePattern, 131200);
        controlDecoration.setDescriptionText("Regular expression for rule; int value for mask");
        this.ruleInput = new Text(composite, 2048);
        this.ruleInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.rule.getRule() != null) {
            this.ruleInput.setText(this.rule.getRule());
        }
        this.ruleInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                UserRightDialog.this.validate();
            }
        });
        Label lblSeperator = new Label(composite, 0);
        lblSeperator.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSeperator.setBounds(0, 0, 55, 15);
        lblSeperator.setText("/");
        this.maskInput = new Text(composite, 2048);
        GridData maskInputLayoutData = new GridData(131072, 0x1000000, false, false, 1, 1);
        maskInputLayoutData.widthHint = 25;
        this.maskInput.setLayoutData((Object)maskInputLayoutData);
        this.maskInput.setText(String.valueOf(this.rule.getMask()));
        this.maskInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                UserRightDialog.this.validate();
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.get().OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.get().CANCEL_LABEL, false);
    }

    public Rule getRule() {
        return this.rule;
    }

    protected void validate() {
        this.newRule = this.ruleInput.getText();
        String newMaskString = this.maskInput.getText();
        boolean valid = false;
        if (!"".equals(this.newRule)) {
            if (!"".equals(newMaskString)) {
                try {
                    "something".matches(this.newRule);
                    this.newMask = Integer.valueOf(newMaskString);
                    valid = true;
                    this.setMessage(DEFAULT_MESSAGE, 1);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.setMessage("Invalid rule value", 3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessage("Invalid mask value", 3);
                }
            } else {
                this.setMessage("Mask value should not be empty", 3);
            }
        } else {
            this.setMessage("Rule value should not be empty", 3);
        }
        this.getButton(0).setEnabled(valid);
    }

    protected void okPressed() {
        this.rule.setMask(this.newMask.intValue());
        this.rule.setRule(this.newRule);
        super.okPressed();
    }
}

