/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingProcessor
implements Processor {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Schema schema;
    private Source schemaSource;
    private SchemaFactory schemaFactory;
    private URL schemaUrl;
    private File schemaFile;
    private ValidatorErrorHandler errorHandler = new DefaultValidationErrorHandler();
    private boolean useDom;
    private boolean useSharedSchema = true;
    private LSResourceResolver resourceResolver;

    @Override
    public void process(Exchange exchange) throws Exception {
        Result result;
        Source source;
        Schema schema = this.isUseSharedSchema() ? this.getSchema() : this.createSchema();
        Validator validator = schema.newValidator();
        if (this.useDom) {
            source = exchange.getIn().getBody(DOMSource.class);
            result = new DOMResult();
        } else {
            source = exchange.getIn().getBody(SAXSource.class);
            result = new SAXResult();
        }
        if (source == null) {
            throw new NoXmlBodyValidationException(exchange);
        }
        ValidatorErrorHandler handler = (ValidatorErrorHandler)this.errorHandler.getClass().newInstance();
        validator.setErrorHandler(handler);
        try {
            validator.validate(source, result);
        }
        catch (SAXParseException e) {
            throw new SchemaValidationException(exchange, schema, Collections.singletonList(e), Collections.<SAXParseException>emptyList(), Collections.<SAXParseException>emptyList());
        }
        handler.handleErrors(exchange, schema, result);
    }

    public void loadSchema() throws Exception {
        this.schema = this.createSchema();
    }

    public synchronized Schema getSchema() throws IOException, SAXException {
        if (this.schema == null) {
            this.schema = this.createSchema();
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public synchronized Source getSchemaSource() throws IOException {
        if (this.schemaSource == null) {
            this.schemaSource = this.createSchemaSource();
        }
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public synchronized SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = this.createSchemaFactory();
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public ValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isUseDom() {
        return this.useDom;
    }

    public void setUseDom(boolean useDom) {
        this.useDom = useDom;
    }

    public boolean isUseSharedSchema() {
        return this.useSharedSchema;
    }

    public void setUseSharedSchema(boolean useSharedSchema) {
        this.useSharedSchema = useSharedSchema;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    protected SchemaFactory createSchemaFactory() {
        SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
        if (this.getResourceResolver() != null) {
            factory.setResourceResolver(this.getResourceResolver());
        }
        return factory;
    }

    protected Source createSchemaSource() throws IOException {
        throw new IllegalArgumentException("You must specify either a schema, schemaFile, schemaSource or schemaUrl property");
    }

    protected Schema createSchema() throws SAXException, IOException {
        SchemaFactory factory = this.getSchemaFactory();
        URL url = this.getSchemaUrl();
        if (url != null) {
            return factory.newSchema(url);
        }
        File file = this.getSchemaFile();
        if (file != null) {
            return factory.newSchema(file);
        }
        return factory.newSchema(this.getSchemaSource());
    }
}

