/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.discovery;

import java.util.HashSet;
import java.util.List;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.provider.discovery.CompositeDiscoveryContainer;

public class CompositeDiscoveryContainerInstantiator
implements IContainerInstantiator {
    private static final String ADVERTISER = ".advertiser";
    private static final String LOCATOR = ".locator";

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        try {
            IContainerFactory factory = ContainerFactory.getDefault();
            HashSet<IContainer> containers = new HashSet<IContainer>();
            List list = factory.getDescriptions();
            for (ContainerTypeDescription ctd : list) {
                IContainer container;
                String name = ctd.getName();
                if (name.startsWith("ecf.discovery.composite") || !name.startsWith("ecf.discovery.")) continue;
                String ccName = description.getName();
                if ("ecf.discovery.composite".equals(ccName)) {
                    container = factory.createContainer(ctd.getName());
                    containers.add(container);
                    continue;
                }
                if (ccName.endsWith(LOCATOR) && name.endsWith(LOCATOR)) {
                    container = factory.createContainer(ctd.getName());
                    containers.add(container);
                    continue;
                }
                if (!ccName.endsWith(ADVERTISER) || !name.endsWith(ADVERTISER)) continue;
                container = factory.createContainer(ctd.getName());
                containers.add(container);
            }
            return new CompositeDiscoveryContainer(containers);
        }
        catch (IDCreateException e) {
            ContainerCreateException excep = new ContainerCreateException(e.getMessage());
            excep.setStackTrace(e.getStackTrace());
            throw excep;
        }
        catch (ContainerCreateException e) {
            ContainerCreateException excep = new ContainerCreateException(e.getMessage());
            excep.setStackTrace(e.getStackTrace());
            throw excep;
        }
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return new String[]{IDiscoveryAdvertiser.class.getName(), IDiscoveryLocator.class.getName()};
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return new Class[0][0];
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return null;
    }
}

