/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class ApplicationContextRegistry
implements Registry {
    private ApplicationContext applicationContext;

    public ApplicationContextRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        Object answer;
        try {
            answer = this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
        catch (BeanNotOfRequiredTypeException e) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in ApplicationContext: " + this.applicationContext + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public Object lookup(String name) {
        try {
            return this.applicationContext.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.applicationContext.getBeansOfType(type);
    }
}

