/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.dosgi.repository.descriptor.MapEntry;
import org.modelbus.dosgi.repository.descriptor.ServiceProperties;
import status.Service;
import status.StatusFactory;
import status.StatusModel;

public class ServicesManager {
    private final StatusModel statusModel = StatusFactory.eINSTANCE.createStatusModel();

    public ServicesManager() {
        new ResourceSetImpl();
        ResourceImpl r = new ResourceImpl();
        URI statusURI = URI.createURI((String)"http://www.modelbus.org/system/model/current.status");
        r.setURI(statusURI);
        r.getContents().add((Object)this.statusModel);
        long currentTime = new Date().getTime();
        this.statusModel.setStartup(currentTime);
        try {
            String repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation();
            if (repoLocation != null) {
                this.statusModel.setLocation(repoLocation);
            }
        }
        catch (Exception exception) {}
        try {
            String secureRepoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getSecureRepositoryLocation();
            if (secureRepoLocation != null) {
                this.statusModel.setSecureLocation(secureRepoLocation);
            }
        }
        catch (Exception exception) {}
    }

    public boolean addService(ServiceProperties properties) {
        if (this.getService(properties.getServiceInterface()) != null) {
            return true;
        }
        Service service = StatusFactory.eINSTANCE.createService();
        Object addressOption = null;
        for (MapEntry entry : properties.getEntries()) {
            if (!"effectiveServiceAddress".equals(entry.getKey())) continue;
            addressOption = entry.getValue();
            break;
        }
        service.setLocation((String)addressOption);
        service.setInterface(properties.getServiceInterface());
        service.setName(properties.getServiceName());
        long currentTime = new Date().getTime();
        service.setStartup(currentTime);
        this.statusModel.getServices().add((Object)service);
        return true;
    }

    public boolean removeService(ServiceProperties properties) {
        Service service = this.getService(properties.getServiceInterface());
        if (service == null) {
            return false;
        }
        this.getStatusModel().getServices().remove((Object)service);
        return true;
    }

    private Service getService(String serviceInterface) {
        EList services = this.getStatusModel().getServices();
        for (Service service : services) {
            if (!serviceInterface.equals(service.getInterface())) continue;
            return service;
        }
        return null;
    }

    public StatusModel getStatusModel() {
        return this.statusModel;
    }
}

