/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.repository.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.DependenciesInfo;
import org.modelbus.dosgi.repository.descriptor.ExtendedRepositoryLogEntry;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidServiceDescriptionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockInfo;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.MapEntry;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.OptionMapEntry;
import org.modelbus.dosgi.repository.descriptor.OptionsMap;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogPath;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeChangeType;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.repository.descriptor.ServiceProperties;
import org.modelbus.dosgi.repository.descriptor.ServiceStatus;
import org.modelbus.dosgi.repository.descriptor.Session;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.dosgi.repository.service.IModelBusSessionFactory;
import org.modelbus.repository.external.api.AbstractExternalRepository;
import org.modelbus.repository.external.api.ExternalRepositoryConfigurationException;
import org.modelbus.repository.external.api.ExternalRepositoryException;
import org.modelbus.repository.external.api.ExternalRepositoryFactory;
import org.modelbus.repositorychangemodelnotification.RepositoryChangeModelNotification;
import org.modelbus.repositorynotification.RepositoryNotification;
import org.modelbus.services.repository.changemodelnotification.provider.cxf.api.NotificationServiceProvider;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.IModelBusExtendedRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusRepositoryListener;
import org.modelbus.services.repository.server.IModelBusRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepositoryLogPath;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.ModelBusRepositoryNodeChangeType;
import status.Service;
import status.StatusModel;

@WebService(endpointInterface="org.modelbus.dosgi.repository.descriptor.RepositoryService")
public class RepositoryServiceImpl
implements RepositoryService,
IModelBusRepositoryListener {
    private static final String DATASOURCE_TYPE_OCTETSTREAM = "application/octet-stream";
    private static final String ATTRIBUTE_MODELBUS_SESSION_ID = "ModelBusSessionID";
    private static final String SVN_MIMETYPE = "svn:mime-type";
    IModelBusRepository modelBusRepository = null;
    IModelBusSessionFactory modelBusSessionFactory = null;
    @javax.annotation.Resource
    private WebServiceContext wsContext;

    public RepositoryServiceImpl(IModelBusRepository modelBusRepository, IModelBusSessionFactory modelBusSessionFactory) {
        this.modelBusRepository = modelBusRepository;
        this.modelBusSessionFactory = modelBusSessionFactory;
        modelBusRepository.addModelBusRepositoryListener((IModelBusRepositoryListener)this);
    }

    protected HttpSession getHTTPSession() {
        MessageContext msgContext = this.wsContext.getMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.get((Object)"javax.xml.ws.servlet.request");
        HttpSession session = null;
        if (request != null) {
            session = request.getSession();
        }
        return session;
    }

    protected String getSessionID() {
        HttpSession httpSession = this.getHTTPSession();
        return (String)httpSession.getAttribute(ATTRIBUTE_MODELBUS_SESSION_ID);
    }

    public String authenticate(String username, String password) throws InvalidValueException, RepositoryRuntimeException {
        String sessionID = null;
        try {
            boolean successful = this.modelBusRepository.authenticate(username, password);
            if (successful) {
                sessionID = RepositoryServiceImpl.generateSessionID();
                HttpSession httpSession = this.getHTTPSession();
                if (httpSession != null) {
                    httpSession.setAttribute(ATTRIBUTE_MODELBUS_SESSION_ID, (Object)sessionID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sessionID;
    }

    private static String generateSessionID() {
        return EcoreUtil.generateUUID();
    }

    public void checkInFile(Holder<Session> session, String fileUri, DataHandler fileContent, String logMessage, OptionsMap options, Holder<String> checksum) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException, LockedException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            String contentType = fileContent.getContentType();
            if (contentType != null) {
                RepositoryServiceImpl.setOption(options, "MB_MimeType", contentType, true);
            }
            checksum.value = this.modelBusRepository.checkInFile(currentCallSession, URI.createURI((String)fileUri), fileContent.getDataSource().getInputStream(), logMessage, RepositoryServiceImpl.sanitizeOptions(options));
            if (checksum.value == null) {
                checksum.value = "";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static OptionsMap sanitizeOptions(OptionsMap options) {
        if (options == null) {
            return new OptionsMap();
        }
        return options;
    }

    protected static void setOption(OptionsMap options, String optionName, Object optionValue, boolean overwrite) {
        for (OptionMapEntry mapEntry : options.getMapEntry()) {
            if (!optionName.equals(mapEntry.getOptionName())) continue;
            if (overwrite) {
                mapEntry.setOptionValue(optionValue);
            }
            return;
        }
        OptionMapEntry newOption = new OptionMapEntry();
        newOption.setOptionName(optionName);
        newOption.setOptionValue(optionValue);
        options.getMapEntry().add(newOption);
    }

    public void checkInModel(Holder<Session> session, String modelUriString, DataHandler model, boolean enableDependencies, String logMessage, OptionsMap options, Holder<String> checksum) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, UnresolvedReferencesException {
        URI modelURI = URI.createURI((String)modelUriString);
        boolean externalExists = false;
        try {
            externalExists = this.externalExists(modelURI, "-1");
        }
        catch (ExternalRepositoryException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (externalExists) {
            AbstractExternalRepository repo = this.getExternalRepository(modelURI);
            if (repo != null) {
                try {
                    checksum.value = repo.saveModel(null);
                }
                catch (ExternalRepositoryException e) {
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            try {
                IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
                checksum.value = this.modelBusRepository.checkInModelLowLevel(currentCallSession, modelURI, model.getDataSource(), enableDependencies, logMessage, RepositoryServiceImpl.sanitizeOptions(options));
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        if (checksum.value == null) {
            checksum.value = "";
        }
    }

    public void checkOutFile(Holder<Session> session, String fileUriString, String revision, Holder<DataHandler> fileContent) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        block27: {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            URI fileURI = URI.createURI((String)fileUriString);
            boolean externalExists = false;
            try {
                externalExists = this.externalExists(fileURI, revision);
            }
            catch (ExternalRepositoryException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
            if (externalExists) {
                AbstractExternalRepository externalRepository = this.getExternalRepository(fileURI);
                if (externalRepository != null) {
                    File externalResourceFile = null;
                    try {
                        try {
                            externalResourceFile = externalRepository.getFile(fileURI);
                            if (externalResourceFile != null) {
                                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                                byte[] data = new byte[16384];
                                FileInputStream inStream = null;
                                try {
                                    try {
                                        int nRead;
                                        inStream = new FileInputStream(externalResourceFile);
                                        while ((nRead = ((InputStream)inStream).read(data, 0, data.length)) != -1) {
                                            buffer.write(data, 0, nRead);
                                        }
                                        buffer.flush();
                                    }
                                    catch (IOException e) {
                                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                                    }
                                }
                                finally {
                                    if (inStream != null) {
                                        try {
                                            ((InputStream)inStream).close();
                                        }
                                        catch (IOException e) {
                                            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(buffer.toByteArray(), DATASOURCE_TYPE_OCTETSTREAM);
                                fileContent.value = new DataHandler((DataSource)byteArrayDataSource);
                                break block27;
                            }
                            throw new NonExistingResourceException("The file " + fileUriString + " does not exist.");
                        }
                        catch (ExternalRepositoryException e) {
                            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                        }
                    }
                    finally {
                        if (externalResourceFile != null && externalResourceFile.exists()) {
                            externalResourceFile.delete();
                        }
                    }
                }
                throw new NonExistingResourceException("The file " + fileUriString + " does not exist.");
            }
            if (this.modelBusRepository.exists(currentCallSession, fileURI, revision)) {
                try {
                    HashMap properties = new HashMap();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.modelBusRepository.checkOutFile(currentCallSession, fileURI, revision, properties, (OutputStream)byteArrayOutputStream);
                    ByteArrayDataSource dataSource = null;
                    dataSource = properties.containsKey(SVN_MIMETYPE) ? new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), properties.get(SVN_MIMETYPE).toString()) : new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), DATASOURCE_TYPE_OCTETSTREAM);
                    fileContent.value = new DataHandler((DataSource)dataSource);
                }
                catch (Exception e) {
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new NonExistingResourceException("The file " + fileUriString + " does not exist.");
            }
        }
    }

    public void checkOutModel(Holder<Session> session, String modelUri, Holder<DataHandler> model) throws RepositoryAuthentificationException, RepositoryRuntimeException, UnresolvedReferencesException, NonExistingResourceException {
        this.checkOutModelWithRevision(session, modelUri, model, "-1");
    }

    public void checkOutModelWithRevision(Holder<Session> session, String modelUriString, Holder<DataHandler> model, String revision) throws RepositoryAuthentificationException, RepositoryRuntimeException, UnresolvedReferencesException, NonExistingResourceException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
        URI modelURI = URI.createURI((String)modelUriString);
        boolean externalExists = false;
        try {
            externalExists = this.externalExists(modelURI, revision);
        }
        catch (ExternalRepositoryException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (externalExists) {
            AbstractExternalRepository externalRepository = this.getExternalRepository(modelURI);
            if (externalRepository != null) {
                Resource externalResource;
                try {
                    externalResource = externalRepository.getModel(modelURI);
                }
                catch (ExternalRepositoryException e) {
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
                if (externalResource != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        externalResource.save((OutputStream)byteArrayOutputStream, Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                    }
                    ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), DATASOURCE_TYPE_OCTETSTREAM);
                    model.value = new DataHandler((DataSource)byteArrayDataSource);
                }
            }
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.modelBusRepository.checkOutModelLowLevel(currentCallSession, modelURI, revision, new HashMap(), (OutputStream)byteArrayOutputStream);
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), DATASOURCE_TYPE_OCTETSTREAM);
                model.value = new DataHandler((DataSource)byteArrayDataSource);
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void checkPath(Holder<Session> session, String path, String revision, Holder<List<RepositoryNodeKind>> nodeKinds) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
        ArrayList<RepositoryNodeKind> nodeKindsReturn = new ArrayList<RepositoryNodeKind>();
        List nodeKindsRepo = this.modelBusRepository.checkPath(currentCallSession, URI.createURI((String)path), revision);
        for (ModelBusNodeKind nodeKind : nodeKindsRepo) {
            nodeKindsReturn.add(RepositoryServiceImpl.convertModelBusNodeKindToRepositoryNodeKind(nodeKind));
        }
        nodeKinds.value = nodeKindsReturn;
    }

    public boolean control(Session session, String fragmentUri, String fragmentFileLocation, String logMessage) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        try {
            this.modelBusRepository.control(currentCallSession, URI.createURI((String)fragmentUri), URI.createURI((String)fragmentFileLocation), logMessage);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public Boolean copy(Session session, List<String> srcPaths, String destPath, Boolean isMove, Boolean failWhenDstExists, String message) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        URI[] srcURIs = new URI[srcPaths.size()];
        int i = 0;
        for (String srcPath : srcPaths) {
            srcURIs[i] = URI.createURI((String)srcPath);
            ++i;
        }
        try {
            this.modelBusRepository.copy(currentCallSession, srcURIs, URI.createURI((String)destPath), isMove.booleanValue(), failWhenDstExists.booleanValue(), message);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidRevisionException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void createDir(Holder<Session> session, String dirUri, String logMessage, OptionsMap options, Holder<String> checksum) throws RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            checksum.value = this.modelBusRepository.createDir(currentCallSession, URI.createURI((String)dirUri), logMessage, RepositoryServiceImpl.sanitizeOptions(options));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createFile(Holder<Session> session, String fileUri, DataHandler initialFileContent, String logMessage, OptionsMap options, Holder<String> checksum) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            String contentType = initialFileContent.getContentType();
            if (contentType != null) {
                RepositoryServiceImpl.setOption(options, "MB_MimeType", contentType, true);
            }
            checksum.value = this.modelBusRepository.createFile(currentCallSession, URI.createURI((String)fileUri), initialFileContent.getDataSource().getInputStream(), logMessage, RepositoryServiceImpl.sanitizeOptions(options));
            if (checksum.value == null) {
                checksum.value = "";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createModel(Holder<Session> session, String modelUri, String metamodelUri, String logMessage, OptionsMap options, Holder<DataHandler> model) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, RepositoryRuntimeException, UnresolvedReferencesException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            Resource resource = this.modelBusRepository.createModel(currentCallSession, null, URI.createURI((String)modelUri), URI.createURI((String)metamodelUri), logMessage, RepositoryServiceImpl.sanitizeOptions(options));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            resource.save((OutputStream)byteArrayOutputStream, Collections.EMPTY_MAP);
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), DATASOURCE_TYPE_OCTETSTREAM);
            model.value = new DataHandler((DataSource)byteArrayDataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createModelwithContent(Holder<Session> session, DataHandler initialModelContent, String modelUri, boolean enableDependencies, String logMessage, OptionsMap options, Holder<String> checksum) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, RepositoryRuntimeException, UnresolvedReferencesException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            checksum.value = this.modelBusRepository.createModelwithContent(currentCallSession, URI.createURI((String)modelUri), initialModelContent.getDataSource(), enableDependencies, logMessage, RepositoryServiceImpl.sanitizeOptions(options));
            if (checksum.value == null) {
                checksum.value = "";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(Holder<Session> session, String url, String logMessage, String revision, Holder<String> result) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            this.modelBusRepository.delete(currentCallSession, URI.createURI((String)url), logMessage, revision);
            result.value = "OK";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractExternalRepository getExternalRepository(URI uri) {
        AbstractExternalRepository repo;
        try {
            repo = ExternalRepositoryFactory.getInstance().getRepository(uri);
        }
        catch (ExternalRepositoryConfigurationException e) {
            throw new RuntimeException(e);
        }
        return repo;
    }

    protected boolean externalExists(URI uri, String revision) throws ExternalRepositoryException {
        AbstractExternalRepository repo = this.getExternalRepository(uri);
        if (repo == null) {
            return false;
        }
        return repo.exists(uri);
    }

    public void exists(Holder<Session> session, String path, String revision, Holder<Boolean> exists) throws RepositoryAuthentificationException, NonExistingResourceException, RepositoryRuntimeException {
        exists.value = false;
        URI uri = URI.createURI((String)path);
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
        boolean internalExists = this.modelBusRepository.exists(currentCallSession, uri, revision);
        if (internalExists) {
            exists.value = true;
        } else {
            try {
                if (this.externalExists(uri, revision)) {
                    exists.value = true;
                }
            }
            catch (ExternalRepositoryException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void getDir(Holder<Session> session, String uri, String revision, boolean includeCommitMessages, Holder<List<RepositoryDirEntry>> entries, Holder<RepositoryDirEntry> entry) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            entries.value = new ArrayList();
            ArrayList<IModelBusDirEntry> entriesList = new ArrayList<IModelBusDirEntry>();
            IModelBusDirEntry modelBusDirEntry = this.modelBusRepository.getDir(currentCallSession, URI.createURI((String)uri), revision, includeCommitMessages, entriesList);
            if (modelBusDirEntry != null) {
                entries.value = RepositoryServiceImpl.convertModelBusDirEntryCollectionToRepositoryDirEntryArray(entriesList);
                entry.value = RepositoryServiceImpl.convertModelBusDirEntryToRepositoryDirEntry(modelBusDirEntry);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<LockInfo> getLocks(Session session, String urlPrefix) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
            org.modelbus.services.repository.server.LockInfo[] lockInfos = this.modelBusRepository.getLocks(currentCallSession, urlPrefix);
            ArrayList<LockInfo> serviceLockInfos = new ArrayList<LockInfo>();
            org.modelbus.services.repository.server.LockInfo[] lockInfoArray = lockInfos;
            int n = lockInfos.length;
            int n2 = 0;
            while (n2 < n) {
                org.modelbus.services.repository.server.LockInfo lockInfo = lockInfoArray[n2];
                LockInfo serviceLockInfo = new LockInfo();
                XMLGregorianCalendar calendar = RepositoryServiceImpl.getXMLGregorianCalendar(lockInfo.time);
                serviceLockInfo.setTime(calendar);
                serviceLockInfo.setUserName(lockInfo.user);
                serviceLockInfo.setUrl(lockInfo.url);
                serviceLockInfos.add(serviceLockInfo);
                ++n2;
            }
            return serviceLockInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<RepositoryLogEntry> getLogEntries(Session session, List<String> targetPaths, String startRevision, String endRevision, boolean changedPath, boolean strictNode, Long limit, Boolean includeMergedRevisions, List<String> revisionProperties) throws RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            String element;
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
            if (targetPaths == null) {
                targetPaths = new ArrayList<String>();
            }
            URI[] targets = new URI[targetPaths.size()];
            if (revisionProperties == null) {
                revisionProperties = new ArrayList<String>();
            }
            String[] properties = new String[revisionProperties.size()];
            int counter = 0;
            Iterator<String> iterator = targetPaths.iterator();
            while (iterator.hasNext()) {
                String targetPath = element = iterator.next();
                targets[counter] = URI.createURI((String)targetPath);
                ++counter;
            }
            counter = 0;
            iterator = revisionProperties.iterator();
            while (iterator.hasNext()) {
                String property;
                properties[counter] = property = (element = iterator.next());
                ++counter;
            }
            IModelBusRepositoryLogEntry[] modelBusLogEntries = this.modelBusRepository.getLogEntries(currentCallSession, targets, startRevision, endRevision, changedPath, strictNode, limit.longValue(), includeMergedRevisions.booleanValue(), properties);
            ArrayList<RepositoryLogEntry> logEntries = new ArrayList<RepositoryLogEntry>();
            IModelBusRepositoryLogEntry[] iModelBusRepositoryLogEntryArray = modelBusLogEntries;
            int n = modelBusLogEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IModelBusRepositoryLogEntry modelBusLogEntry = iModelBusRepositoryLogEntryArray[n2];
                RepositoryLogEntry repositoryLogEntry = new RepositoryLogEntry();
                XMLGregorianCalendar calendar = RepositoryServiceImpl.getXMLGregorianCalendar(modelBusLogEntry.getDate().getTime());
                repositoryLogEntry.setAuthor(modelBusLogEntry.getAuthor());
                repositoryLogEntry.setChangedPaths(RepositoryServiceImpl.getListofRepositoryLogPaths(modelBusLogEntry));
                repositoryLogEntry.setDate(calendar);
                repositoryLogEntry.setHasChildren(Boolean.valueOf(modelBusLogEntry.hasChildren()));
                repositoryLogEntry.setMessage(modelBusLogEntry.getMessage());
                repositoryLogEntry.setRevision(modelBusLogEntry.getRevision());
                logEntries.add(repositoryLogEntry);
                ++n2;
            }
            return logEntries;
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void info(Holder<Session> session, String path, String revision, Holder<List<RepositoryDirEntry>> infos) throws RepositoryAuthentificationException, InvalidRevisionException, RepositoryRuntimeException, NonExistingResourceException {
        URI fileURI = URI.createURI((String)path);
        boolean externalExists = false;
        try {
            externalExists = this.externalExists(fileURI, revision);
        }
        catch (ExternalRepositoryException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        ArrayList<RepositoryDirEntry> entriesReturn = new ArrayList<RepositoryDirEntry>();
        if (externalExists) {
            AbstractExternalRepository externalRepository = this.getExternalRepository(fileURI);
            if (externalRepository != null) {
                try {
                    entriesReturn.add(externalRepository.getInfo(fileURI));
                }
                catch (ExternalRepositoryException e) {
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            try {
                IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
                List modelBusDirEntries = this.modelBusRepository.info(currentCallSession, fileURI, revision);
                if (modelBusDirEntries != null) {
                    for (IModelBusDirEntry modelBusDirEntry : modelBusDirEntries) {
                        entriesReturn.add(RepositoryServiceImpl.convertModelBusDirEntryToRepositoryDirEntry(modelBusDirEntry));
                    }
                }
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        infos.value = entriesReturn;
    }

    public boolean lock(Session session, String url, XMLGregorianCalendar timeout) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        boolean successful = false;
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
            this.modelBusRepository.lock(currentCallSession, URI.createURI((String)url));
            successful = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            successful = false;
        }
        return successful;
    }

    public boolean uncontrol(Session session, String fragmentFileLocation, String logMessage) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        boolean successful = false;
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
            this.modelBusRepository.uncontrol(currentCallSession, URI.createURI((String)fragmentFileLocation), logMessage);
            successful = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            successful = false;
        }
        return successful;
    }

    public boolean unlock(Session session, String url) throws RepositoryAuthentificationException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        boolean successful = false;
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
            this.modelBusRepository.unlock(currentCallSession, URI.createURI((String)url));
            successful = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            successful = false;
        }
        return successful;
    }

    public void createModel(URI modelUri, IModelBusSession session) {
        RepositoryNotification notificationService = NotificationServiceProvider.getRepositoryNotificationService();
        if (notificationService != null) {
            notificationService.createModel(modelUri.toString(), session.getValueForKey("username"), session.getId());
        }
    }

    public void deleteModel(URI modelUri, IModelBusSession session) {
        RepositoryNotification notificationService = NotificationServiceProvider.getRepositoryNotificationService();
        if (notificationService != null) {
            notificationService.deleteModel(modelUri.toString(), session.getValueForKey("username"), session.getId());
        }
    }

    public void updateModel(URI modelUri, IModelBusSession session) {
        RepositoryNotification notificationService = NotificationServiceProvider.getRepositoryNotificationService();
        if (notificationService != null) {
            notificationService.updateModel(modelUri.toString(), session.getValueForKey("username"), session.getId());
        }
    }

    private static RepositoryNodeKind convertModelBusNodeKindToRepositoryNodeKind(ModelBusNodeKind modelBusNodeKind) {
        if (ModelBusNodeKind.DIR.equals((Object)modelBusNodeKind)) {
            return RepositoryNodeKind.DIR;
        }
        if (ModelBusNodeKind.FILE.equals((Object)modelBusNodeKind)) {
            return RepositoryNodeKind.FILE;
        }
        if (ModelBusNodeKind.MODEL.equals((Object)modelBusNodeKind)) {
            return RepositoryNodeKind.MODEL;
        }
        return RepositoryNodeKind.UNKNOWN;
    }

    private static RepositoryDirEntry convertModelBusDirEntryToRepositoryDirEntry(IModelBusDirEntry modelBusDirEntry) throws DataValue.URI.MalformedURIException {
        RepositoryDirEntry repositoryDirEntry = new RepositoryDirEntry();
        repositoryDirEntry.setCommitMessage(modelBusDirEntry.getCommitMessage());
        repositoryDirEntry.setCreationDate(RepositoryServiceImpl.getXMLGregorianCalendar(modelBusDirEntry.getCreationDate().getTime()));
        repositoryDirEntry.setKind(RepositoryServiceImpl.convertModelBusNodeKindToRepositoryNodeKind(modelBusDirEntry.getKind()));
        repositoryDirEntry.setLastAuthor(modelBusDirEntry.getLastAuthor());
        repositoryDirEntry.setName(modelBusDirEntry.getName());
        Map entryProperties = modelBusDirEntry.getProperties();
        for (String propertyName : entryProperties.keySet()) {
            MapEntry property = new MapEntry();
            property.setKey(propertyName);
            property.setValue(entryProperties.get(propertyName));
            repositoryDirEntry.getProperties().add(property);
        }
        repositoryDirEntry.setRevision(modelBusDirEntry.getRevision());
        repositoryDirEntry.setSize(Long.valueOf(modelBusDirEntry.getSize()));
        repositoryDirEntry.setUri(URI.decode((String)URI.decode((String)modelBusDirEntry.getUrl())));
        return repositoryDirEntry;
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(long time) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(time);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            datatypeConfigurationException.printStackTrace();
            return null;
        }
    }

    private static List<RepositoryDirEntry> convertModelBusDirEntryCollectionToRepositoryDirEntryArray(Collection<IModelBusDirEntry> modelBusDirEntries) throws DataValue.URI.MalformedURIException {
        ArrayList<RepositoryDirEntry> repositoryDirEntries = new ArrayList<RepositoryDirEntry>();
        for (IModelBusDirEntry currentModelBusDirEntry : modelBusDirEntries) {
            RepositoryDirEntry dirEntry = RepositoryServiceImpl.convertModelBusDirEntryToRepositoryDirEntry(currentModelBusDirEntry);
            repositoryDirEntries.add(dirEntry);
        }
        return repositoryDirEntries;
    }

    private static List<RepositoryLogPath> getListofRepositoryLogPaths(IModelBusRepositoryLogEntry modelBusLogEntry) {
        Map changedPaths = modelBusLogEntry.getChangedPaths();
        Collection logPaths = changedPaths.values();
        ArrayList<RepositoryLogPath> repositoryLogPaths = new ArrayList<RepositoryLogPath>();
        for (IModelBusRepositoryLogPath modelBusRepositoryLogPath : logPaths) {
            RepositoryLogPath repositoryLogPath = new RepositoryLogPath();
            repositoryLogPath.setAction(RepositoryServiceImpl.convertModelBusRepositoryNodeChangeTypeToRepositoryNodeChangeType(modelBusRepositoryLogPath.getAction()));
            repositoryLogPath.setCopiedFromPath(modelBusRepositoryLogPath.getCopiedFromPath());
            repositoryLogPath.setCopiedFromRevision(modelBusRepositoryLogPath.getCopiedFromRevision());
            repositoryLogPath.setPath(modelBusRepositoryLogPath.getPath());
            repositoryLogPaths.add(repositoryLogPath);
        }
        return repositoryLogPaths;
    }

    private static RepositoryNodeChangeType convertModelBusRepositoryNodeChangeTypeToRepositoryNodeChangeType(ModelBusRepositoryNodeChangeType modelBusNodeChangeType) {
        if (ModelBusRepositoryNodeChangeType.ADDED.equals((Object)modelBusNodeChangeType)) {
            return RepositoryNodeChangeType.ADDED;
        }
        if (ModelBusRepositoryNodeChangeType.DELETED.equals((Object)modelBusNodeChangeType)) {
            return RepositoryNodeChangeType.DELETED;
        }
        if (ModelBusRepositoryNodeChangeType.MODIFIED.equals((Object)modelBusNodeChangeType)) {
            return RepositoryNodeChangeType.MODIFIED;
        }
        if (ModelBusRepositoryNodeChangeType.REPLACED.equals((Object)modelBusNodeChangeType)) {
            return RepositoryNodeChangeType.REPLACED;
        }
        return RepositoryNodeChangeType.NONE;
    }

    public DependenciesInfo getDependencies(Session session, String uriString, boolean includeIncomingReferences, boolean includeOutgoingReferences) throws RepositoryAuthentificationException, RepositoryRuntimeException, NonExistingResourceException {
        AbstractExternalRepository[] externalRepositories;
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        URI uri = URI.createURI((String)uriString);
        DependenciesInfo dependencies = this.modelBusRepository.getDependencies(currentCallSession, uri, includeIncomingReferences, includeOutgoingReferences);
        try {
            externalRepositories = ExternalRepositoryFactory.getInstance().getAllRepositories();
        }
        catch (ExternalRepositoryConfigurationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        AbstractExternalRepository[] abstractExternalRepositoryArray = externalRepositories;
        int n = externalRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            DependenciesInfo externalDependencies;
            AbstractExternalRepository externalRepository = abstractExternalRepositoryArray[n2];
            try {
                externalDependencies = externalRepository.getDependencies(uri);
            }
            catch (ExternalRepositoryException e) {
                e.printStackTrace();
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
            if (externalDependencies != null) {
                dependencies.getIncomingReferencesInfos().addAll(externalDependencies.getIncomingReferencesInfos());
                dependencies.getOutgoingReferencesInfos().addAll(externalDependencies.getOutgoingReferencesInfos());
            }
            ++n2;
        }
        return dependencies;
    }

    public void commitChangeModel(Holder<Session> session, String messageID, String modelLocation, DataHandler changeModelContent, Holder<Boolean> successful) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException {
        try {
            IModelBusSession modelBusSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            successful.value = this.modelBusRepository.commitChangeModel(modelBusSession, messageID, URI.createURI((String)modelLocation), changeModelContent.getDataSource());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commitChangeModelNotification(String messageID, URI modelUri, DataHandler changeModelContent) {
        RepositoryChangeModelNotification changeModelNotificationService = NotificationServiceProvider.getChangeModelNotificationService();
        if (changeModelNotificationService != null) {
            changeModelNotificationService.commitChangeModel(messageID, modelUri.toString(), changeModelContent);
        }
    }

    public void getStatus(Session session, boolean includeServices, Holder<List<ServiceStatus>> serviceStatus, Holder<XMLGregorianCalendar> startupDate, Holder<String> location, Holder<String> secureLocation) throws RepositoryAuthentificationException, RepositoryRuntimeException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        StatusModel statusModel = this.modelBusRepository.getStatusModel(currentCallSession);
        location.value = statusModel.getLocation();
        secureLocation.value = statusModel.getSecureLocation();
        startupDate.value = RepositoryServiceImpl.getXMLGregorianCalendar(statusModel.getStartup());
        serviceStatus.value = new ArrayList();
        if (includeServices) {
            EList services = statusModel.getServices();
            for (Service service : services) {
                ServiceStatus status = new ServiceStatus();
                status.setName(service.getName());
                status.setInterface(service.getInterface());
                status.setLocation(service.getLocation());
                status.setStartupDate(RepositoryServiceImpl.getXMLGregorianCalendar(service.getStartup()));
                ((List)serviceStatus.value).add(status);
            }
        }
    }

    public boolean publishService(Session session, ServiceProperties properties) throws RepositoryAuthentificationException, InvalidServiceDescriptionException, RepositoryRuntimeException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        return this.modelBusRepository.publishService(currentCallSession, properties);
    }

    public boolean unpublishService(Session session, ServiceProperties properties) throws RepositoryAuthentificationException, RepositoryRuntimeException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        return this.modelBusRepository.unpublishService(currentCallSession, properties);
    }

    public void commit(Holder<Session> session, List<PathFileContentMapEntry> createFileMap, List<PathFileContentMapEntry> checkInFileMap, List<String> folderPaths, List<String> deletionPaths, String logMessage, Holder<String> checksum) throws InvalidValueException, RepositoryAuthentificationException, RepositoryRuntimeException, LockedException {
        try {
            IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession((Session)session.value);
            checksum.value = this.modelBusRepository.commit(currentCallSession, createFileMap, checkInFileMap, folderPaths, deletionPaths, logMessage);
        }
        catch (NonExistingResourceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ExtendedRepositoryLogEntry getExtendedLogEntry(Session session, String revision, XMLGregorianCalendar date) throws RepositoryAuthentificationException, RepositoryRuntimeException, InvalidValueException, ConstraintViolationException {
        IModelBusSession currentCallSession = this.modelBusSessionFactory.getModelBusSessionForSession(session);
        long timestamp = -1L;
        if (date != null) {
            timestamp = date.toGregorianCalendar().getTimeInMillis();
        }
        IModelBusExtendedRepositoryLogEntry modelBusLogEntry = this.modelBusRepository.getExtendedLogEntry(currentCallSession, revision, timestamp);
        ExtendedRepositoryLogEntry repositoryLogEntry = new ExtendedRepositoryLogEntry();
        XMLGregorianCalendar calendar = RepositoryServiceImpl.getXMLGregorianCalendar(modelBusLogEntry.getDate().getTime());
        repositoryLogEntry.setAuthor(modelBusLogEntry.getAuthor());
        repositoryLogEntry.setChangedPaths(RepositoryServiceImpl.getListofRepositoryLogPaths((IModelBusRepositoryLogEntry)modelBusLogEntry));
        repositoryLogEntry.setDate(calendar);
        repositoryLogEntry.setHasChildren(Boolean.valueOf(modelBusLogEntry.hasChildren()));
        repositoryLogEntry.setMessage(modelBusLogEntry.getMessage());
        repositoryLogEntry.setRevision(modelBusLogEntry.getRevision());
        XMLGregorianCalendar previousDateCalendar = RepositoryServiceImpl.getXMLGregorianCalendar(modelBusLogEntry.getPreviousRevisionDate().getTime());
        repositoryLogEntry.setPreviousRevisionDate(previousDateCalendar);
        repositoryLogEntry.setPreviousRevision(modelBusLogEntry.getPreviousRevision());
        return repositoryLogEntry;
    }
}

