/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.notification;

import org.modelbus.core.lib.notification.ModelBusTopicListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.core.lib.notification.NotificationLocationStatus;
import org.modelbus.core.lib.util.LocationsUtilFactory;

public class ModelbusNotificationPingThread
extends Thread {
    private final long interval;
    private boolean stop = false;

    public ModelbusNotificationPingThread(long interval) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Value for ping interval has to be non negative.");
        }
        this.interval = interval;
    }

    @Override
    public void run() {
        NotificationLocationStatus notificationLocationStatus = NotificationListenerManager.getNotificationListenerManager().getNotificationLocationStatus();
        while (!this.stop) {
            try {
                String notificationLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getNotificationLocation();
                if (notificationLocation != null) {
                    notificationLocationStatus.setAvailable(true);
                    ModelBusTopicListener.getTopicListener().setUrl(notificationLocation);
                } else {
                    notificationLocationStatus.setAvailable(false);
                }
            }
            catch (Exception exception) {
                notificationLocationStatus.setAvailable(false);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void kill() {
        this.stop = true;
    }
}

