/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.modelbus.core.lib.util.DynamicEFactoryInvocationHandler;
import org.modelbus.core.lib.util.DynamicModelElementImpl;

public class DynamicEFactoryImpl
extends EFactoryImpl {
    public EObject create(EClass eClass) {
        if (DynamicEFactoryImpl.isEModelElement(eClass)) {
            return new DynamicModelElementImpl();
        }
        if (this.getEPackage() != eClass.getEPackage() || eClass.isAbstract()) {
            throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
        EList eSuperTypes = eClass.getESuperTypes();
        while (!eSuperTypes.isEmpty()) {
            EClass eSuperType = (EClass)eSuperTypes.get(0);
            if (eSuperType.getInstanceClass() != null) {
                if (DynamicEFactoryImpl.isEModelElement(eSuperType)) {
                    DynamicModelElementImpl result = new DynamicModelElementImpl();
                    ((InternalEObject)result).eSetClass(eClass);
                    return result;
                }
                EObject result = eSuperType.getEPackage().getEFactoryInstance().create(eSuperType);
                ((InternalEObject)result).eSetClass(eClass);
                return result;
            }
            eSuperTypes = eSuperType.getESuperTypes();
        }
        return this.basicCreate(eClass);
    }

    protected static boolean isEModelElement(EClass type) {
        return "EModelElement".equals(type.getName()) && "ecore".equals(type.getEPackage().getNsPrefix());
    }

    public String convertToString(EDataType eDataType, Object objectValue) {
        Proxy proxy;
        if (objectValue instanceof Proxy && Proxy.getInvocationHandler(proxy = (Proxy)objectValue) instanceof DynamicEFactoryInvocationHandler) {
            return ((DynamicEFactoryInvocationHandler)Proxy.getInvocationHandler(proxy)).getValue();
        }
        return super.convertToString(eDataType, objectValue);
    }

    public Object createFromString(EDataType eDataType, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (eDataType.getName().equals("UnlimitedNatural") && stringValue.equals("*")) {
            stringValue = String.valueOf(-1);
        }
        if (this.getEPackage() != eDataType.getEPackage()) {
            throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
        if (eDataType instanceof EEnum) {
            EEnumLiteral result = ((EEnum)eDataType).getEEnumLiteralByLiteral(stringValue);
            if (result == null) {
                throw new IllegalArgumentException("The value '" + stringValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
            }
            return result;
        }
        switch (ExtendedMetaData.INSTANCE.getWhiteSpaceFacet(eDataType)) {
            case 2: {
                stringValue = this.replaceWhiteSpace(stringValue);
                break;
            }
            case 3: {
                stringValue = this.collapseWhiteSpace(stringValue);
            }
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return EcoreUtil.createFromString((EDataType)baseType, (String)stringValue);
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(stringValue);
            while (stringTokenizer.hasMoreTokens()) {
                String item = stringTokenizer.nextToken();
                result.add(EcoreUtil.createFromString((EDataType)itemType, (String)item));
            }
            return result;
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            for (EDataType memberType : memberTypes) {
                try {
                    Object result = EcoreUtil.createFromString((EDataType)memberType, (String)stringValue);
                    if (result == null) continue;
                    return result;
                }
                catch (RuntimeException runtimeException) {}
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' does not match any member types of the union datatype '" + eDataType.getName() + "'");
        }
        Class c = EcoreUtil.wrapperClassFor((Class)eDataType.getInstanceClass());
        if (c == null) {
            return null;
        }
        if (c == Character.class) {
            char charValue = '\u0000';
            try {
                charValue = (char)Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                char[] carray = stringValue.toCharArray();
                charValue = carray[0];
            }
            return Character.valueOf(charValue);
        }
        if (c == Date.class) {
            int i = 0;
            while (i < EDATE_FORMATS.length) {
                try {
                    return EDATE_FORMATS[i].parse(stringValue);
                }
                catch (ParseException parseException) {
                    ++i;
                }
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' is not a date formatted string of the form yyyy-MM-dd'T'HH:mm:ss'.'SSSZ or a valid subset thereof");
        }
        Class<String> stringClass = String.class;
        Class[] signature = new Class[]{stringClass};
        Constructor ctor = null;
        try {
            ctor = c.getConstructor(signature);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Throwable formatException = null;
        try {
            if (ctor != null) {
                Object[] ctorArgs = new Object[]{stringValue};
                return ctor.newInstance(ctorArgs);
            }
        }
        catch (InstantiationException e) {
            formatException = e;
        }
        catch (InvocationTargetException e) {
            formatException = e.getCause();
        }
        catch (IllegalAccessException e) {
            formatException = e;
        }
        Method valueOf = null;
        try {
            valueOf = c.getMethod("valueOf", signature);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            if (valueOf != null) {
                Object[] valueOfArgs = new Object[]{stringValue};
                return valueOf.invoke(null, valueOfArgs);
            }
        }
        catch (IllegalArgumentException e) {
            formatException = e;
        }
        catch (InvocationTargetException e) {
            formatException = e.getCause();
        }
        catch (IllegalAccessException e) {
            formatException = e;
        }
        String exceptionString = formatException != null ? formatException.toString() : "";
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(eDataType.getInstanceTypeName());
            if (clazz.isInterface()) {
                return Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new DynamicEFactoryInvocationHandler(stringValue));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("The value '" + stringValue + "' is invalid. " + exceptionString, formatException);
    }
}

