/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

public class ServicesUtil {
    private static final int PORT_MIN = 1;
    private static final int PORT_MAX = 49151;

    public static int getNextAvailablePort(int successor) {
        if (successor < 1 || successor > 49151) {
            throw new IllegalArgumentException("Invalid port: " + successor);
        }
        int x = successor;
        while (x <= 49151) {
            if (ServicesUtil.isPortAvailable(x)) {
                return x;
            }
            ++x;
        }
        throw new RuntimeException("No available port above: " + successor);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPortAvailable(int port) {
        if (port < 1 || port > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        DatagramSocket diagramSocket = null;
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket(port);
        serverSocket.setReuseAddress(true);
        diagramSocket = new DatagramSocket(port);
        diagramSocket.setReuseAddress(true);
        if (diagramSocket != null) {
            diagramSocket.close();
        }
        if (serverSocket == null) return true;
        try {
            serverSocket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (diagramSocket != null) {
                    diagramSocket.close();
                }
                if (serverSocket == null) return false;
            }
            catch (Throwable throwable) {
                if (diagramSocket != null) {
                    diagramSocket.close();
                }
                if (serverSocket == null) throw throwable;
                try {
                    serverSocket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                serverSocket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }
}

