/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(JettyHttpProducer.class);
    private final HttpClient client;
    private JettyHttpBinding binding;

    public JettyHttpProducer(Endpoint endpoint, HttpClient client) {
        super(endpoint);
        this.client = client;
        ObjectHelper.notNull(client, "HttpClient", this);
    }

    public JettyHttpEndpoint getEndpoint() {
        return (JettyHttpEndpoint)((Object)super.getEndpoint());
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            JettyContentExchange httpExchange = this.createHttpExchange(exchange, callback);
            JettyHttpProducer.doSendExchange(this.client, httpExchange);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        return false;
    }

    protected JettyContentExchange createHttpExchange(Exchange exchange, AsyncCallback callback) throws Exception {
        String url = HttpHelper.createURL((Exchange)exchange, (HttpEndpoint)this.getEndpoint());
        HttpMethods methodToUse = HttpHelper.createMethod((Exchange)exchange, (HttpEndpoint)this.getEndpoint(), (exchange.getIn().getBody() != null ? 1 : 0) != 0);
        String method = methodToUse.createMethod(url).getName();
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)method);
        JettyContentExchange httpExchange = new JettyContentExchange(exchange, this.getBinding(), this.client);
        httpExchange.setMethod(method);
        httpExchange.setURL(url);
        this.doSetQueryParameters(exchange, httpExchange);
        if (HttpMethods.POST.equals((Object)methodToUse) || HttpMethods.PUT.equals((Object)methodToUse)) {
            String contentType = ExchangeHelper.getContentType(exchange);
            if (contentType != null) {
                httpExchange.setRequestContentType(contentType);
            }
            if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                Serializable obj = exchange.getIn().getMandatoryBody(Serializable.class);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(bos.toByteArray()));
                IOHelper.close(bos);
            } else {
                String data = exchange.getIn().getBody(String.class);
                if (data != null) {
                    String charset = exchange.getProperty("CamelCharsetName", String.class);
                    if (charset != null) {
                        httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(data, charset));
                    } else {
                        httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(data));
                    }
                } else {
                    InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, exchange.getIn().getBody());
                    httpExchange.setRequestContentSource(is);
                }
            }
        }
        Map<String, Object> skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", Boolean.TRUE);
            String queryString = exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery(queryString);
            }
        }
        Message in = exchange.getIn();
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : in.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object headerValue = in.getHeader(key);
            if (headerValue == null) continue;
            Iterator<Object> it = ObjectHelper.createIterator(headerValue, null, true);
            ArrayList<String> values = new ArrayList<String>();
            while (it.hasNext()) {
                Object skipValue;
                String value = exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) && ObjectHelper.equal(skipValue = skipRequestHeaders.get(key), value) || value == null || strategy == null || strategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
                values.add(value);
            }
            if (values.size() <= 0) continue;
            String s = values.size() > 1 ? ((Object)values).toString() : (String)values.get(0);
            httpExchange.addRequestHeader(key, s);
        }
        httpExchange.setCallback(callback);
        return httpExchange;
    }

    private void doSetQueryParameters(Exchange exchange, JettyContentExchange httpExchange) throws URISyntaxException {
        String queryString = exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = this.getEndpoint().getHttpUri().getQuery();
        }
        if (ObjectHelper.isEmpty(queryString)) {
            return;
        }
        String uri = httpExchange.getRequestURI();
        Map<Object, Object> parameters = URISupport.parseParameters(new URI(uri));
        parameters.putAll(URISupport.parseQuery(queryString));
        if (uri.contains("?")) {
            uri = ObjectHelper.before(uri, "?");
        }
        if (!parameters.isEmpty()) {
            uri = uri + "?" + URISupport.createQueryString(parameters);
            httpExchange.setRequestURI(uri);
        }
    }

    protected static void doSendExchange(HttpClient client, JettyContentExchange httpExchange) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending HTTP request to: {}", (Object)httpExchange.getUrl());
        }
        client.send((HttpExchange)httpExchange);
    }

    public JettyHttpBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JettyHttpBinding binding) {
        this.binding = binding;
    }

    @Override
    protected void doStart() throws Exception {
        this.client.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.client.stop();
    }
}

