/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.auth.api;

import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.dosgi.repository.descriptor.Property;
import org.modelbus.dosgi.repository.descriptor.Session;

public class UserSessionHelper {
    private Session session = null;
    private String username;
    private String password;
    private ResourceSet resourceSet;
    private static Display display;

    private UserSessionHelper() {
    }

    public static UserSessionHelper getInstance() {
        return (UserSessionHelper)SingletonUtil.getSessionInstance(UserSessionHelper.class);
    }

    public synchronized Session getSession() {
        if (UserSessionHelper.isEmpty(this.username) || UserSessionHelper.isEmpty(this.password)) {
            return null;
        }
        if (this.session == null) {
            this.session = new Session();
            this.session.setId("1234567890abcdefghijklmnopqrstuvwxyz");
            Property propertyUserName = new Property();
            propertyUserName.setKey("username");
            propertyUserName.setValue(this.username);
            Property propertyPassword = new Property();
            propertyPassword.setKey("password");
            propertyPassword.setValue(this.password);
            List properties = this.session.getProperties();
            properties.add(propertyUserName);
            properties.add(propertyPassword);
        }
        return this.session;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String usernameSet) {
        this.username = usernameSet;
        this.session = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwordSet) {
        this.password = passwordSet;
        this.session = null;
    }

    public void destroySession() {
        if (this.getSession() == null) {
            return;
        }
        this.setUsername(null);
        this.setPassword(null);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        ModelBusDesktopUtil.getInstance().getStatus().setAvailable(false);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    public static Display getDisplay() {
        return display;
    }

    public static void setDisplay(Display display) {
        UserSessionHelper.display = display;
    }
}

