/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.concurrent.BlockingQueue;
import net.engio.mbassy.bus.MessagePublication;

class MessageDispatcher
extends Thread {
    private final BlockingQueue<MessagePublication> messages;
    private volatile boolean isRunning = true;

    MessageDispatcher(BlockingQueue<MessagePublication> pendingMessages) {
        super("Message Dispatcher");
        this.messages = pendingMessages;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                MessagePublication message = this.messages.take();
                if (message instanceof MarkerMessage) continue;
                message.execute();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    void stopDispatcher() {
        this.isRunning = false;
        this.messages.clear();
        this.messages.add(new MarkerMessage());
    }

    private final class MarkerMessage
    extends MessagePublication {
        public MarkerMessage() {
            super(null, null, null, null);
        }
    }
}

