/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SubmitOrderedCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final DelayQueue<SubmitOrderFutureTask> completionQueue = new DelayQueue();
    private final AtomicInteger id = new AtomicInteger();
    private final AtomicInteger index = new AtomicInteger();

    public SubmitOrderedCompletionService(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Future<V> submit(Callable task) {
        if (task == null) {
            throw new IllegalArgumentException("Task must be provided");
        }
        SubmitOrderFutureTask f = new SubmitOrderFutureTask(this.id.incrementAndGet(), task);
        this.executor.execute(f);
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, Object result) {
        if (task == null) {
            throw new IllegalArgumentException("Task must be provided");
        }
        SubmitOrderFutureTask f = new SubmitOrderFutureTask(this.id.incrementAndGet(), task, null);
        this.executor.execute(f);
        return f;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        this.index.incrementAndGet();
        return (Future)this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        this.index.incrementAndGet();
        Future answer = (Future)this.completionQueue.poll();
        if (answer == null) {
            this.index.decrementAndGet();
        }
        return answer;
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.index.incrementAndGet();
        Future answer = (Future)this.completionQueue.poll(timeout, unit);
        if (answer == null) {
            this.index.decrementAndGet();
        }
        return answer;
    }

    public void timeoutTask() {
        this.index.incrementAndGet();
    }

    private class SubmitOrderFutureTask
    extends FutureTask<V>
    implements Delayed {
        private final long id;

        public SubmitOrderFutureTask(long id, Callable<V> voidCallable) {
            super(voidCallable);
            this.id = id;
        }

        public SubmitOrderFutureTask(long id, Runnable runnable, V result) {
            super(runnable, result);
            this.id = id;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.id - (long)SubmitOrderedCompletionService.this.index.get();
        }

        @Override
        public int compareTo(Delayed o) {
            SubmitOrderFutureTask other = (SubmitOrderFutureTask)o;
            return (int)(this.id - other.id);
        }

        @Override
        protected void done() {
            SubmitOrderedCompletionService.this.completionQueue.add(this);
        }

        @Override
        public String toString() {
            return "SubmitOrderedFutureTask[" + (this.id - 1L) + "]";
        }
    }
}

