/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.impl;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.ModelBusNodeKind;

public class ModelBusDirEntryImpl
implements IModelBusDirEntry {
    protected String name;
    protected ModelBusNodeKind kind;
    protected long size;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected String revision;
    protected Date creationDate;
    protected String lastAuthor;
    protected String commitMessage;
    protected String url;
    protected String repositoryLocation;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ModelBusNodeKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(ModelBusNodeKind kind) {
        this.kind = kind;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void addProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    @Override
    public String getProperty(String propertyName) {
        if (this.properties.containsKey(propertyName)) {
            return this.properties.get(propertyName);
        }
        return null;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public String getLastAuthor() {
        return this.lastAuthor;
    }

    @Override
    public void setLastAuthor(String lastAuthor) {
        this.lastAuthor = lastAuthor;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    protected static String convertSVNURLtoModelBusURL(String svnUrl, String svnRepositoryLocation) throws MalformedURLException {
        URI uri = URI.createURI((String)svnUrl);
        String uriPath = uri.isFile() && !uri.isRelative() ? svnUrl.substring("file://".length()) : uri.path();
        try {
            uriPath = URLDecoder.decode(uriPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        if (uriPath.startsWith(svnRepositoryLocation)) {
            String resultUrlString = uriPath;
            resultUrlString = uriPath.substring(svnRepositoryLocation.length(), resultUrlString.length());
            resultUrlString = "http:/" + resultUrlString;
            return resultUrlString;
        }
        System.out.println("could path not convert path '" + svnUrl + "' with svn location " + svnRepositoryLocation);
        System.err.println("could path not convert path '" + svnUrl + "' with svn location " + svnRepositoryLocation);
        throw new RuntimeException("could path not convert path '" + svnUrl + "' with svn location " + svnRepositoryLocation);
    }
}

