/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.resource.io;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.modelbus.services.repository.server.resource.io.IResourceHandler;

public class ResourceHandlerFactory {
    private static final String EXTENSION_POINT_ID = "org.modelbus.services.repository.server.resource.io";
    private static ResourceHandlerFactory _instance;
    protected IExtension[] extensions;

    private ResourceHandlerFactory() {
    }

    public static synchronized ResourceHandlerFactory getInstance() {
        if (_instance == null) {
            _instance = new ResourceHandlerFactory();
            _instance.initialize();
        }
        return _instance;
    }

    public IResourceHandler getResourceHandlerForContentType(String contentType) {
        IExtension[] iExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement c = iConfigurationElementArray[n4];
                String currentRepoType = c.getAttribute("contentType");
                if (currentRepoType.toLowerCase().equals(contentType.toLowerCase())) {
                    IResourceHandler repo;
                    try {
                        repo = (IResourceHandler)c.createExecutableExtension("handlerClass");
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                    return repo;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    protected void initialize() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            this.extensions = new IExtension[0];
            return;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        this.extensions = extensionPoint.getExtensions();
    }
}

