/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.compare;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.modelbus.tools.diffmerge.compare.DiffModelDiffEngine;
import org.modelbus.tools.diffmerge.compare.MatchInspectorPostProcessor;
import org.modelbus.tools.diffmerge.match.MatchInspector;
import org.modelbus.tools.diffmerge.match.Matcher;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

class ComparatorBuilder
implements EventBusParticipant {
    private final EMFCompare comparator;
    private IDiffEngine diffEngine;
    private final Collection<MatchInspector> inspectors;

    ComparatorBuilder(Matcher matcher, Collection<MatchInspector> inspectors) {
        this.inspectors = inspectors;
        this.comparator = this.createDefaultComparator(matcher);
    }

    EMFCompare getComparator() {
        return this.comparator;
    }

    private EMFCompare createDefaultComparator(Matcher matcher) {
        IMatchEngine.Factory.Registry matchEngineRegistry = matcher.getMatchEngineFactoryRegistry();
        this.createNewDiffEngine();
        IPostProcessor.Descriptor.Registry registry = this.createProcessorRegistry();
        EMFCompare comparator = EMFCompare.builder().setPostProcessorRegistry(registry).setDiffEngine(this.diffEngine).setMatchEngineFactoryRegistry(matchEngineRegistry).build();
        return comparator;
    }

    private IPostProcessor.Descriptor.Registry createProcessorRegistry() {
        PostProcessorDescriptorRegistryImpl registry = new PostProcessorDescriptorRegistryImpl();
        for (MatchInspector inspector : this.inspectors) {
            MatchInspectorPostProcessor postProcessor = new MatchInspectorPostProcessor(inspector);
            String uri = inspector.getNamespaceURI();
            if (uri == null) {
                throw new RuntimeException("No namespace URI defined in " + inspector.getClass().getName());
            }
            Pattern namespaceURI = Pattern.compile(inspector.getNamespaceURI());
            BasicPostProcessorDescriptorImpl descriptor = new BasicPostProcessorDescriptorImpl((IPostProcessor)postProcessor, namespaceURI, null);
            registry.put((Object)inspector.getClass().getName(), (IPostProcessor.Descriptor)descriptor);
        }
        return registry;
    }

    private void createNewDiffEngine() {
        DiffBuilder processor = new DiffBuilder();
        this.diffEngine = new DiffModelDiffEngine((IDiffProcessor)processor);
    }

    public Collection<Object> getAllEventHandlers() {
        return Lists.newArrayList((Object[])new Object[]{this.diffEngine, this});
    }

    public ModelBusEventBus getEventBus() {
        throw new UnsupportedOperationException();
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new UnsupportedOperationException();
    }
}

