/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.status;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelbus.desktop.Activator;
import org.modelbus.desktop.status.ModelBusStatusProvider;
import org.modelbus.desktop.util.ModelBusDesktopUtil;

public class ModelBusStatusLineContributionItem
extends ContributionItem
implements Observer {
    private static final String AV_ICON_PATH = "/icons/status/modelbus_av.gif";
    private static final String UNAV_ICON_PATH = "/icons/status/modelbus_unav.gif";
    private static final String AV_LABEL = "ModelBus available";
    private static final String UNAV_LABEL = "ModelBus unavailable";
    private Image statusImage;
    private Composite parent;
    private Canvas canvas;

    public ModelBusStatusLineContributionItem(String id) {
        super(id);
    }

    public void fill(Composite parent) {
        this.parent = parent;
        this.canvas = new Canvas(parent, 0);
        this.canvas.setSize(16, 32);
        this.statusImage = Activator.getImageDescriptor(UNAV_ICON_PATH).createImage();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ModelBusStatusLineContributionItem.this.statusImage != null && !ModelBusStatusLineContributionItem.this.statusImage.isDisposed()) {
                    e.gc.drawImage(ModelBusStatusLineContributionItem.this.statusImage, 30, 3);
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.modelbus.desktop.statusView");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.canvas.setToolTipText(UNAV_LABEL);
        this.updateControls();
    }

    private void updateControls() {
        if (this.parent == null || this.parent.isDisposed()) {
            return;
        }
        this.parent.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ModelBusStatusLineContributionItem.this.canvas.isDisposed()) {
                    return;
                }
                if (ModelBusDesktopUtil.getInstance().getStatus().isAvailable()) {
                    ModelBusStatusLineContributionItem.this.statusImage = Activator.getImageDescriptor(ModelBusStatusLineContributionItem.AV_ICON_PATH).createImage();
                    ModelBusStatusLineContributionItem.this.canvas.setToolTipText("ModelBus available (Last response: " + ModelBusStatusProvider.DATE_FORMAT.format(ModelBusDesktopUtil.getInstance().getStatus().getLastResponse()) + ")");
                } else {
                    ModelBusStatusLineContributionItem.this.statusImage = Activator.getImageDescriptor(ModelBusStatusLineContributionItem.UNAV_ICON_PATH).createImage();
                    ModelBusStatusLineContributionItem.this.canvas.setToolTipText(ModelBusDesktopUtil.getInstance().getStatus().getStatusMessage());
                }
                ModelBusStatusLineContributionItem.this.canvas.redraw();
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateControls();
    }
}

