/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.manager.defaulttheme.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MenuBarManager
extends MenuManager {
    private static final String MENU_BAR_VARIANT = "menuBar";
    private Composite menuParent;
    private final List toolItemList = new ArrayList();
    private ToolBar toolbar;

    public void fill(Composite parent) {
        this.menuParent = parent;
        this.toolbar = new ToolBar(parent, 64);
        this.toolbar.setData("org.eclipse.rap.rwt.customVariant", (Object)MENU_BAR_VARIANT);
        this.update(false, false);
    }

    protected void update(boolean force, boolean recursive) {
        super.update(force, recursive);
        if (this.menuParent != null && (force || this.isDirty())) {
            this.disposeToolItems();
            IContributionItem[] items = this.getItems();
            if (items.length > 0 && this.menuParent != null) {
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (item.isVisible()) {
                        this.makeEntry(item);
                    }
                    ++n2;
                }
            }
            this.menuParent.layout(true, true);
        }
    }

    private void disposeToolItems() {
        int i = 0;
        while (i < this.toolItemList.size()) {
            ToolItem item = (ToolItem)this.toolItemList.get(i);
            if (!item.isDisposed()) {
                Menu menu;
                Object data = item.getData();
                if (data != null && data instanceof Menu && !(menu = (Menu)data).isDisposed()) {
                    menu.dispose();
                }
                item.dispose();
            }
            ++i;
        }
    }

    private void makeEntry(IContributionItem item) {
        IContributionItem tempItem = null;
        if (item instanceof SubContributionItem) {
            SubContributionItem subItem = (SubContributionItem)item;
            tempItem = subItem.getInnerItem();
        } else if (item instanceof MenuManager) {
            tempItem = item;
        }
        if (tempItem != null && tempItem instanceof MenuManager) {
            MenuManager manager = (MenuManager)tempItem;
            int style = this.extractStyle(manager);
            ToolItem toolItem = new ToolItem(this.toolbar, style);
            toolItem.setText(manager.getMenuText());
            toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)MENU_BAR_VARIANT);
            this.createMenu(manager, toolItem);
            this.toolItemList.add(toolItem);
        }
    }

    private int extractStyle(MenuManager manager) {
        int style = 0;
        if (manager.getItems() != null && manager.getItems().length > 0) {
            style = 4;
        }
        return style;
    }

    private void createMenu(final MenuManager manager, final ToolItem toolItem) {
        final Menu menu = new Menu((Control)this.menuParent);
        toolItem.setData((Object)menu);
        menu.setData("org.eclipse.rap.rwt.customVariant", (Object)MENU_BAR_VARIANT);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem[] menuItems;
                MenuItem[] menuItemArray = menuItems = menu.getItems();
                int n = menuItems.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem2 = menuItemArray[n2];
                    menuItem2.dispose();
                    ++n2;
                }
                this.hookMenuToToolItem(manager, menu);
                Display display = toolItem.getDisplay();
                Rectangle bounds = toolItem.getBounds();
                int leftIndent = bounds.x;
                int topIndent = bounds.y + bounds.height;
                Point indent = new Point(leftIndent, topIndent);
                Point menuLocation = display.map((Control)MenuBarManager.this.toolbar, (Control)MenuBarManager.this.toolbar.getShell(), indent);
                menu.setLocation(menuLocation);
                menu.setData("org.eclipse.rap.rwt.customVariant", (Object)MenuBarManager.MENU_BAR_VARIANT);
                MenuBarManager.this.styleMenuItems(menu);
                menu.setVisible(true);
            }

            private void hookMenuToToolItem(MenuManager manager2, Menu menu2) {
                IContributionItem[] contribItems = manager2.getItems();
                if (contribItems != null && contribItems.length > 0) {
                    int i = 0;
                    while (i < contribItems.length) {
                        if (i > 0 || !(contribItems[i] instanceof Separator)) {
                            contribItems[i].fill(menu2, -1);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void styleMenuItems(Menu menu) {
        MenuItem[] items = menu.getItems();
        if (items != null && items.length > 0) {
            MenuItem[] menuItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.setData("org.eclipse.rap.rwt.customVariant", (Object)MENU_BAR_VARIANT);
                Menu subMenu = item.getMenu();
                if (subMenu != null) {
                    subMenu.setData("org.eclipse.rap.rwt.customVariant", (Object)MENU_BAR_VARIANT);
                    this.styleMenuItems(subMenu);
                }
                ++n2;
            }
        }
    }

    public ToolBar getMenuToolBar() {
        return this.toolbar;
    }
}

